/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.inspector;

import de.statspez.sdf.generator.inspector.Field;
import de.statspez.sdf.generator.inspector.FieldGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldGroupImpl
implements FieldGroup {
    private final String name;
    private final Object context;
    private final Map<String, Field> fieldsMap;
    private final Map<String, List<FieldGroup>> fieldGroupsMap;

    public FieldGroupImpl(String name, Object context) {
        this.name = name;
        this.context = context;
        this.fieldsMap = new HashMap<String, Field>();
        this.fieldGroupsMap = new HashMap<String, List<FieldGroup>>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    public void addField(Field field) {
        this.fieldsMap.put(field.getName(), field);
    }

    @Override
    public Field getField(String name) {
        return this.fieldsMap.get(name);
    }

    @Override
    public Collection<Field> getFields() {
        return this.fieldsMap.values();
    }

    public void addFieldGroup(FieldGroupImpl fieldGroup) {
        List<FieldGroup> fieldGroupList = this.getFieldGroupList(fieldGroup.getName());
        if (fieldGroupList == null) {
            fieldGroupList = new ArrayList<FieldGroup>();
            this.fieldGroupsMap.put(fieldGroup.getName(), fieldGroupList);
        }
        fieldGroupList.add(fieldGroup);
    }

    @Override
    public Collection<List<FieldGroup>> getFieldGroups() {
        return this.fieldGroupsMap.values();
    }

    @Override
    public List<FieldGroup> getFieldGroupList(String name) {
        return this.fieldGroupsMap.get(name);
    }
}

