/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.saiku.datasources.datasource.SaikuDatasource;
import org.saiku.service.datasource.DatasourceService;
import org.saiku.service.util.exception.SaikuServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Path(value="/saiku/{username}/datasources")
public class DataSourceResource {
    DatasourceService datasourceService;
    private static final Logger log = LoggerFactory.getLogger(DataSourceResource.class);

    public void setDatasourceService(DatasourceService ds) {
        this.datasourceService = ds;
    }

    @GET
    @Produces(value={"application/json"})
    public Collection<SaikuDatasource> getDatasources() {
        try {
            return this.datasourceService.getDatasources().values();
        }
        catch (SaikuServiceException e) {
            log.error(this.getClass().getName(), (Throwable)e);
            return new ArrayList<SaikuDatasource>();
        }
    }

    @DELETE
    @Path(value="/{datasource}")
    public Response.Status deleteDatasource(@PathParam(value="datasource") String datasourceName) {
        this.datasourceService.removeDatasource(datasourceName);
        return Response.Status.GONE;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{datasource}")
    public SaikuDatasource getDatasource(@PathParam(value="datasource") String datasourceName) {
        return this.datasourceService.getDatasource(datasourceName);
    }
}

