/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.saiku.service.olap.OlapQueryService;
import org.saiku.web.rest.objects.SavedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Path(value="/saiku/{username}/repository")
@XmlAccessorType(value=XmlAccessType.NONE)
public class BasicRepositoryResource {
    private static final Logger log = LoggerFactory.getLogger(BasicRepositoryResource.class);
    private OlapQueryService olapQueryService;
    private FileObject repo;

    public void setPath(String path) throws Exception {
        try {
            FileSystemManager fileSystemManager;
            FileObject fileObject;
            if (!path.endsWith("" + File.separatorChar)) {
                path = path + File.separatorChar;
            }
            if ((fileObject = (fileSystemManager = VFS.getManager()).resolveFile(path)) == null) {
                throw new IOException("File cannot be resolved: " + path);
            }
            if (!fileObject.exists()) {
                throw new IOException("File does not exist: " + path);
            }
            this.repo = fileObject;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Autowired
    public void setOlapQueryService(OlapQueryService olapqs) {
        this.olapQueryService = olapqs;
    }

    @GET
    @Produces(value={"application/json"})
    public List<SavedQuery> getSavedQueries() {
        ArrayList<SavedQuery> queries;
        block5: {
            queries = new ArrayList<SavedQuery>();
            try {
                if (this.repo != null) {
                    File[] files;
                    for (File file : files = new File(this.repo.getName().getPath()).listFiles()) {
                        if (file.isHidden()) continue;
                        SimpleDateFormat sf = new SimpleDateFormat("dd - MMM - yyyy HH:mm:ss");
                        String filename = file.getName();
                        if (!filename.endsWith(".saiku")) continue;
                        filename = filename.substring(0, filename.length() - ".saiku".length());
                        FileReader fi = new FileReader(file);
                        BufferedReader br = new BufferedReader(fi);
                        String chunk = "";
                        String xml = "";
                        while ((chunk = br.readLine()) != null) {
                            xml = xml + chunk + "\n";
                        }
                        SavedQuery sq = new SavedQuery(filename, sf.format(new Date(file.lastModified())), xml);
                        queries.add(sq);
                    }
                    break block5;
                }
                throw new Exception("repo URL is null");
            }
            catch (Exception e) {
                log.error(this.getClass().getName(), (Throwable)e);
                e.printStackTrace();
            }
        }
        Collections.sort(queries);
        return queries;
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{queryname}")
    public Response.Status deleteQuery(@PathParam(value="queryname") String queryName) {
        try {
            if (this.repo != null) {
                FileObject queryFile;
                if (!queryName.endsWith(".saiku")) {
                    queryName = queryName + ".saiku";
                }
                if ((queryFile = this.repo.resolveFile(queryName)).delete()) {
                    return Response.Status.GONE;
                }
            }
            throw new Exception("Cannot delete query file:" + queryName);
        }
        catch (Exception e) {
            log.error("Cannot delete query (" + queryName + ")", (Throwable)e);
            return Response.Status.NOT_FOUND;
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{queryname}")
    public Response.Status saveQuery(@PathParam(value="queryname") String queryName, @FormParam(value="newname") String newName) {
        try {
            String xml = this.olapQueryService.getQueryXml(queryName);
            if (newName != null) {
                queryName = newName;
            }
            if (this.repo != null && xml != null) {
                File queryFile;
                String uri;
                if (!queryName.endsWith(".saiku")) {
                    queryName = queryName + ".saiku";
                }
                if (!(uri = this.repo.getName().getPath()).endsWith("" + File.separatorChar)) {
                    uri = uri + File.separatorChar;
                }
                if ((queryFile = new File(uri + URLDecoder.decode(queryName, "UTF-8"))).exists()) {
                    queryFile.delete();
                } else {
                    queryFile.createNewFile();
                }
                FileWriter fw = new FileWriter(queryFile);
                fw.write(xml);
                fw.close();
                return Response.Status.OK;
            }
            throw new Exception("Cannot save query because repo or xml is null repo(" + (this.repo == null) + ") xml(" + (xml == null) + " )");
        }
        catch (Exception e) {
            log.error("Cannot save query (" + queryName + ")", (Throwable)e);
            return Response.Status.NOT_FOUND;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{queryname}")
    public SavedQuery loadQuery(@PathParam(value="queryname") String queryName) {
        try {
            String uri = this.repo.getName().getPath();
            if (uri != null && !uri.endsWith("" + File.separatorChar)) {
                uri = uri + File.separatorChar;
            }
            String filename = queryName;
            if (uri != null) {
                File queryFile;
                String filepath;
                if (!filename.endsWith(".saiku")) {
                    filename = filename + ".saiku";
                }
                if (!(filepath = this.repo.getName().getPath()).endsWith("" + File.separatorChar)) {
                    filepath = filepath + File.separatorChar;
                }
                if ((queryFile = new File(uri + filename)).exists()) {
                    FileReader fi = new FileReader(queryFile);
                    BufferedReader br = new BufferedReader(fi);
                    String chunk = "";
                    String xml = "";
                    while ((chunk = br.readLine()) != null) {
                        xml = xml + chunk + "\n";
                    }
                    SimpleDateFormat sf = new SimpleDateFormat("dd - MMM - yyyy HH:mm:ss");
                    SavedQuery sq = new SavedQuery(filename, sf.format(new Date(queryFile.lastModified())), xml);
                    return sq;
                }
                throw new Exception("File does not exist:" + uri);
            }
            throw new Exception("Cannot save query because uriis null");
        }
        catch (Exception e) {
            log.error("Cannot load query (" + queryName + ")", (Throwable)e);
            return null;
        }
    }
}

