/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.util.export.excel;

import java.util.HashMap;
import java.util.Map;

public class FormatUtil {
    private static final Map<String, MacroToken> MAP = new HashMap<String, MacroToken>();

    public static String getFormatString(String formatString) {
        MacroToken macroToken = MAP.get(formatString);
        if (macroToken == null) {
            return formatString;
        }
        return macroToken.translation;
    }

    static {
        for (MacroToken macroToken : MacroToken.values()) {
            MAP.put(macroToken.token, macroToken);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MacroToken
    extends Enum<MacroToken> {
        public static final /* enum */ MacroToken CURRENCY = new MacroToken("Currency", null, "Shows currency values according to the locale's CurrencyFormat.  Negative numbers are inside parentheses.");
        public static final /* enum */ MacroToken FIXED = new MacroToken("Fixed", "0", "Shows at least one digit.");
        public static final /* enum */ MacroToken STANDARD = new MacroToken("Standard", "#,##0", "Uses a thousands separator.");
        public static final /* enum */ MacroToken PERCENT = new MacroToken("Percent", "0.00%", "Multiplies the value by 100 with a percent sign at the end.");
        public static final /* enum */ MacroToken SCIENTIFIC = new MacroToken("Scientific", "0.00e+00", "Uses standard scientific notation.");
        public static final /* enum */ MacroToken LONG_DATE = new MacroToken("Long Date", "dddd, mmmm dd, yyyy", "Uses the Long Date format specified in the Regional Settings dialog box of the Microsoft Windows Control Panel.");
        public static final /* enum */ MacroToken MEDIUM_DATE = new MacroToken("Medium Date", "dd-mmm-yy", "Uses the dd-mmm-yy format (for example, 03-Apr-93)");
        public static final /* enum */ MacroToken SHORT_DATE = new MacroToken("Short Date", "m/d/yy", "Uses the Short Date format specified in the Regional Settings dialog box of the Windows Control Panel.");
        public static final /* enum */ MacroToken LONG_TIME = new MacroToken("Long Time", "h:mm:ss AM/PM", "Shows the hour, minute, second, and \"AM\" or \"PM\" using the h:mm:ss format.");
        public static final /* enum */ MacroToken MEDIUM_TIME = new MacroToken("Medium Time", "h:mm AM/PM", "Shows the hour, minute, and \"AM\" or \"PM\" using the \"hh:mm AM/PM\" format.");
        public static final /* enum */ MacroToken SHORT_TIME = new MacroToken("Short Time", "hh:mm", "Shows the hour and minute using the hh:mm format.");
        public static final /* enum */ MacroToken YES_NO = new MacroToken("Yes/No", "\\Y\\e\\s;\\Y\\e\\s;\\N\\o;\\N\\o", "Any nonzero numeric value (usually - 1) is Yes. Zero is No.");
        public static final /* enum */ MacroToken TRUE_FALSE = new MacroToken("True/False", "\\T\\r\\u\\e;\\T\\r\\u\\e;\\F\\a\\l\\s\\e;\\F\\a\\l\\s\\e", "Any nonzero numeric value (usually - 1) is True. Zero is False.");
        public static final /* enum */ MacroToken ON_OFF = new MacroToken("On/Off", "\\O\\n;\\O\\n;\\O\\f\\f;\\O\\f\\f", "Any nonzero numeric value (usually - 1) is On. Zero is Off.");
        final String token;
        final String translation;
        final String description;
        private static final /* synthetic */ MacroToken[] $VALUES;

        public static MacroToken[] values() {
            return (MacroToken[])$VALUES.clone();
        }

        public static MacroToken valueOf(String name) {
            return Enum.valueOf(MacroToken.class, name);
        }

        private MacroToken(String token, String translation, String description) {
            this.token = token;
            this.translation = translation;
            this.description = description;
            assert (this.name().equals(token.replace(',', '_').replace(' ', '_').replace('/', '_').toUpperCase()));
            assert (translation == null == this.name().equals("CURRENCY"));
        }

        static {
            $VALUES = new MacroToken[]{CURRENCY, FIXED, STANDARD, PERCENT, SCIENTIFIC, LONG_DATE, MEDIUM_DATE, SHORT_DATE, LONG_TIME, MEDIUM_TIME, SHORT_TIME, YES_NO, TRUE_FALSE, ON_OFF};
        }
    }
}

