/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.util.export.excel;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.saiku.olap.dto.SaikuDimensionSelection;
import org.saiku.olap.dto.SaikuSelection;
import org.saiku.olap.dto.resultset.AbstractBaseCell;
import org.saiku.olap.dto.resultset.CellDataSet;
import org.saiku.olap.dto.resultset.DataCell;
import org.saiku.olap.util.SaikuProperties;
import org.saiku.service.util.exception.SaikuServiceException;
import org.saiku.service.util.export.excel.ExcelMergedRegionItemConfig;
import org.saiku.service.util.export.excel.FormatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelWorksheetBuilder {
    private static final String BASIC_SHEET_FONT_FAMILY = "Arial";
    private static final short BASIC_SHEET_FONT_SIZE = 11;
    private static final String EMPTY_STRING = "";
    private static final String CSS_COLORS_CODE_PROPERTIES = "css-colors-codes.properties";
    private AbstractBaseCell[][] rowsetHeader;
    private AbstractBaseCell[][] rowsetBody;
    private Workbook excelWorkbook;
    private Sheet workbookSheet;
    private String sheetName;
    private int topLeftCornerWidth;
    private int topLeftCornerHeight;
    private CellStyle basicCS;
    private CellStyle numberCS;
    private CellStyle lighterHeaderCellCS;
    private CellStyle darkerHeaderCellCS;
    private List<SaikuDimensionSelection> queryFilters;
    private Map<String, Integer> colorCodesMap;
    private int nextAvailableColorCode = 41;
    private Properties cssColorCodesProperties;
    private HSSFPalette customColorsPalette;
    private static final Logger log = LoggerFactory.getLogger(ExcelWorksheetBuilder.class);

    public ExcelWorksheetBuilder(CellDataSet cellDataSet, List<SaikuDimensionSelection> list, String string) {
        this.init(cellDataSet, list, string);
    }

    protected void init(CellDataSet cellDataSet, List<SaikuDimensionSelection> list, String string) {
        HSSFWorkbook hSSFWorkbook;
        this.queryFilters = list;
        if ("xls".equals(SaikuProperties.webExportExcelFormat)) {
            hSSFWorkbook = new HSSFWorkbook();
            this.customColorsPalette = hSSFWorkbook.getCustomPalette();
            this.excelWorkbook = hSSFWorkbook;
        } else {
            this.excelWorkbook = "xlsx".equals(SaikuProperties.webExportExcelFormat) ? new XSSFWorkbook() : new XSSFWorkbook();
        }
        hSSFWorkbook = this.excelWorkbook.getCreationHelper();
        this.colorCodesMap = new HashMap<String, Integer>();
        this.sheetName = string;
        this.rowsetHeader = cellDataSet.getCellSetHeaders();
        this.rowsetBody = cellDataSet.getCellSetBody();
        this.topLeftCornerWidth = this.findTopLeftCornerWidth();
        this.topLeftCornerHeight = this.findTopLeftCornerHeight();
        this.initCellStyles();
    }

    protected void initCellStyles() {
        Font font = this.excelWorkbook.createFont();
        font.setFontHeightInPoints((short)11);
        font.setFontName(BASIC_SHEET_FONT_FAMILY);
        this.basicCS = this.excelWorkbook.createCellStyle();
        this.basicCS.setFont(font);
        this.basicCS.setAlignment(HorizontalAlignment.LEFT);
        this.setCellBordersColor(this.basicCS);
        this.numberCS = this.excelWorkbook.createCellStyle();
        this.numberCS.setFont(font);
        this.numberCS.setAlignment(HorizontalAlignment.RIGHT);
        this.setCellBordersColor(this.numberCS);
        DataFormat dataFormat = this.excelWorkbook.createDataFormat();
        short s = dataFormat.getFormat(SaikuProperties.webExportExcelDefaultNumberFormat);
        this.numberCS.setDataFormat(s);
        Font font2 = this.excelWorkbook.createFont();
        font2.setFontHeightInPoints((short)11);
        font2.setFontName(BASIC_SHEET_FONT_FAMILY);
        font2.setBold(true);
        this.lighterHeaderCellCS = this.excelWorkbook.createCellStyle();
        this.lighterHeaderCellCS.setFont(font2);
        this.lighterHeaderCellCS.setAlignment(HorizontalAlignment.CENTER);
        this.lighterHeaderCellCS.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        this.lighterHeaderCellCS.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.setCellBordersColor(this.lighterHeaderCellCS);
        this.darkerHeaderCellCS = this.excelWorkbook.createCellStyle();
        this.darkerHeaderCellCS.setFont(font2);
        this.darkerHeaderCellCS.setAlignment(HorizontalAlignment.CENTER);
        this.darkerHeaderCellCS.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.getIndex());
        this.darkerHeaderCellCS.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.setCellBordersColor(this.darkerHeaderCellCS);
    }

    protected void setCellBordersColor(CellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBottomBorderColor(IndexedColors.GREY_80_PERCENT.getIndex());
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.GREY_80_PERCENT.getIndex());
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setLeftBorderColor(IndexedColors.GREY_80_PERCENT.getIndex());
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setRightBorderColor(IndexedColors.GREY_80_PERCENT.getIndex());
    }

    public byte[] build() throws SaikuServiceException {
        int n = this.initExcelSheet();
        int n2 = this.buildExcelTableHeader(n);
        this.addExcelTableRows(n2);
        this.finalizeExcelSheet(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.excelWorkbook.write((OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new SaikuServiceException("Error creating excel export for query", iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void finalizeExcelSheet(int n) {
        int n2 = this.rowsetHeader.length;
        for (int i = 0; i < this.rowsetBody[0].length; ++i) {
            this.workbookSheet.autoSizeColumn(i);
        }
        this.workbookSheet.createFreezePane(0, n + n2, 0, n + n2);
    }

    private int initExcelSheet() {
        this.workbookSheet = this.excelWorkbook.createSheet(this.sheetName);
        this.initSummarySheet();
        return 0;
    }

    private void initSummarySheet() {
        Sheet sheet = this.excelWorkbook.createSheet("Summary page");
        int n = 1;
        Row row = sheet.createRow((int)((short)n));
        Cell cell = row.createCell(0);
        String string = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        cell.setCellValue("Export date and time: " + string);
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 2));
        row = sheet.createRow((int)((short)(n += 2)));
        cell = row.createCell(0);
        cell.setCellValue("Dimension");
        cell = row.createCell(1);
        cell.setCellValue("Level");
        cell = row.createCell(2);
        cell.setCellValue("Filter Applied");
        ++n;
        for (SaikuDimensionSelection saikuDimensionSelection : this.queryFilters) {
            for (SaikuSelection saikuSelection : saikuDimensionSelection.getSelections()) {
                row = sheet.createRow((int)((short)n));
                cell = row.createCell(0);
                cell.setCellValue(saikuSelection.getDimensionUniqueName());
                cell = row.createCell(1);
                cell.setCellValue(saikuSelection.getLevelUniqueName());
                cell = row.createCell(2);
                cell.setCellValue(saikuSelection.getCaption());
                ++n;
            }
        }
        row = sheet.createRow((int)((short)(n += 2)));
        cell = row.createCell(0);
        cell.setCellValue("Export made using Saiku OLAP client.");
        sheet.addMergedRegion(new CellRangeAddress(n, n, 0, 10));
        for (int i = 0; i < 5; ++i) {
            sheet.autoSizeColumn(i);
        }
    }

    private void addExcelTableRows(int n) {
        Row row = null;
        Cell cell = null;
        Object var4_4 = null;
        for (int i = 0; i < this.rowsetBody.length; ++i) {
            row = this.workbookSheet.createRow((short)i + n);
            for (int j = 0; j < this.rowsetBody[i].length; ++j) {
                cell = row.createCell(j);
                String string = this.rowsetBody[i][j].getFormattedValue();
                if (string == null) {
                    string = this.workbookSheet.getRow(row.getRowNum() - 1).getCell(j).getStringCellValue();
                }
                if (this.rowsetBody[i][j] instanceof DataCell && ((DataCell)this.rowsetBody[i][j]).getRawNumber() != null) {
                    Number number = ((DataCell)this.rowsetBody[i][j]).getRawNumber();
                    cell.setCellValue(number.doubleValue());
                    this.applyCellFormatting(cell, i, j);
                    continue;
                }
                cell.setCellStyle(this.basicCS);
                cell.setCellValue(string);
            }
        }
    }

    protected void applyCellFormatting(Cell cell, int n, int n2) {
        String string = ((DataCell)this.rowsetBody[n][n2]).getFormatString();
        if (string != null && string.trim().length() > 0) {
            CellStyle cellStyle = this.excelWorkbook.createCellStyle();
            cellStyle.cloneStyleFrom(this.numberCS);
            DataFormat dataFormat = this.excelWorkbook.createDataFormat();
            string = FormatUtil.getFormatString(string);
            short s = dataFormat.getFormat(string);
            cellStyle.setDataFormat(s);
            Map<String, String> map = ((DataCell)this.rowsetBody[n][n2]).getProperties();
            if (map.containsKey("style")) {
                String string2 = map.get("style");
                short s2 = this.getColorFromCustomPalette(string2);
                if (s2 != -1) {
                    cellStyle.setFillForegroundColor(s2);
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                } else if (this.customColorsPalette == null) {
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    try {
                        int n3 = Integer.parseInt(string2.substring(1, 3), 16);
                        int n4 = Integer.parseInt(string2.substring(3, 5), 16);
                        int n5 = Integer.parseInt(string2.substring(5, 7), 16);
                        ((XSSFCellStyle)cellStyle).setFillForegroundColor(new XSSFColor(new Color(n3, n4, n5)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            cell.setCellStyle(cellStyle);
        } else {
            cell.setCellStyle(this.numberCS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short getColorFromCustomPalette(String string) {
        short s;
        block27: {
            s = -1;
            InputStream inputStream = null;
            if (this.colorCodesMap.containsKey(string)) {
                s = this.colorCodesMap.get(string).shortValue();
            } else {
                try {
                    int n;
                    int n2;
                    int n3;
                    block28: {
                        String string2;
                        if (this.cssColorCodesProperties == null && (inputStream = this.getClass().getResourceAsStream(CSS_COLORS_CODE_PROPERTIES)) != null) {
                            this.cssColorCodesProperties = new Properties();
                            this.cssColorCodesProperties.load(inputStream);
                        }
                        if ((string2 = this.cssColorCodesProperties.getProperty(string)) == null) break block27;
                        try {
                            n3 = Integer.parseInt(string2.substring(1, 3), 16);
                            n2 = Integer.parseInt(string2.substring(3, 5), 16);
                            n = Integer.parseInt(string2.substring(5, 7), 16);
                            if (this.customColorsPalette != null) break block28;
                            short s2 = -1;
                            return s2;
                        }
                        catch (Exception exception) {
                            n2 = -1;
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            return (short)n2;
                        }
                    }
                    this.customColorsPalette.setColorAtIndex((short)new Byte((byte)this.nextAvailableColorCode).byteValue(), new Byte((byte)n3).byteValue(), new Byte((byte)n2).byteValue(), new Byte((byte)n).byteValue());
                    s = this.customColorsPalette.getColor(this.nextAvailableColorCode).getIndex();
                    this.colorCodesMap.put(string, new Integer(s));
                    ++this.nextAvailableColorCode;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        return s;
    }

    protected int buildExcelTableHeader(int n) {
        Row row = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string = EMPTY_STRING;
        String string2 = EMPTY_STRING;
        ArrayList<ExcelMergedRegionItemConfig> arrayList = new ArrayList<ExcelMergedRegionItemConfig>();
        for (n2 = 0; n2 < this.rowsetHeader.length; ++n2) {
            row = this.workbookSheet.createRow((short)n2 + n);
            string = EMPTY_STRING;
            bl2 = false;
            n4 = 0;
            n5 = 0;
            if (n2 + 1 == this.rowsetHeader.length) {
                bl = true;
            }
            for (n3 = 0; n3 < this.rowsetHeader[n2].length; ++n3) {
                string2 = this.rowsetHeader[n2][n3].getFormattedValue();
                if (string2 != null) {
                    if (this.rowsetHeader[n2].length == n3 + 1) {
                        bl2 = true;
                    } else {
                        string = this.rowsetHeader[n2][n3 + 1].getFormattedValue();
                    }
                    this.manageColumnHeaderDisplay(row, n2, n3, string2);
                    if (bl) continue;
                    if (!string.equals(string2) || bl2) {
                        this.manageCellsMerge(n3, n2 + n, n5 + 1, n4, arrayList);
                        n4 = n3 + 1;
                        n5 = 0;
                        continue;
                    }
                    if (!string.equals(string2)) continue;
                    ++n5;
                    continue;
                }
                ++n4;
            }
            if (bl) continue;
            this.manageCellsMerge(n3 - 1, n2, n5 + 1, n4, arrayList);
        }
        if (this.topLeftCornerHeight > 0 && this.topLeftCornerWidth > 0) {
            this.workbookSheet.addMergedRegion(new CellRangeAddress(n, n + this.topLeftCornerHeight - 1, 0, this.topLeftCornerWidth - 1));
        }
        if (arrayList.size() > 0) {
            for (ExcelMergedRegionItemConfig excelMergedRegionItemConfig : arrayList) {
                this.workbookSheet.addMergedRegion(new CellRangeAddress(excelMergedRegionItemConfig.getStartY(), excelMergedRegionItemConfig.getStartY() + excelMergedRegionItemConfig.getHeight(), excelMergedRegionItemConfig.getStartX(), excelMergedRegionItemConfig.getStartX() + excelMergedRegionItemConfig.getWidth() - 1));
            }
        }
        return n2 + n;
    }

    private void manageColumnHeaderDisplay(Row row, int n, int n2, String string) {
        if (this.topLeftCornerHeight > 0 && n >= this.topLeftCornerHeight) {
            this.fillHeaderCell(row, string, n2);
        } else if (this.topLeftCornerHeight > 0 && n < this.topLeftCornerHeight && this.topLeftCornerWidth > 0 && n2 >= this.topLeftCornerWidth) {
            this.fillHeaderCell(row, string, n2);
        } else if (this.topLeftCornerHeight == 0 && this.topLeftCornerWidth == 0) {
            this.fillHeaderCell(row, string, n2);
        }
    }

    private void manageCellsMerge(int n, int n2, int n3, int n4, ArrayList<ExcelMergedRegionItemConfig> arrayList) {
        ExcelMergedRegionItemConfig excelMergedRegionItemConfig = null;
        boolean bl = false;
        if (n3 == 1) {
            return;
        }
        for (ExcelMergedRegionItemConfig excelMergedRegionItemConfig2 : arrayList) {
            if (excelMergedRegionItemConfig2.getStartY() != n2 || excelMergedRegionItemConfig2.getStartX() != n) continue;
            excelMergedRegionItemConfig = excelMergedRegionItemConfig2;
            bl = true;
        }
        if (excelMergedRegionItemConfig == null) {
            excelMergedRegionItemConfig = new ExcelMergedRegionItemConfig();
        }
        excelMergedRegionItemConfig.setHeight(0);
        excelMergedRegionItemConfig.setWidth(n3);
        excelMergedRegionItemConfig.setStartX(n4);
        excelMergedRegionItemConfig.setStartY(n2);
        if (arrayList.isEmpty() || !bl) {
            arrayList.add(excelMergedRegionItemConfig);
        }
    }

    private void fillHeaderCell(Row row, String string, int n) {
        Cell cell = row.createCell(n);
        cell.setCellValue(string);
        cell.setCellStyle(this.lighterHeaderCellCS);
    }

    private int findTopLeftCornerWidth() {
        int n = 0;
        int n2 = 0;
        boolean bl = this.rowsetHeader.length < 1 || this.rowsetHeader[0][0].getRawValue() != null;
        String string = null;
        for (n2 = 0; !bl && this.rowsetHeader[0].length > n2; ++n2) {
            string = this.rowsetHeader[0][n2].getRawValue();
            if (string == null) {
                n = n2 + 1;
                continue;
            }
            bl = true;
        }
        return n;
    }

    private int findTopLeftCornerHeight() {
        int n = this.rowsetHeader.length > 0 ? this.rowsetHeader.length - 1 : 0;
        return n;
    }
}

