/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.query;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Properties;
import mondrian.rolap.RolapConnection;
import org.apache.commons.lang.StringUtils;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.OlapConnection;
import org.olap4j.OlapStatement;
import org.olap4j.Scenario;
import org.olap4j.impl.IdentifierParser;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Cube;
import org.olap4j.query.LimitFunction;
import org.olap4j.query.Query;
import org.olap4j.query.QueryAxis;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.Selection;
import org.olap4j.query.SortOrder;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.dto.SaikuTag;
import org.saiku.olap.query.IQuery;
import org.saiku.olap.query.QueryProperties;
import org.saiku.olap.query.QuerySerializer;
import org.saiku.olap.util.SaikuProperties;
import org.saiku.olap.util.exception.SaikuOlapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlapQuery
implements IQuery {
    private static final Logger log = LoggerFactory.getLogger(OlapQuery.class);
    private static final String SCENARIO = "Scenario";
    private Query query;
    private Properties properties = new Properties();
    private SaikuCube cube;
    private Scenario scenario;
    private SaikuTag tag = null;
    private CellSet cellset = null;
    private OlapStatement statement = null;
    private OlapConnection connection;

    public OlapQuery(Query query, OlapConnection connection, SaikuCube cube, boolean applyDefaultProperties) {
        this.query = query;
        this.cube = cube;
        this.connection = connection;
        if (applyDefaultProperties) {
            this.applyDefaultProperties();
        }
    }

    public OlapQuery(Query query, OlapConnection connection, SaikuCube cube) {
        this(query, connection, cube, true);
    }

    @Override
    public void swapAxes() {
        this.query.swapAxes();
        QueryAxis rows = this.query.getAxis((Axis)Axis.ROWS);
        QueryAxis cols = this.query.getAxis((Axis)Axis.COLUMNS);
        String colFilter = cols.getFilterCondition();
        LimitFunction colLimit = cols.getLimitFunction();
        BigDecimal colN = cols.getLimitFunctionN();
        String colLimitSort = cols.getLimitFunctionSortLiteral();
        SortOrder colSort = cols.getSortOrder();
        String colSortIdentifier = cols.getSortIdentifierNodeName();
        cols.clearFilter();
        cols.clearLimitFunction();
        cols.clearSort();
        if (rows.getSortOrder() != null) {
            cols.sort(rows.getSortOrder(), rows.getSortIdentifierNodeName());
        }
        if (rows.getLimitFunction() != null) {
            cols.limit(rows.getLimitFunction(), rows.getLimitFunctionN(), rows.getLimitFunctionSortLiteral());
        }
        if (StringUtils.isNotBlank((String)rows.getFilterCondition())) {
            cols.filter(rows.getFilterCondition());
        }
        rows.clearFilter();
        rows.clearLimitFunction();
        rows.clearSort();
        if (colSort != null) {
            rows.sort(colSort, colSortIdentifier);
        }
        if (colLimit != null) {
            rows.limit(colLimit, colN, colLimitSort);
        }
        if (StringUtils.isNotBlank((String)colFilter)) {
            rows.filter(colFilter);
        }
    }

    @Override
    public Map<Axis, QueryAxis> getAxes() {
        return this.query.getAxes();
    }

    @Override
    public QueryAxis getAxis(Axis axis) {
        return this.query.getAxis(axis);
    }

    @Override
    public QueryAxis getAxis(String name) throws SaikuOlapException {
        if ("UNUSED".equals(name)) {
            return this.getUnusedAxis();
        }
        Axis.Standard standardAxis = Axis.Standard.valueOf((String)name);
        if (standardAxis == null) {
            throw new SaikuOlapException("Axis (" + name + ") not found for query (" + this.query.getName() + ")");
        }
        Axis queryAxis = Axis.Factory.forOrdinal((int)standardAxis.axisOrdinal());
        return this.query.getAxis(queryAxis);
    }

    @Override
    public Cube getCube() {
        return this.query.getCube();
    }

    @Override
    public QueryAxis getUnusedAxis() {
        return this.query.getUnusedAxis();
    }

    @Override
    public void moveDimension(QueryDimension dimension, Axis axis) {
        this.moveDimension(dimension, axis, -1);
    }

    @Override
    public void moveDimension(QueryDimension dimension, Axis axis, int position) {
        QueryAxis oldQueryAxis = this.findAxis(dimension);
        QueryAxis newQueryAxis = this.query.getAxis(axis);
        if (dimension.getName() != "Measures" && !Axis.FILTER.equals((Object)axis)) {
            dimension.setHierarchyConsistent(true);
            dimension.setHierarchizeMode(QueryDimension.HierarchizeMode.PRE);
        } else {
            dimension.setHierarchyConsistent(false);
            dimension.clearHierarchizeMode();
        }
        if (oldQueryAxis != null && newQueryAxis != null && oldQueryAxis.getLocation() != newQueryAxis.getLocation() && oldQueryAxis.getLocation() != null) {
            for (QueryAxis qAxis : this.query.getAxes().values()) {
                String sortLiteral;
                if (qAxis.getSortOrder() == null || qAxis.getSortIdentifierNodeName() == null || !(sortLiteral = qAxis.getSortIdentifierNodeName()).startsWith(dimension.getDimension().getUniqueName()) && !sortLiteral.startsWith("[" + dimension.getName())) continue;
                qAxis.clearSort();
            }
        }
        if (oldQueryAxis != null && newQueryAxis != null && (position > -1 || oldQueryAxis.getLocation() != newQueryAxis.getLocation())) {
            oldQueryAxis.removeDimension(dimension);
            if (position > -1) {
                newQueryAxis.addDimension(position, dimension);
            } else {
                newQueryAxis.addDimension(dimension);
            }
        }
    }

    @Override
    public QueryDimension getDimension(String name) {
        return this.query.getDimension(name);
    }

    private QueryAxis findAxis(QueryDimension dimension) {
        if (this.query.getUnusedAxis().getDimensions().contains(dimension)) {
            return this.query.getUnusedAxis();
        }
        Map axes = this.query.getAxes();
        for (Axis axis : axes.keySet()) {
            if (!((QueryAxis)axes.get(axis)).getDimensions().contains(dimension)) continue;
            return (QueryAxis)axes.get(axis);
        }
        return null;
    }

    @Override
    public String getMdx() {
        StringWriter writer = new StringWriter();
        this.query.getSelect().unparse(new ParseTreeWriter(new PrintWriter(writer)));
        return ((Object)writer).toString();
    }

    @Override
    public SaikuCube getSaikuCube() {
        return this.cube;
    }

    @Override
    public String getName() {
        return this.query.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CellSet execute() throws Exception {
        try {
            OlapStatement stmt;
            if (this.statement != null) {
                this.statement.close();
                this.statement = null;
            }
            if (this.scenario != null && this.query.getDimension(SCENARIO) != null) {
                QueryDimension dimension = this.query.getDimension(SCENARIO);
                this.moveDimension(dimension, (Axis)Axis.FILTER);
                Selection sel = dimension.createSelection(IdentifierParser.parseIdentifier((String)("[Scenario].[" + this.getScenario().getId() + "]")));
                if (!dimension.getInclusions().contains(sel)) {
                    dimension.getInclusions().add(sel);
                }
            }
            String mdx = this.getMdx();
            log.trace("Executing query (" + this.getName() + ") :\n" + mdx);
            Catalog catalog = this.query.getCube().getSchema().getCatalog();
            this.connection.setCatalog(catalog.getName());
            this.statement = stmt = this.connection.createStatement();
            CellSet cellSet = stmt.executeOlapQuery(mdx);
            if (this.scenario != null && this.query.getDimension(SCENARIO) != null) {
                QueryDimension dimension = this.query.getDimension(SCENARIO);
                dimension.getInclusions().clear();
                this.moveDimension(dimension, null);
            }
            CellSet cellSet2 = cellSet;
            return cellSet2;
        }
        finally {
            if (this.statement != null) {
                this.statement.close();
            }
        }
    }

    private void applyDefaultProperties() {
        if (SaikuProperties.olapDefaultNonEmpty.booleanValue()) {
            this.query.getAxis((Axis)Axis.ROWS).setNonEmpty(true);
            this.query.getAxis((Axis)Axis.COLUMNS).setNonEmpty(true);
        }
    }

    @Override
    public void resetAxisSelections(QueryAxis axis) {
        for (QueryDimension dim : axis.getDimensions()) {
            dim.clearInclusions();
            dim.clearExclusions();
            dim.clearSort();
        }
        try {
            axis.clearFilter();
            axis.clearLimitFunction();
            axis.clearSort();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public void clearAllQuerySelections() {
        this.resetAxisSelections(this.getUnusedAxis());
        Map<Axis, QueryAxis> axes = this.getAxes();
        for (Axis axis : axes.keySet()) {
            this.resetAxisSelections(axes.get(axis));
        }
    }

    @Override
    public void resetQuery() {
        this.clearAllQuerySelections();
        Map<Axis, QueryAxis> axes = this.getAxes();
        for (Axis axis : axes.keySet()) {
            QueryAxis qAxis = axes.get(axis);
            for (int i = 0; i < qAxis.getDimensions().size(); ++i) {
                QueryDimension qDim = (QueryDimension)qAxis.getDimensions().get(0);
                this.moveDimension(qDim, null);
            }
        }
    }

    @Override
    public void clearAxis(String axisName) throws SaikuOlapException {
        if (StringUtils.isNotBlank((String)axisName)) {
            QueryAxis qAxis = this.getAxis(axisName);
            this.resetAxisSelections(qAxis);
            for (int i = 0; i < qAxis.getDimensions().size(); ++i) {
                QueryDimension qDim = (QueryDimension)qAxis.getDimensions().get(0);
                this.moveDimension(qDim, null);
            }
        }
    }

    @Override
    public void setProperties(Properties props) {
        if (props != null) {
            this.properties.putAll((Map<?, ?>)props);
            for (Object _key : props.keySet()) {
                String key = (String)_key;
                String value = props.getProperty(key);
                QueryProperties.QueryProperty prop = QueryProperties.QueryPropertyFactory.getProperty(key, value, this);
                prop.handle();
            }
        }
    }

    @Override
    public Properties getProperties() {
        this.properties.putAll((Map<?, ?>)QueryProperties.QueryPropertyFactory.forQuery(this));
        try {
            this.connection.createScenario();
            if (this.query.getDimension(SCENARIO) != null) {
                this.properties.put("org.saiku.connection.scenario", Boolean.toString(true));
            } else {
                this.properties.put("org.saiku.connection.scenario", Boolean.toString(false));
            }
            this.properties.put("org.saiku.query.explain", Boolean.toString(this.connection.isWrapperFor(RolapConnection.class)));
        }
        catch (Exception e) {
            this.properties.put("org.saiku.connection.scenario", Boolean.toString(false));
            this.properties.put("org.saiku.query.explain", Boolean.toString(false));
        }
        return this.properties;
    }

    @Override
    public String toXml() {
        QuerySerializer qs = new QuerySerializer(this);
        return qs.createXML();
    }

    @Override
    public Boolean isDrillThroughEnabled() {
        return this.query.getCube().isDrillThroughEnabled();
    }

    @Override
    public IQuery.QueryType getType() {
        return IQuery.QueryType.QM;
    }

    @Override
    public void setMdx(String mdx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    @Override
    public Scenario getScenario() {
        return this.scenario;
    }

    @Override
    public void setTag(SaikuTag tag) {
        this.tag = tag;
    }

    @Override
    public SaikuTag getTag() {
        return this.tag;
    }

    @Override
    public void removeTag() {
        this.tag = null;
    }

    @Override
    public void storeCellset(CellSet cs) {
        this.cellset = cs;
    }

    @Override
    public CellSet getCellset() {
        return this.cellset;
    }

    @Override
    public void setStatement(OlapStatement os) {
        this.statement = os;
    }

    @Override
    public OlapStatement getStatement() {
        return this.statement;
    }

    @Override
    public void cancel() throws Exception {
        if (this.statement != null && !this.statement.isClosed()) {
            this.statement.cancel();
            this.statement.close();
        }
        this.statement = null;
    }
}

