/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.discover;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.olap4j.OlapConnection;
import org.olap4j.OlapDatabaseMetaData;
import org.olap4j.OlapException;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Database;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.Schema;
import org.saiku.datasources.connection.IConnectionManager;
import org.saiku.olap.dto.SaikuCatalog;
import org.saiku.olap.dto.SaikuConnection;
import org.saiku.olap.dto.SaikuCube;
import org.saiku.olap.dto.SaikuDimension;
import org.saiku.olap.dto.SaikuHierarchy;
import org.saiku.olap.dto.SaikuLevel;
import org.saiku.olap.dto.SaikuMember;
import org.saiku.olap.dto.SaikuSchema;
import org.saiku.olap.util.ObjectUtil;
import org.saiku.olap.util.SaikuCubeCaptionComparator;
import org.saiku.olap.util.SaikuDimensionCaptionComparator;
import org.saiku.olap.util.exception.SaikuOlapException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlapMetaExplorer {
    private IConnectionManager connections;

    public OlapMetaExplorer(IConnectionManager ic) {
        this.connections = ic;
    }

    public SaikuConnection getConnection(String connectionName) throws SaikuOlapException {
        OlapConnection olapcon = this.connections.getOlapConnection(connectionName);
        SaikuConnection connection = null;
        if (olapcon != null) {
            ArrayList<SaikuCatalog> catalogs = new ArrayList<SaikuCatalog>();
            try {
                for (Catalog cat : olapcon.getOlapCatalogs()) {
                    ArrayList<SaikuCube> cubes;
                    ArrayList<SaikuSchema> schemas = new ArrayList<SaikuSchema>();
                    for (Schema schem : cat.getSchemas()) {
                        cubes = new ArrayList<SaikuCube>();
                        for (Cube cub : schem.getCubes()) {
                            cubes.add(new SaikuCube(connectionName, cub.getUniqueName(), cub.getName(), cub.getCaption(), cat.getName(), schem.getName(), cub.isVisible()));
                        }
                        Collections.sort(cubes, new SaikuCubeCaptionComparator());
                        schemas.add(new SaikuSchema(schem.getName(), cubes));
                    }
                    if (schemas.size() == 0) {
                        OlapDatabaseMetaData olapDbMeta = olapcon.getMetaData();
                        ResultSet cubesResult = olapDbMeta.getCubes(cat.getName(), null, null);
                        try {
                            cubes = new ArrayList();
                            while (cubesResult.next()) {
                                cubes.add(new SaikuCube(connectionName, cubesResult.getString("CUBE_NAME"), cubesResult.getString("CUBE_NAME"), cubesResult.getString("CUBE_NAME"), cubesResult.getString("CATALOG_NAME"), cubesResult.getString("SCHEMA_NAME")));
                            }
                            Collections.sort(cubes, new SaikuCubeCaptionComparator());
                            schemas.add(new SaikuSchema("", cubes));
                        }
                        catch (SQLException e) {
                            throw new OlapException(e.getMessage(), (Throwable)e);
                        }
                        finally {
                            try {
                                cubesResult.close();
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    Collections.sort(schemas);
                    catalogs.add(new SaikuCatalog(cat.getName(), schemas));
                }
            }
            catch (OlapException e) {
                throw new SaikuOlapException("Error getting objects of connection (" + connectionName + ")", e);
            }
            Collections.sort(catalogs);
            connection = new SaikuConnection(connectionName, catalogs);
            return connection;
        }
        throw new SaikuOlapException("Cannot find connection: (" + connectionName + ")");
    }

    public List<SaikuConnection> getConnections(List<String> connectionNames) throws SaikuOlapException {
        ArrayList<SaikuConnection> connectionList = new ArrayList<SaikuConnection>();
        for (String connectionName : connectionNames) {
            connectionList.add(this.getConnection(connectionName));
        }
        return connectionList;
    }

    public List<SaikuConnection> getAllConnections() throws SaikuOlapException {
        ArrayList<SaikuConnection> cubesList = new ArrayList<SaikuConnection>();
        for (String connectionName : this.connections.getAllOlapConnections().keySet()) {
            cubesList.add(this.getConnection(connectionName));
        }
        Collections.sort(cubesList);
        return cubesList;
    }

    public List<SaikuCube> getCubes(String connectionName) {
        OlapConnection olapcon = this.connections.getOlapConnection(connectionName);
        ArrayList<SaikuCube> cubes = new ArrayList<SaikuCube>();
        if (olapcon != null) {
            try {
                for (Catalog cat : olapcon.getOlapCatalogs()) {
                    for (Schema schem : cat.getSchemas()) {
                        for (Cube cub : schem.getCubes()) {
                            cubes.add(new SaikuCube(connectionName, cub.getUniqueName(), cub.getName(), cub.getCaption(), cat.getName(), schem.getName(), cub.isVisible()));
                        }
                    }
                }
            }
            catch (OlapException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(cubes, new SaikuCubeCaptionComparator());
        return cubes;
    }

    public List<SaikuCube> getCubes(List<String> connectionNames) {
        ArrayList<SaikuCube> cubesList = new ArrayList<SaikuCube>();
        for (String connectionName : connectionNames) {
            cubesList.addAll(this.getCubes(connectionName));
        }
        Collections.sort(cubesList, new SaikuCubeCaptionComparator());
        return cubesList;
    }

    public List<SaikuCube> getAllCubes() {
        ArrayList<SaikuCube> cubes = new ArrayList<SaikuCube>();
        for (String connectionName : this.connections.getAllOlapConnections().keySet()) {
            cubes.addAll(this.getCubes(connectionName));
        }
        Collections.sort(cubes, new SaikuCubeCaptionComparator());
        return cubes;
    }

    public Cube getNativeCube(SaikuCube cube) throws SaikuOlapException {
        try {
            OlapConnection con = this.connections.getOlapConnection(cube.getConnectionName());
            if (con != null) {
                for (Database db : con.getOlapDatabases()) {
                    Catalog cat = (Catalog)db.getCatalogs().get(cube.getCatalogName());
                    if (cat == null) continue;
                    for (Schema schema : cat.getSchemas()) {
                        if (!schema.getName().equals(cube.getSchemaName())) continue;
                        for (Cube cub : schema.getCubes()) {
                            if (!cub.getName().equals(cube.getName()) && !cub.getUniqueName().equals(cube.getUniqueName())) continue;
                            return cub;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SaikuOlapException("Cannot get native cube for ( " + cube + " )", e);
        }
        throw new SaikuOlapException("Cannot get native cube for ( " + cube + " )");
    }

    public OlapConnection getNativeConnection(String name) throws SaikuOlapException {
        try {
            OlapConnection con = this.connections.getOlapConnection(name);
            if (con != null) {
                return con;
            }
        }
        catch (Exception e) {
            throw new SaikuOlapException("Cannot get native connection for ( " + name + " )", e);
        }
        return null;
    }

    public List<SaikuDimension> getAllDimensions(SaikuCube cube) throws SaikuOlapException {
        Cube nativeCube = this.getNativeCube(cube);
        List<SaikuDimension> dimensions = ObjectUtil.convertDimensions((List<Dimension>)nativeCube.getDimensions());
        for (int i = 0; i < dimensions.size(); ++i) {
            SaikuDimension dim = dimensions.get(i);
            if (!dim.getName().equals("Measures") && !dim.getUniqueName().equals("[Measures]")) continue;
            dimensions.remove(i);
            break;
        }
        Collections.sort(dimensions, new SaikuDimensionCaptionComparator());
        return dimensions;
    }

    public SaikuDimension getDimension(SaikuCube cube, String dimensionName) throws SaikuOlapException {
        Cube nativeCube = this.getNativeCube(cube);
        Dimension dim = (Dimension)nativeCube.getDimensions().get(dimensionName);
        if (dim != null) {
            return ObjectUtil.convert(dim);
        }
        return null;
    }

    public List<SaikuHierarchy> getAllHierarchies(SaikuCube cube) throws SaikuOlapException {
        Cube nativeCube = this.getNativeCube(cube);
        return ObjectUtil.convertHierarchies((List<Hierarchy>)nativeCube.getHierarchies());
    }

    public SaikuHierarchy getHierarchy(SaikuCube cube, String hierarchyName) throws SaikuOlapException {
        Cube nativeCube = this.getNativeCube(cube);
        Hierarchy h = (Hierarchy)nativeCube.getHierarchies().get(hierarchyName);
        if (h != null) {
            return ObjectUtil.convert(h);
        }
        return null;
    }

    public List<SaikuMember> getHierarchyRootMembers(SaikuCube cube, String hierarchyName) throws SaikuOlapException {
        Cube nativeCube = this.getNativeCube(cube);
        List<SaikuMember> members = new ArrayList<SaikuMember>();
        Hierarchy h = (Hierarchy)nativeCube.getHierarchies().get(hierarchyName);
        if (h == null) {
            for (Hierarchy hlist : nativeCube.getHierarchies()) {
                if (!hlist.getUniqueName().equals(hierarchyName) && !hlist.getName().equals(hierarchyName)) continue;
                h = hlist;
            }
        }
        if (h != null) {
            try {
                members = ObjectUtil.convertMembers((Collection<Member>)h.getRootMembers());
            }
            catch (OlapException e) {
                throw new SaikuOlapException("Cannot retrieve root members of hierarchy: " + hierarchyName, e);
            }
        }
        return members;
    }

    public List<SaikuLevel> getAllLevels(SaikuCube cube, String dimension, String hierarchy) throws SaikuOlapException {
        Cube nativeCube = this.getNativeCube(cube);
        Dimension dim = (Dimension)nativeCube.getDimensions().get(dimension);
        if (dim != null) {
            Hierarchy h = (Hierarchy)dim.getHierarchies().get(hierarchy);
            if (h == null) {
                for (Hierarchy hlist : dim.getHierarchies()) {
                    if (!hlist.getUniqueName().equals(hierarchy) && !hlist.getName().equals(hierarchy)) continue;
                    h = hlist;
                }
            }
            if (h != null) {
                List<SaikuLevel> levels = ObjectUtil.convertLevels((List<Level>)h.getLevels());
                return levels;
            }
        }
        return new ArrayList<SaikuLevel>();
    }

    public List<SaikuMember> getAllMembers(SaikuCube cube, String dimension, String hierarchy, String level) throws SaikuOlapException {
        block6: {
            try {
                Cube nativeCube = this.getNativeCube(cube);
                Dimension dim = (Dimension)nativeCube.getDimensions().get(dimension);
                if (dim == null) break block6;
                Hierarchy h = (Hierarchy)dim.getHierarchies().get(hierarchy);
                if (h == null) {
                    for (Hierarchy hlist : dim.getHierarchies()) {
                        if (!hlist.getUniqueName().equals(hierarchy) && !hlist.getName().equals(hierarchy)) continue;
                        h = hlist;
                    }
                }
                if (h == null) break block6;
                Level l = (Level)h.getLevels().get(level);
                if (l == null) {
                    for (Level lvl : h.getLevels()) {
                        if (!lvl.getUniqueName().equals(level) && !lvl.getName().equals(level)) continue;
                        return ObjectUtil.convertMembers(lvl.getMembers());
                    }
                    break block6;
                }
                return ObjectUtil.convertMembers(l.getMembers());
            }
            catch (OlapException e) {
                throw new SaikuOlapException("Cannot get all members", e);
            }
        }
        return new ArrayList<SaikuMember>();
    }

    public List<SaikuMember> getMemberChildren(SaikuCube cube, String uniqueMemberName) throws SaikuOlapException {
        ArrayList<SaikuMember> members = new ArrayList<SaikuMember>();
        try {
            Cube nativeCube = this.getNativeCube(cube);
            List memberList = IdentifierNode.parseIdentifier((String)uniqueMemberName).getSegmentList();
            Member m = nativeCube.lookupMember(memberList);
            if (m != null) {
                for (Member c : m.getChildMembers()) {
                    SaikuMember sm = ObjectUtil.convert(c);
                    members.add(sm);
                }
            }
        }
        catch (OlapException e) {
            throw new SaikuOlapException("Cannot get child members of member:" + uniqueMemberName, e);
        }
        return members;
    }

    public List<SaikuMember> getAllMeasures(SaikuCube cube) throws SaikuOlapException {
        List<SaikuMember> measures = new ArrayList<SaikuMember>();
        try {
            Cube nativeCube = this.getNativeCube(cube);
            for (Measure measure : nativeCube.getMeasures()) {
                if (!measure.isVisible()) continue;
                measures.add(ObjectUtil.convertMeasure(measure));
            }
            if (measures.size() == 0) {
                Hierarchy hierarchy = ((Dimension)nativeCube.getDimensions().get("Measures")).getDefaultHierarchy();
                measures = ObjectUtil.convertMembers((Collection<Member>)hierarchy.getRootMembers());
            }
        }
        catch (OlapException e) {
            throw new SaikuOlapException("Cannot get measures for cube:" + cube.getName(), e);
        }
        return measures;
    }

    public SaikuMember getMember(SaikuCube cube, String uniqueMemberName) throws SaikuOlapException {
        try {
            Cube nativeCube = this.getNativeCube(cube);
            Member m = nativeCube.lookupMember(IdentifierNode.parseIdentifier((String)uniqueMemberName).getSegmentList());
            if (m != null) {
                return ObjectUtil.convert(m);
            }
            return null;
        }
        catch (Exception e) {
            throw new SaikuOlapException("Cannot find member: " + uniqueMemberName + " in cube:" + cube.getName(), e);
        }
    }
}

