/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.datasources.connection;

import java.sql.DriverManager;
import java.util.Properties;
import mondrian.rolap.RolapConnection;
import org.olap4j.OlapConnection;
import org.saiku.datasources.connection.ISaikuConnection;

public class SaikuOlapConnection
implements ISaikuConnection {
    private String name;
    private boolean initialized = false;
    private Properties properties;
    private OlapConnection olapConnection;
    private String username;
    private String password;

    public SaikuOlapConnection(String name, Properties props) {
        this.name = name;
        this.properties = props;
    }

    public SaikuOlapConnection(Properties props) {
        this.properties = props;
        this.name = props.getProperty("name");
    }

    public boolean connect() throws Exception {
        return this.connect(this.properties);
    }

    public boolean connect(Properties props) throws Exception {
        OlapConnection connection;
        this.username = props.getProperty("username");
        this.password = props.getProperty("password");
        String driver = props.getProperty("driver");
        this.properties = props;
        String url = props.getProperty("location");
        System.out.println("name:" + this.name);
        System.out.println("driver:" + driver);
        System.out.println("url:" + url);
        System.out.flush();
        if (url.length() > 0 && url.charAt(url.length() - 1) != ';') {
            url = url + ";";
        }
        if (driver.equals("mondrian.olap4j.MondrianOlap4jDriver")) {
            if (this.username != null && this.username.length() > 0) {
                url = url + "JdbcUser=" + this.username + ";";
            }
            if (this.password != null && this.password.length() > 0) {
                url = url + "JdbcPassword=" + this.password + ";";
            }
        }
        Class.forName(driver);
        OlapConnection wrapper = connection = (OlapConnection)DriverManager.getConnection(url, this.username, this.password);
        OlapConnection tmpolapConnection = (OlapConnection)wrapper.unwrap(OlapConnection.class);
        if (tmpolapConnection == null) {
            throw new Exception("Connection is null");
        }
        System.out.println("Catalogs:" + tmpolapConnection.getOlapCatalogs().size());
        this.olapConnection = tmpolapConnection;
        this.initialized = true;
        return true;
    }

    public boolean clearCache() throws Exception {
        if (this.olapConnection.isWrapperFor(RolapConnection.class)) {
            System.out.println("Clearing cache");
            RolapConnection rcon = (RolapConnection)this.olapConnection.unwrap(RolapConnection.class);
            rcon.getCacheControl(null).flushSchemaCache();
        }
        return true;
    }

    public String getDatasourceType() {
        return "OLAP";
    }

    public boolean initialized() {
        return this.initialized;
    }

    public Object getConnection() {
        return this.olapConnection;
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    public String getName() {
        return this.name;
    }
}

