/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.hslf.model.textproperties.IndentProp;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public final class MasterTextPropAtom
extends RecordAtom {
    private byte[] _header = new byte[8];
    private byte[] _data;
    private List<IndentProp> indents;

    public MasterTextPropAtom() {
        this._data = new byte[0];
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._data.length);
        this.indents = new ArrayList<IndentProp>();
    }

    protected MasterTextPropAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
        try {
            this.read();
        }
        catch (Exception e) {
            logger.log(7, new Object[]{"Failed to parse MasterTextPropAtom", e});
        }
    }

    @Override
    public long getRecordType() {
        return RecordTypes.MasterTextPropAtom.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        this.write();
        out.write(this._header);
        out.write(this._data);
    }

    private void write() {
        int pos = 0;
        this._data = new byte[this.indents.size() * 6];
        for (IndentProp prop : this.indents) {
            LittleEndian.putInt((byte[])this._data, (int)pos, (int)prop.getCharactersCovered());
            LittleEndian.putShort((byte[])this._data, (int)(pos + 4), (short)((short)prop.getIndentLevel()));
            pos += 6;
        }
    }

    private void read() {
        this.indents = new ArrayList<IndentProp>(this._data.length / 6);
        for (int pos = 0; pos <= this._data.length - 6; pos += 6) {
            int count = LittleEndian.getInt((byte[])this._data, (int)pos);
            short indent = LittleEndian.getShort((byte[])this._data, (int)(pos + 4));
            this.indents.add(new IndentProp(count, indent));
        }
    }

    public int getIndentAt(int offset) {
        int charsUntil = 0;
        for (IndentProp prop : this.indents) {
            if (offset >= (charsUntil += prop.getCharactersCovered())) continue;
            return prop.getIndentLevel();
        }
        return -1;
    }

    public List<IndentProp> getIndents() {
        return Collections.unmodifiableList(this.indents);
    }
}

