/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.xml;

import de.statspez.pleditor.generator.meta.MetaCustomPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaRawDataSet;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.parser.SSPTags;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public abstract class AbstractXmlGenerator {
    protected static final String DEFAULT_INDENTATION_STEP = "  ";
    private Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 != null && o2 != null && o1 instanceof MetaStatspezObjekt && o2 instanceof MetaStatspezObjekt && ((MetaStatspezObjekt)o1).getName() != null && ((MetaStatspezObjekt)o2).getName() != null) {
                String name2;
                String name1 = ((MetaStatspezObjekt)o1).getName();
                if (name1.equals(name2 = ((MetaStatspezObjekt)o2).getName())) {
                    String kontext1 = ((MetaStatspezObjekt)o1).getMetaObjectContext().getObjectPakage();
                    String kontext2 = ((MetaStatspezObjekt)o2).getMetaObjectContext().getObjectPakage();
                    return kontext1.compareTo(kontext2);
                }
                return name1.compareTo(name2);
            }
            if (o1 != null && o2 != null && o1 instanceof MetaRawDataSet && o2 instanceof MetaRawDataSet && ((MetaRawDataSet)o1).getName() != null && ((MetaRawDataSet)o2).getName() != null) {
                return ((MetaRawDataSet)o1).getName().compareTo(((MetaRawDataSet)o2).getName());
            }
            if (o1 != null && o2 != null && o1 instanceof MetaTBMaterialReferenz && o2 instanceof MetaTBMaterialReferenz && ((MetaTBMaterialReferenz)o1).getName() != null && ((MetaTBMaterialReferenz)o2).getName() != null) {
                return ((MetaTBMaterialReferenz)o1).getName().compareTo(((MetaTBMaterialReferenz)o2).getName());
            }
            return 0;
        }
    };

    protected AbstractXmlGenerator() {
    }

    protected String indentation(String indentation, int steps) {
        if (indentation != null) {
            int i = 0;
            while (i < steps) {
                indentation = String.valueOf(indentation) + DEFAULT_INDENTATION_STEP;
                ++i;
            }
        }
        return indentation;
    }

    protected String escapeStringXML(String inputString) {
        String erg = "";
        if (inputString != null) {
            erg = inputString;
            if (inputString.indexOf(38) >= 0 || inputString.indexOf(60) >= 0 || inputString.indexOf(62) >= 0 || inputString.indexOf(35) >= 0) {
                StringBuffer buffer = new StringBuffer(inputString.length() + 20);
                int i = 0;
                while (i < inputString.length()) {
                    if (inputString.charAt(i) == '&') {
                        buffer.append("&amp;");
                    } else if (inputString.charAt(i) == '<') {
                        buffer.append("&lt;");
                    } else if (inputString.charAt(i) == '>') {
                        buffer.append("&gt;");
                    } else if (inputString.charAt(i) == '#') {
                        buffer.append("&#35;");
                    } else {
                        buffer.append(inputString.charAt(i));
                    }
                    ++i;
                }
                erg = buffer.toString();
            }
        }
        return erg;
    }

    protected String generateIds(Iterator list) {
        StringBuffer buf = new StringBuffer();
        while (list != null && list.hasNext()) {
            MetaStatspezObjekt metaStatspezObjekt = (MetaStatspezObjekt)list.next();
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(metaStatspezObjekt.getId());
        }
        return buf.toString();
    }

    protected String generateNamen(Iterator list) {
        StringBuffer buf = new StringBuffer();
        if (list != null && list.hasNext()) {
            while (list.hasNext()) {
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(((MetaStatspezObjekt)list.next()).getName());
            }
        }
        return buf.toString();
    }

    protected void printAttribut(PrintStream out, String name, String value) {
        String attrValue;
        if (value == null) {
            attrValue = "";
        } else if (value.indexOf(38) >= 0 || value.indexOf(60) >= 0 || value.indexOf(62) >= 0 || value.indexOf(35) >= 0 || value.indexOf(34) >= 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < value.length()) {
                if (value.charAt(i) == '&') {
                    buffer.append("&amp;");
                } else if (value.charAt(i) == '<') {
                    buffer.append("&lt;");
                } else if (value.charAt(i) == '>') {
                    buffer.append("&gt;");
                } else if (value.charAt(i) == '#') {
                    buffer.append("&#35;");
                } else if (value.charAt(i) == '\"') {
                    buffer.append("&quot;");
                } else {
                    buffer.append(value.charAt(i));
                }
                ++i;
            }
            attrValue = buffer.toString();
        } else {
            attrValue = value;
        }
        out.print(" " + name + "=\"" + attrValue + "\"");
    }

    protected void printCDATA(PrintStream out, String elName, String elValue, String indentation) {
        if (elName != null && indentation != null) {
            if (elValue == null) {
                elValue = "";
            }
            out.println(String.valueOf(indentation) + "<" + elName + ">\n<![CDATA[");
            out.print(elValue);
            out.println("\n]]>\n" + indentation + "</" + elName + ">");
        }
    }

    protected void printContext(PrintStream out, String indentation, MetaCustomPLMaterial plMaterial) {
        String periodizitaet = null;
        String identifikation = null;
        if (plMaterial.istErhebung()) {
            periodizitaet = plMaterial.getPeriodizitaet();
            identifikation = plMaterial.getIdentifikation();
        }
        out.println(String.valueOf(indentation) + "<" + SSPTags.printTag("context") + ">");
        out.print(String.valueOf(this.indentation(indentation, 1)) + "<" + SSPTags.printTag("survey"));
        this.printAttribut(out, "id", identifikation);
        out.println(">");
        if (plMaterial.getEVASNr() != null) {
            out.print(String.valueOf(this.indentation(indentation, 2)) + "<" + SSPTags.printTag("surveyID") + " class=\"EVAS\">");
            out.print(plMaterial.getEVASNr());
            out.println("</" + SSPTags.printTag("surveyID") + ">");
        }
        if (plMaterial.getExternerName() != null) {
            this.printPCDATA(out, "surveyName", plMaterial.getExternerName(), this.indentation(indentation, 2));
        }
        if (plMaterial.getBZR() != null) {
            out.println(String.valueOf(this.indentation(indentation, 2)) + "<" + SSPTags.printTag("referencePeriod") + ">");
            out.println(String.valueOf(this.indentation(indentation, 3)) + "<" + SSPTags.printTag("dateTime") + ">");
            out.println(String.valueOf(this.indentation(indentation, 4)) + "<" + SSPTags.printTag("year") + ">" + plMaterial.getBZR() + "</" + SSPTags.printTag("year") + ">");
            out.println(String.valueOf(this.indentation(indentation, 3)) + "</" + SSPTags.printTag("dateTime") + ">");
            out.println(String.valueOf(this.indentation(indentation, 2)) + "</" + SSPTags.printTag("referencePeriod") + ">");
        }
        if (periodizitaet != null && periodizitaet.trim().length() > 0) {
            out.println(String.valueOf(this.indentation(indentation, 2)) + "<" + SSPTags.printTag("periodicity") + ">");
            out.println(String.valueOf(this.indentation(indentation, 4)) + "<" + SSPTags.printTag("years") + ">" + periodizitaet + "</" + SSPTags.printTag("years") + ">");
            out.println(String.valueOf(this.indentation(indentation, 2)) + "</" + SSPTags.printTag("periodicity") + ">");
        }
        out.println(String.valueOf(this.indentation(indentation, 1)) + "</" + SSPTags.printTag("survey") + ">");
        out.println(String.valueOf(indentation) + "</" + SSPTags.printTag("context") + ">");
    }

    protected void printIdNameStateAttribute(PrintStream out, MetaStatspezObjekt metaObjekt) {
        this.printAttribut(out, "id", metaObjekt.getId());
        this.printAttribut(out, "name", metaObjekt.getName());
        this.printAttribut(out, "state", this.state(metaObjekt.getFreigabeStatus()));
    }

    protected void printLeeresContext(PrintStream out, String indentation) {
        out.println(String.valueOf(indentation) + "<" + SSPTags.printTag("context") + ">");
        out.println(String.valueOf(indentation) + DEFAULT_INDENTATION_STEP + "<" + SSPTags.printTag("survey") + "/>");
        out.println(String.valueOf(indentation) + "</" + SSPTags.printTag("context") + ">");
    }

    protected void printLeeresProperties(PrintStream out, String indentation) {
        out.println(String.valueOf(indentation) + "<" + SSPTags.printTag("properties") + ">");
        out.println(String.valueOf(indentation) + "</" + SSPTags.printTag("properties") + ">");
    }

    protected void printNameIdStateAttribute(PrintStream out, MetaStatspezObjekt metaObjekt) {
        this.printAttribut(out, "name", metaObjekt.getName());
        this.printAttribut(out, "id", metaObjekt.getId());
        this.printAttribut(out, "state", this.state(metaObjekt.getFreigabeStatus()));
    }

    protected void printNameStateIdAttribute(PrintStream out, MetaStatspezObjekt metaObjekt) {
        this.printAttribut(out, "name", metaObjekt.getName());
        this.printAttribut(out, "state", this.state(metaObjekt.getFreigabeStatus()));
        this.printAttribut(out, "id", metaObjekt.getId());
    }

    protected void printObjectContext(PrintStream out, MetaStatspezObjekt material, String indentation) {
        out.println(String.valueOf(indentation) + "<" + SSPTags.printTag("objectContext") + ">");
        out.println(String.valueOf(this.indentation(indentation, 1)) + "<" + SSPTags.printTag("this") + ">");
        String ab2 = this.indentation(indentation, 2);
        out.print(String.valueOf(ab2) + "<" + SSPTags.printTag("objectID") + " " + "class" + "=\"\">");
        out.print(this.escapeStringXML(material.getMetaObjectContext().getObjectID()));
        out.println("</" + SSPTags.printTag("objectID") + ">");
        out.print(String.valueOf(ab2) + "<" + SSPTags.printTag("objectName") + " " + "class" + "=\"\">");
        out.print(this.escapeStringXML(material.getName()));
        out.println("</" + SSPTags.printTag("objectName") + ">");
        this.printPCDATA(out, SSPTags.printTag("objectPackage"), material.getMetaObjectContext().getObjectPakage(), ab2);
        String className = material.getMetaObjectContext().getObjectClass();
        this.printPCDATA(out, SSPTags.printTag("objectClass"), className, ab2);
        out.print(String.valueOf(ab2) + "<" + SSPTags.printTag("objectVersion") + " " + "class" + "=\"\">");
        out.print("1");
        out.println("</" + SSPTags.printTag("objectVersion") + ">");
        out.println(String.valueOf(this.indentation(indentation, 1)) + "</" + SSPTags.printTag("this") + ">");
        out.println(String.valueOf(indentation) + "</" + SSPTags.printTag("objectContext") + ">");
    }

    protected void printPCDATA(PrintStream out, String elName, String elValue, String indentation) {
        this.printPCDATA(out, elName, elValue, indentation, false);
    }

    protected void printPCDATA(PrintStream out, String elName, String elValue, String indentation, boolean printEmptyTag) {
        if (printEmptyTag || out != null && elName != null && indentation != null) {
            out.print(String.valueOf(indentation) + "<" + elName + ">");
            out.print(this.escapeStringXML(elValue));
            out.println("</" + elName + ">");
        }
    }

    protected void printProperties(PrintStream out, MetaStatspezObjekt material, String indentation) {
        String eigentuemer;
        String ab2 = this.indentation(indentation, 2);
        out.println(String.valueOf(indentation) + "<" + SSPTags.printTag("properties") + ">");
        if (material.getBeschreibung() != null) {
            out.println(String.valueOf(this.indentation(indentation, 1)) + "<" + SSPTags.printTag("about") + ">");
            this.printPCDATA(out, SSPTags.printTag("description"), material.getBeschreibung(), ab2);
            out.println(String.valueOf(this.indentation(indentation, 1)) + "</" + SSPTags.printTag("about") + ">");
        }
        if ((eigentuemer = material.getCreateUser()) != null) {
            out.println(String.valueOf(this.indentation(indentation, 1)) + "<" + SSPTags.printTag("author") + ">");
            this.printPCDATA(out, SSPTags.printTag("fullName"), eigentuemer, ab2);
            out.println(String.valueOf(this.indentation(indentation, 1)) + "</" + SSPTags.printTag("author") + ">");
        }
        Date date = new Date();
        out.println(String.valueOf(this.indentation(indentation, 1)) + "<" + SSPTags.printTag("date") + ">");
        this.printZeitPunkt(out, ab2, SSPTags.printTag("year"), date);
        this.printZeitPunkt(out, ab2, SSPTags.printTag("month"), date);
        this.printZeitPunkt(out, ab2, SSPTags.printTag("day"), date);
        out.println(String.valueOf(this.indentation(indentation, 1)) + "</" + SSPTags.printTag("date") + ">");
        out.println(String.valueOf(this.indentation(indentation, 1)) + "<" + SSPTags.printTag("time") + ">");
        this.printZeitPunkt(out, ab2, SSPTags.printTag("hours"), date);
        this.printZeitPunkt(out, ab2, SSPTags.printTag("minutes"), date);
        this.printZeitPunkt(out, ab2, SSPTags.printTag("seconds"), date);
        out.println(String.valueOf(this.indentation(indentation, 1)) + "</" + SSPTags.printTag("time") + ">");
        if (material.getKommentar() != null) {
            this.printPCDATA(out, SSPTags.printTag("annotation"), material.getKommentar(), this.indentation(indentation, 1));
        }
        out.println(String.valueOf(indentation) + "</" + SSPTags.printTag("properties") + ">");
    }

    protected void printZeitPunkt(PrintStream out, String indentation, String element, Date date) {
        if (out == null || indentation == null || element == null || date == null) {
            return;
        }
        String formatter = null;
        if (element.equals(SSPTags.printTag("year"))) {
            formatter = "yyyy";
        } else if (element.equals(SSPTags.printTag("month"))) {
            formatter = "MM";
        } else if (element.equals(SSPTags.printTag("day"))) {
            formatter = "dd";
        } else if (element.equals(SSPTags.printTag("hours"))) {
            formatter = "HH";
        } else if (element.equals(SSPTags.printTag("minutes"))) {
            formatter = "mm";
        } else if (element.equals(SSPTags.printTag("seconds"))) {
            formatter = "ss";
        }
        if (formatter != null) {
            out.print(String.valueOf(indentation) + "<" + element + ">");
            SimpleDateFormat zeit_formatter = new SimpleDateFormat(formatter, Locale.GERMANY);
            String str = zeit_formatter.format(date);
            out.print(str);
            out.println("</" + element + ">");
        }
    }

    protected List sort(Iterator it) {
        ArrayList list = new ArrayList();
        while (it != null && it.hasNext()) {
            list.add(it.next());
        }
        Collections.sort(list, this.comparator);
        return list;
    }

    protected String state(short state) {
        String erg = "locked";
        if (state == 1) {
            erg = "approved";
        }
        return erg;
    }
}

