/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.DateValue;
import de.statspez.pleditor.generator.runtime.FeldDeskriptor;
import de.statspez.pleditor.generator.runtime.InconvertibleValue;
import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.NumberValue;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueFactory;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.WertNichtTypgerechtException;
import java.io.Serializable;
import java.util.Stack;

public abstract class FeldDeskriptorImpl
implements FeldDeskriptorInterface,
Serializable {
    static final long serialVersionUID = -7130140031804810213L;
    private FeldDeskriptorInterface parent;
    private FeldDeskriptor feldDeskriptor;
    private int[] indizes;

    public FeldDeskriptorImpl(FeldDeskriptorInterface parent, FeldDeskriptor feldDeskriptor, int[] indizes) {
        this.parent = parent;
        this.feldDeskriptor = feldDeskriptor;
        this.indizes = indizes;
    }

    @Override
    public FeldDeskriptorInterface getVorgaenger() {
        return this.parent;
    }

    @Override
    public void setVorgaenger(FeldDeskriptorInterface parent) {
        this.parent = parent;
    }

    @Override
    public String getFeldNameDSB() {
        return this.feldDeskriptor.getFeldNameDSB();
    }

    @Override
    public String getFeldNameTB() {
        return this.feldDeskriptor.getFeldNameTB();
    }

    @Override
    public void setFeldNameDSB(String feldNameDSB) {
        this.feldDeskriptor.setFeldNameDSB(feldNameDSB);
    }

    @Override
    public void setFeldNameTB(String feldNameTB) {
        this.feldDeskriptor.setFeldNameTB(feldNameTB);
    }

    @Override
    public int[] getIndizes() {
        return this.indizes;
    }

    @Override
    public void setIndizes(int[] indizes) {
        if (indizes == null) {
            this.indizes = null;
        } else {
            this.indizes = new int[indizes.length];
            System.arraycopy(indizes, 0, this.indizes, 0, indizes.length);
        }
    }

    @Override
    public void setMaske(String maske) {
        this.feldDeskriptor.setMaske(maske);
    }

    @Override
    public String getMaske() {
        return this.feldDeskriptor.getMaske();
    }

    public FeldDeskriptor getFeldDeskriptor() {
        return this.feldDeskriptor;
    }

    public int getLaenge(SatzInterface satzInterface, int[] indizies) {
        try {
            SatzInterface subSatz = this.getSubSatz(satzInterface);
            return subSatz.getLaenge(this, indizies);
        }
        catch (Exception e) {
            throw new RuntimeException("Die L\u00e4nge der Dimension des Felds " + this.getFeldDeskriptor().getFeldNameTB() + " konnte nicht ermittelt werden.", e);
        }
    }

    public Value getValueFrom(SatzInterface satzInterface) {
        return this.getValueFrom(satzInterface, false);
    }

    public Value getValueFrom(SatzInterface satzInterface, boolean asString) {
        Value v;
        block13: {
            v = null;
            try {
                SatzInterface subSatz = this.getSubSatz(satzInterface);
                if (subSatz.hatWert(this)) {
                    switch (this.feldDeskriptor.getFeldTyp()) {
                        case 0: {
                            v = asString || this.getMaske() != null ? new NumberValue(subSatz.getString(this)) : ValueFactory.instance().valueFor(subSatz.getLong(this));
                            break block13;
                        }
                        case 2: {
                            v = asString || this.getMaske() != null ? new NumberValue(subSatz.getString(this)) : ValueFactory.instance().valueFor(subSatz.getDouble(this));
                            break block13;
                        }
                        case 3: 
                        case 8: {
                            v = ValueFactory.instance().valueFor(subSatz.getString(this));
                            break block13;
                        }
                        case 6: {
                            v = new DateValue(subSatz.getString(this), this.getMaske() != null ? this.getMaske() : "SS:mm");
                            break block13;
                        }
                        case 5: {
                            v = new DateValue(subSatz.getString(this), this.getMaske() != null ? this.getMaske() : "TT.MM.JJJJ");
                            break block13;
                        }
                        case 4: {
                            v = ValueFactory.instance().valueFor(subSatz.getBool(this));
                            break block13;
                        }
                        default: {
                            throw new Exception("Felder vom Typ " + this.feldDeskriptor.getFeldTyp() + " werden (zur Zeit) nicht unterstuetzt");
                        }
                    }
                }
                v = InvalidValue.instance();
            }
            catch (WertNichtTypgerechtException e) {
                v = new InconvertibleValue(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Das Feld " + this.getFeldNameTB() + " kann nicht gelesen werden", e);
            }
        }
        assert (v != null) : "Kein Wert fuer das Feld " + this.hierarchyAsString();
        return v;
    }

    public void setValueWith(SatzInterface satzInterface, Value value) {
        this.setValueWith(satzInterface, value, false);
    }

    public void setValueWith(SatzInterface satzInterface, Value value, boolean asString) {
        block16: {
            try {
                SatzInterface subSatz = this.getSubSatz(satzInterface);
                if (value.isValid()) {
                    switch (this.feldDeskriptor.getFeldTyp()) {
                        case 0: {
                            if (asString) {
                                subSatz.setString(this, value.asString());
                            } else {
                                subSatz.setLong(this, value.asLong());
                            }
                            break block16;
                        }
                        case 2: {
                            if (asString) {
                                subSatz.setString(this, value.asString());
                            } else {
                                subSatz.setDouble(this, value.asDouble());
                            }
                            break block16;
                        }
                        case 3: 
                        case 8: {
                            subSatz.setString(this, value.asString());
                            break block16;
                        }
                        case 5: 
                        case 6: {
                            if (value instanceof DateValue) {
                                DateValue dateValue = new DateValue(((DateValue)value).date(), this.getFeldDeskriptor().getMaske());
                                subSatz.setString(this, dateValue.toString());
                            } else {
                                subSatz.setString(this, value.asString());
                            }
                            break block16;
                        }
                        case 4: {
                            subSatz.setBool(this, value.asBoolean());
                            break block16;
                        }
                        default: {
                            throw new Exception("Felder vom Typ " + this.feldDeskriptor.getFeldTyp() + " werden (zur Zeit) nicht unterstuetzt");
                        }
                    }
                }
                subSatz.setLeerWert(this);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Das Feld " + this.getFeldNameTB() + " kann nicht gesetzt werden.", e);
            }
        }
    }

    public String hierarchyAsString() {
        StringBuffer hierachy = new StringBuffer(this.getFeldNameTB());
        FeldDeskriptorInterface currentParent = this.getVorgaenger();
        while (currentParent != null) {
            hierachy.insert(0, ".");
            if (currentParent.getIndizes() != null) {
                int i = currentParent.getIndizes().length - 1;
                while (i >= 0) {
                    hierachy.insert(0, "[" + currentParent.getIndizes()[i] + "]");
                    --i;
                }
            }
            hierachy.insert(0, currentParent.getFeldNameTB());
            currentParent = currentParent.getVorgaenger();
        }
        return hierachy.toString();
    }

    protected FeldDeskriptorImpl(FeldDeskriptorImpl object) {
        this.parent = object.getVorgaenger();
        this.feldDeskriptor = object.getFeldDeskriptor();
        this.indizes = object.getIndizes();
    }

    protected SatzInterface getSubSatz(SatzInterface satzInterface) throws Exception {
        Stack<FeldDeskriptorInterface> hierachy = new Stack<FeldDeskriptorInterface>();
        FeldDeskriptorInterface current = this.getVorgaenger();
        while (current != null) {
            hierachy.push(current);
            current = current.getVorgaenger();
        }
        SatzInterface subSatz = satzInterface;
        while (!hierachy.empty()) {
            current = (FeldDeskriptorInterface)hierachy.pop();
            subSatz = subSatz.getSubSatz(current);
        }
        return subSatz;
    }
}

