/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomMapping;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaMapping;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaRawDataSet;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.AuspraegungsgruppeParser;
import de.statspez.pleditor.generator.parser.DataSetTypeParser;
import de.statspez.pleditor.generator.parser.FunctionParser;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.MappingParser;
import de.statspez.pleditor.generator.parser.MaterialParser;
import de.statspez.pleditor.generator.parser.MerkmalParser;
import de.statspez.pleditor.generator.parser.ObjectContextParser;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.PropertiesParser;
import de.statspez.pleditor.generator.parser.RawDataSetParser;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import de.statspez.pleditor.generator.parser.SurveyParser;
import de.statspez.pleditor.generator.parser.ThemenbereichParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PlausibilisierungParser
extends SubParser
implements SuperParser {
    private MetaCustomPlausibilisierung currentPlausi = null;
    private ParserChain parserChain = new ParserChain();
    private SurveyParser surveyParser = null;
    private PropertiesParser propertiesParser = null;
    private ObjectContextParser objectContextParser = null;
    private ThemenbereichParser tbParser;
    private MerkmalParser merkmalParser;
    private AuspraegungsgruppeParser agParser;
    private DataSetTypeParser dsbParser;
    private RawDataSetParser rawDataSetParser;
    private MappingParser mappingParser;
    private MaterialParser materialParser;
    private FunctionParser functionParser;

    public PlausibilisierungParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.surveyParser = new SurveyParser(this, resolver);
        this.parserChain.addParser(this.surveyParser);
        this.propertiesParser = new PropertiesParser(this, resolver);
        this.parserChain.addParser(this.propertiesParser);
        this.objectContextParser = new ObjectContextParser(this, resolver);
        this.parserChain.addParser(this.objectContextParser);
        this.merkmalParser = new MerkmalParser(this, resolver);
        this.parserChain.addParser(this.merkmalParser);
        this.tbParser = new ThemenbereichParser(this, resolver);
        this.parserChain.addParser(this.tbParser);
        this.agParser = new AuspraegungsgruppeParser(this, resolver);
        this.parserChain.addParser(this.agParser);
        this.dsbParser = new DataSetTypeParser(this, resolver);
        this.parserChain.addParser(this.dsbParser);
        this.mappingParser = new MappingParser(this, resolver);
        this.parserChain.addParser(this.mappingParser);
        this.materialParser = new MaterialParser(this, resolver);
        this.parserChain.addParser(this.materialParser);
        this.rawDataSetParser = new RawDataSetParser(this, resolver);
        this.parserChain.addParser(this.rawDataSetParser);
        this.functionParser = new FunctionParser(this, resolver);
        this.parserChain.addParser(this.functionParser);
    }

    @Override
    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && tag.equalsIgnoreCase("plausibility")) {
            return true;
        }
        return this.isEnabled();
    }

    @Override
    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("annotation".equalsIgnoreCase(localName) || "comment".equalsIgnoreCase(localName) || "description".equalsIgnoreCase(localName) || "explanation".equalsIgnoreCase(localName)) {
            this.superParser().charData().setLength(0);
        }
        if ("plausibility".equalsIgnoreCase(localName)) {
            this.currentPlausi = new MetaCustomPlausibilisierung();
            this.enable();
            this.propertiesParser.setCurrentElement(this.currentPlausi);
            this.surveyParser.setCurrentElement(this.currentPlausi);
            this.objectContextParser.setCurrentElement(this.currentPlausi);
            this.handleAttributes(namespaceURI, localName, qName, atts);
        } else if ("specifications".equalsIgnoreCase(localName)) {
            this.objectContextParser.disallow();
        } else if (!"context".equalsIgnoreCase(localName)) {
            if ("topic".equalsIgnoreCase(localName)) {
                this.functionParser.disallow();
            }
            if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
                throw ILParseException.unknownTagException(localName);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("plausibility".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if ("specifications".equalsIgnoreCase(localName)) {
            this.objectContextParser.allow();
        } else if (!"context".equalsIgnoreCase(localName)) {
            if (!this.parserChain.endElement(namespaceURI, localName, qName)) {
                throw ILParseException.unkownClosingTagException(localName);
            }
            if ("topic".equalsIgnoreCase(localName)) {
                this.functionParser.allow();
            }
        }
    }

    @Override
    public StringBuffer charData() {
        return this.superParser().charData();
    }

    @Override
    public MetaElement object() {
        return this.currentPlausi;
    }

    @Override
    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.tbParser) {
            MetaThemenbereich theTb = (MetaThemenbereich)aParser.object();
            this.currentPlausi.addToThemenbereiche(theTb);
        } else if (aParser == this.merkmalParser) {
            MetaMerkmal theMerkmal = (MetaMerkmal)aParser.object();
            this.currentPlausi.addToMerkmale(theMerkmal);
        } else if (aParser == this.agParser) {
            MetaAuspraegungsgruppe theAuspraegungsgruppe = (MetaAuspraegungsgruppe)aParser.object();
            this.currentPlausi.addToAuspraegungsgruppen(theAuspraegungsgruppe);
        } else if (aParser == this.dsbParser) {
            MetaDsbObjekt theDSB = (MetaDsbObjekt)aParser.object();
            this.currentPlausi.addToDsbs(theDSB);
        } else if (aParser == this.mappingParser) {
            MetaMapping map = (MetaMapping)aParser.object();
            this.currentPlausi.addToMappings(map);
        } else if (aParser == this.materialParser) {
            MetaPLMaterial mat = (MetaPLMaterial)aParser.object();
            this.currentPlausi.addToPLMaterialien(mat);
        } else if (aParser == this.objectContextParser) {
            this.currentPlausi.setErhebung(true);
        } else if (aParser == this.rawDataSetParser) {
            MetaRawDataSet rds = (MetaRawDataSet)aParser.object();
            this.currentPlausi.addToRawDataSets(rds);
        } else if (aParser == this.functionParser) {
            MetaCustomFunktion aFunktion = (MetaCustomFunktion)this.functionParser.object();
            this.currentPlausi.addToFunktionen(aFunktion);
            int contextType = 4;
            MetaProgram prog = aFunktion.getMetaSpezifikation();
            if (prog != null) {
                prog.setContextInfos(new ElementMessageContext(contextType, aFunktion.getId(), aFunktion.getName()));
            }
        }
    }

    @Override
    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("plausibility".equalsIgnoreCase(localName)) {
            String refs;
            String identifikation;
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("F\u00fcr die Plausibilisierung der Erhebung ist kein Name definiert!");
            }
            this.currentPlausi.setPLName(name.trim());
            String version = atts.getValue("version");
            if (version != null && version.trim().length() > 0) {
                try {
                    double dVersion = Double.parseDouble(version);
                    this.superParser().getParserKontext().setVersion(dVersion);
                }
                catch (Exception e) {
                    throw new ILParseException("Die Version der Plausibilisierung ist keine Zahl!");
                }
            }
            if ((identifikation = atts.getValue("survey-id")) != null && identifikation.trim().length() > 0) {
                this.currentPlausi.setIdentifikation(identifikation.trim());
            }
            if ((refs = atts.getValue("refs")) != null && refs.trim().equals("id")) {
                this.resolver().setUseIDasRef(true);
            } else {
                this.resolver().setUseIDasRef(false);
            }
            String refName = atts.getValue("tb-name");
            String id = atts.getValue("tb-id");
            String key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (refName != null && refName.trim().length() > 0 && !this.resolver().isUseIDasRef()) {
                key = refName;
            }
            if (key != null) {
                this.resolver().registerForResolve(this.currentPlausi, key.trim(), refName, MetaCustomThemenbereich.class);
            } else if (this.getParserKontext().isPlausiMussTbReferenzHaben()) {
                throw new ILParseException("F\u00fcr die Plausibilisierung der Erhebung ist kein Themenbereich definiert!");
            }
            refName = atts.getValue("mapping-name");
            id = atts.getValue("mapping-id");
            key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (refName != null && refName.trim().length() > 0 && !this.resolver().isUseIDasRef()) {
                key = refName;
            }
            if (key != null) {
                this.resolver().registerForResolve(this.currentPlausi, key.trim(), refName, MetaCustomMapping.class);
            } else if (this.getParserKontext().isPlausiMussMappingReferenzHaben()) {
                throw new ILParseException("F\u00fcr die Plausibilisierung der Erhebung ist kein Mapping definiert!");
            }
            refName = atts.getValue("dsb-name");
            id = atts.getValue("dsb-id");
            key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (refName != null && refName.trim().length() > 0 && !this.resolver().isUseIDasRef()) {
                key = refName;
            }
            if (key != null) {
                this.resolver().registerForResolve(this.currentPlausi, key.trim(), refName, MetaDsbObjekt.class);
            } else if (this.getParserKontext().isPlausiMussDsbReferenzHaben()) {
                throw new ILParseException("F\u00fcr die Plausibilisierung der Erhebung ist keine Datensatzbeschreibung definiert!");
            }
            refName = atts.getValue("raw-set-name");
            id = atts.getValue("raw-set-id");
            key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (refName != null && refName.trim().length() > 0) {
                key = refName;
            }
            if (key != null) {
                this.resolver().registerForResolve(this.currentPlausi, key.trim(), refName, MetaRawDataSet.class);
            }
            refName = atts.getValue("raw-mapping-name");
            id = atts.getValue("raw-mapping-id");
            key = null;
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                key = id;
            } else if (refName != null && refName.trim().length() > 0) {
                key = refName;
            }
            if (key != null) {
                this.resolver().registerForResolve(this.currentPlausi, key.trim(), refName, MetaCustomMapping.class, Resolver.USAGE_RAW_MAPPING, true);
            }
        }
    }

    @Override
    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

