/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.meta;

import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaFunctionIdentifier;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import java.util.Hashtable;
import java.util.Vector;

public class InternalFunctions {
    private static InternalFunctions instance = null;
    private Hashtable functions = new Hashtable();

    public static synchronized InternalFunctions instance() {
        if (instance == null) {
            instance = new InternalFunctions();
        }
        return instance;
    }

    public MetaCustomFunktion[] allFunctions() {
        return this.functions.values().toArray(new MetaCustomFunktion[0]);
    }

    public boolean isInternalFunction(String name) {
        return this.functions.containsKey(name);
    }

    public boolean identifiesInternalFunction(MetaFunctionIdentifier fid) {
        if (!(fid.adaptedObject() instanceof MetaIdentifier)) {
            return false;
        }
        return this.isInternalFunction(((MetaIdentifier)fid.adaptedObject()).value());
    }

    private InternalFunctions() {
        assert (instance == null) : "es existiert bereits eine Instanz von InternalFunctions";
        this.makeFunction("WERTLAENGE", new MetaProgramParameter[]{this.makeParameter("zeichenkette", 2, null)}, "Die Funktion WERTLAENGE liefert die L\u00e4nge der \u00fcbergebenen Zeichenkette.");
        this.makeFunction("KONKATENIEREN", new MetaProgramParameter[]{this.makeParameter("zeichenkette1", 2, null), this.makeParameter("zeichenkette2", 2, null)}, "Die Funktion KONKATENIEREN f\u00fcgt die \u00fcbergebenen Zeichenketten zu einer Zeichenkette zusammen und liefert diese zur\u00fcck.");
        this.makeFunction("TEIL", new MetaProgramParameter[]{this.makeParameter("zeichkette", 2, null), this.makeParameter("start", 5, null), this.makeParameter("laenge", 5, null)}, "Die Funktion TEIL kann eine bestimmte Anzahl von Zeichen aus einer Zeichenkette lesen und zur\u00fcckliefern. Start gibt die Position des ersten Zeichens vom R\u00fcckgabewert an, L\u00e4nge die Anzahl der Zeichen, die ausgelesen werden sollen.");
        this.makeFunction("ERSETZEN", new MetaProgramParameter[]{this.makeParameter("zeichenkette1", 2, null), this.makeParameter("zeichenkette2", 2, null), this.makeParameter("zeichenkette3", 2, null)}, "Die Funktion ERSETZEN ersetzt in der \u00fcbergebenen Zeichenkette1 alle Vorkommen der Zeichenkette2 durch die Zeichenkette3 und liefert das Ergebnis zur\u00fcck. Der Vergleich wird unter der Ber\u00fccksichtigung der Gro\u00df- und Kleinschreibung ausgef\u00fchrt.");
        this.makeFunction("ENDET_AUF", new MetaProgramParameter[]{this.makeParameter("zeichenkette", 2, null), this.makeParameter("suffixZeichenkette", 2, null)}, "Der Funktion ENDET_AUF werden eine Zeichenkette und ein Suffix (ebenfalls als Zeichenkette) \u00fcbergeben. Die Funktion liefert Wahr, wenn die Zeichenkette mit dem Suffix endet, sonst liefert sie Falsch.");
        this.makeFunction("BEGINNT_MIT", new MetaProgramParameter[]{this.makeParameter("zeichenkette", 2, null), this.makeParameter("prefixZeichenkette", 2, null)}, "Der Funktion BEGINNT_MIT werden eine Zeichenkette und ein Prefix (ebenfalls als Zeichenkette) \u00fcbergeben. Die Funktion liefert Wahr, wenn die Zeichenkette mit dem Prefix beginnt, sonst liefert sie Falsch.");
        this.makeFunction("GROSSBUCHSTABEN", new MetaProgramParameter[]{this.makeParameter("zeichenkette", 2, null)}, "Die Funktion GROSSBUCHSTABEN liefert die \u00fcbergebene Zeichenkette in Gro\u00dfbuchstaben zur\u00fcck. Ist der Wert leer, wird der Leerwert geliefert.");
        this.makeFunction("KLEINBUCHSTABEN", new MetaProgramParameter[]{this.makeParameter("zeichenkette", 2, null)}, "Die Funktion KLEINBUCHSTABEN liefert die \u00fcbergebenen Zeichenketten in Kleinbuchstaben zur\u00fcck. Ist der Wert leer, wird der Leerwert geliefert.");
        this.makeFunction("NUMERISCH", new MetaProgramParameter[]{this.makeParameter("wert", 7, null)}, "Die Funktion NUMERISCH liefert Wahr, wenn in dem vorgegebenen Wert keine Zeichen vorkommen, die nicht Ziffern sind, sonst liefert sie Falsch.");
        this.makeFunction("HAT_FORMAT", new MetaProgramParameter[]{this.makeParameter("format", 2, null), this.makeParameter("zeichenkette", 2, null)}, "Die Funktion HAT_FORMAT liefert Wahr, wenn die vorgegebene Zeichenkette dem vorgegebenen Format entspricht, sonst liefert sie Falsch. Das Format wird als regul\u00e4rer Ausdruck interpretiert.");
        this.makeFunction("EXPONENT", new MetaProgramParameter[]{this.makeParameter("x", 1, null), this.makeParameter("y", 1, null)}, "Erm\u00f6glicht die Berechnung von Potenzen x^y der angegebenen Zahlen x und y.");
        this.makeFunction("MODULO", new MetaProgramParameter[]{this.makeParameter("wert", 1, null), this.makeParameter("devisor", 1, null)}, "Die Funktion MODULO liefert den Rest der Division des \u00fcbergebenen Wertes durch den \u00fcbergebenen Divisor. Ist der Wert leer, wird der Leerwert geliefert. Ist der Divisor Null oder leer wird eine Exception geworfen. Falls Wert oder Divisor keine Zahlenwerte sind, wird versucht den Wert bzw. den Divisor in eine Zahl zu konvertieren. Ist dies nicht m\u00f6glich, wird eine Exception geworfen. Geschieht das Werfen einer Exception innerhalb einer PL-Pr\u00fcfung, so wird der entsprechende Fehlerschl\u00fcssel angeschrieben.");
        this.makeFunction("RUNDEN", new MetaProgramParameter[]{this.makeParameter("wert", 1, null), this.makeParameter("nachkommastellen", 5, null)}, "Die Funktion RUNDEN liefert den auf die vorgegebene Anzahl an Nachkommastellen kaufm\u00e4nnisch gerundeten vorgegebenen Wert. Ist der Wert leer, wird der Leerwert geliefert. Falls der Wert kein Zahlenwert ist, wird versucht den Wert in eine Zahl zu konvertieren. Ist dies nicht m\u00f6glich, wird eine Exception geworfen. Geschieht dies innerhalb einer PL-Pr\u00fcfung, so wird der entsprechende Fehlerschl\u00fcssel angeschrieben.");
        this.makeFunction("ALS_GANZZAHL", new MetaProgramParameter[]{this.makeParameter("wert", -1, null)}, "Die Funktion ALS_GANZZAHL liefert einen vorgegebenen Wert als Ganzzahl zur\u00fcck. Kommazahlen werden kaufm\u00e4nnisch gerundet. D.h. ist der Nachkommastellenwert gr\u00f6\u00dfer oder gleich 0,5 wird aufgerundet, sonst wird abgerundet. Falls der Wert nicht in eine Ganzzahl konvertiert werden kann, wird eine Exception geworfen. Geschieht dies innerhalb einer PL-Pr\u00fcfung, so wird der entsprechende Fehlerschl\u00fcssel angeschrieben.");
        this.makeFunction("ALS_GANZZAHL_OHNE_RUNDUNG", new MetaProgramParameter[]{this.makeParameter("wert", -1, null)}, "Die Funktion ALS_GANZZAHL_OHNE_RUNDUNG liefert einen vorgegebenen Wert als Ganzzahl zur\u00fcck. Kommazahlen werden nicht gerundet sondern abgeschnitten. Falls der Wert nicht in eine Ganzzahl konvertiert werden kann, wird eine Exception geworfen. Geschieht dies innerhalb einer PL-Pr\u00fcfung, so wird der entsprechende Fehlerschl\u00fcssel angeschrieben.");
        this.makeFunction("ALS_KOMMAZAHL", new MetaProgramParameter[]{this.makeParameter("wert", -1, null)}, "Die Funktion ALS_KOMMAZAHL liefert einen vorgegebenen Wert als Kommazahl zur\u00fcck. Falls der Wert eine Zeichenkette ist, muss er in eine Kommazahl konvertierbar sein, d.h. als Dezimaltrenner muss das Komma (,) verwendet werden und als 1000-er-Trenner kann der Punkt (.) verwendet werden. Falls der Wert nicht in eine Kommazahl konvertiert werden kann, wird eine Exception geworfen. Geschieht dies innerhalb einer PL-Pr\u00fcfung, so wird der entsprechende Fehlerschl\u00fcssel angeschrieben.");
        this.makeFunction("ALS_ZEICHENKETTE", new MetaProgramParameter[]{this.makeParameter("wert", -1, null)}, "Die Funktion ALS_ZEICHENKETTE liefert einen vorgegebenen Wert als Zeichenkette zur\u00fcck. Falls der Wert eine Kommazahl ist, wird als Dezimaltrenner das Komma (,) verwendet. Falls der Wert eine Zahl ist, enth\u00e4lt der gelieferte Zeichenkette keine 1000-er-Trenner.");
        this.makeFunction("HEUTE", new MetaProgramParameter[0], "Erzeugt ein Datum, basierend auf dem heutigen Tag, Monat, Jahr.");
        this.makeFunction("JAHR", new MetaProgramParameter[]{this.makeParameter("datumsfeld", 3, null)}, "Gibt das Jahr des Datumsfeldes als maximal vierstellige Zahl zur\u00fcck.");
        this.makeFunction("JAHR_ALS_ZEICHENKETTE", new MetaProgramParameter[]{this.makeParameter("datumsfeld", 3, null)}, "Gibt das Jahr des Datumsfeldes als vierstellige, gegebenenfalls mit 0 aufgef\u00fcllte Zeichenkette zur\u00fcck.");
        this.makeFunction("MONAT", new MetaProgramParameter[]{this.makeParameter("datumsfeld", 3, null)}, "Gibt den Monat des Datumsfeldes als maximal zweistellige Zahl zur\u00fcck.");
        this.makeFunction("MONAT_ALS_ZEICHENKETTE", new MetaProgramParameter[]{this.makeParameter("datumsfeld", 3, null)}, "Gibt den Monat des Datumsfeldes als zweistellige, gegebenenfalls mit 0 aufgef\u00fcllte Zeichenkette zur\u00fcck.");
        this.makeFunction("TAG", new MetaProgramParameter[]{this.makeParameter("datumsfeld", 3, null)}, "Gibt den Tag des Datumsfeldes als maximal zweistellige Zahl zur\u00fcck.");
        this.makeFunction("TAG_ALS_ZEICHENKETTE", new MetaProgramParameter[]{this.makeParameter("datumsfeld", 3, null)}, "Gibt den Tag des Datumsfeldes als zweistellige, gegebenenfalls mit 0 aufgef\u00fcllte Zeichenkette zur\u00fcck.");
        this.makeFunction("DATUM_VERSCHIEBEN", new MetaProgramParameter[]{this.makeParameter("datumsfeld", 3, null), this.makeParameter("delta", 5, null), this.makeParameter("einheit", 2, null)}, "Verschiebt das Datum um den angegeben Wert in der angegebenen Einheit und gibt das berechnete Datum zur\u00fcck. Die g\u00fcltigen Einheiten sind: 'J' - Jahr, 'M' - Monat, 'W' - Woche, 'T' - Tag, 'A' - Arbeitstag.\nBeispiel: &DATUM_VERSCHIEBEN(DATUMSWERT('02.01.2013'), +2, 'M') ==> 02.03.2013");
        this.makeFunction("DATUM_DIFFERENZ", new MetaProgramParameter[]{this.makeParameter("datumsfeld1", 3, null), this.makeParameter("datumsfeld2", 3, null), this.makeParameter("einheit", 2, null)}, "Berechnet die Differenz zwischen zwei Datumswerten in der angegeben Einheit und gibt das Ergebnis als Ganzzahl zur\u00fcck. Wenn das erste Datum nach dem zweiten Datum liegt, wird ein negativer Wert zur\u00fcckgeliefert. Die g\u00fcltigen Einheiten sind: 'J' - Jahr, 'W' - Woche, 'T' - Tag.\nBeispiele: &DATUM_DIFFERENZ(DATUMSWERT('02.01.2013'), DATUMSWERT('05.01.2013'), 'T') ==> 3\n&DATUM_DIFFERENZ(DATUMSWERT('17.01.2013'), DATUMSWERT('2.01.2013'), 'W') ==> -2");
        this.makeFunction("ZUFALLSZAHL_AUS_LISTE", new MetaProgramParameter[]{this.makeParameter("liste", 1, new int[]{-1})}, "Erzeugt eine Zufallszahl. Die erzeugte Zahl ist ein Wert aus der angegebenen Liste.");
        this.makeFunction("ZUFALLSZAHL_AUS_REIHE", new MetaProgramParameter[]{this.makeParameter("reihe", -1, null)}, "Erzeugt eine Zufallszahl. Die erzeugte Zahl ist ein Wert aus der angegebenen Reihe. An dieser Stelle darf keine Intervallschreibweise verwendet werden.");
        this.makeFunction("ABSOLUTWERT", new MetaProgramParameter[]{this.makeParameter("wert", 1, null)}, "Die Funktion ABSOLUTWERT liefert den absoluten Wert einer Zahl. Dieser entspricht dem Wert der Zahl ohne ihr Vorzeichen. Ist der Wert leer, wird der Leerwert geliefert. Falls der Wert kein Zahlenwert ist, wird versucht den Wert in eine Zahl zu konvertieren. Ist dies nicht m\u00f6glich, wird eine Exception geworfen. Geschieht dies innerhalb einer PL-Pr\u00fcfung, so wird der entsprechende Fehlerschl\u00fcssel angeschrieben.");
        this.makeFunction("LOGARITHMUS", new MetaProgramParameter[]{this.makeParameter("wert", 1, null), this.makeParameter("basis", 1, null)}, "Liefert den Logarithmus einer Zahl zu einer vorgegebenen Basis.");
        this.makeFunction("NATUERLICHER_LOGARITHMUS", new MetaProgramParameter[]{this.makeParameter("wert", 1, null)}, "Liefert den nat\u00fcrlichen Logarithmus einer Zahl (zur Basis e).");
        this.makeFunction("MAXIMUM_AUS_REIHE", new MetaProgramParameter[]{this.makeParameter("reihe", -1, null)}, "Liefert das Maximum aus der vorgegebenen Reihe. An dieser Stelle darf keine Intervall-schreibweise verwendet werden.");
        this.makeFunction("MAXIMUM_AUS_LISTE", new MetaProgramParameter[]{this.makeParameter("liste", 1, new int[]{-1})}, "Liefert das Maximum aus der vorgegebenen Liste.");
        this.makeFunction("ZUFALLSZAHL", new MetaProgramParameter[0], "Liefert eine gleichverteilte Zufallszahl zwischen 0,0 (inklusive) und 1,0 (exklusive).");
        this.makeFunction("NORMALVERTEILTE_ZUFALLSZAHL", new MetaProgramParameter[]{this.makeParameter("mittelwert", 1, null), this.makeParameter("varianz", 1, null)}, "Liefert eine normalverteilte Zufallszahl mit dem vorgegebenen Mittelwert und der vorgegebe-nen Varianz.");
    }

    private MetaProgramParameter makeParameter(String name, int typ, int[] dimensions) {
        return new MetaProgramParameter(new MetaIdentifier(name), dimensions);
    }

    private void makeFunction(String name, MetaProgramParameter[] params, String description) {
        Vector<MetaProgramParameter> paramsV = new Vector<MetaProgramParameter>();
        int i = 0;
        while (i < params.length) {
            paramsV.add(params[i]);
            ++i;
        }
        MetaCustomFunktion function = new MetaCustomFunktion();
        function.setName(name);
        function.setRueckgabeTyp((short)-1);
        function.setFunctionType(0);
        function.setMetaSpezifikation(new MetaProgram(name, null, paramsV));
        function.setBeschreibung(description);
        this.functions.put(name, function);
    }
}

