/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.compare.ui;

import de.statspez.pleditor.generator.compare.ComparedNode;
import de.statspez.pleditor.generator.compare.ui.CompareEditor;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TreeColorRenderer
extends DefaultTreeCellRenderer {
    private static Icon TOPIC_ICON = new ImageIcon(TreeColorRenderer.class.getResource("/de/statspez/pleditor/generator/images/themenbereich.gif"));
    private static Icon TOPICFIELD_ICON = new ImageIcon(TreeColorRenderer.class.getResource("/de/statspez/pleditor/generator/images/subthemenbereich.gif"));
    private static Icon FEATURE_ICON = new ImageIcon(TreeColorRenderer.class.getResource("/de/statspez/pleditor/generator/images/tbfeld.gif"));
    private static final long serialVersionUID = 1L;
    private ComparedNode node;
    private CompareEditor compareEditor;

    public TreeColorRenderer(CompareEditor compareEditor) {
        this.compareEditor = compareEditor;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof ComparedNode) {
            this.node = (ComparedNode)value;
            if (this.node.getElement() instanceof MetaThemenbereich) {
                this.setIcon(TOPIC_ICON);
            } else if (((MetaTBFeld)this.node.getElement()).getKlasse() instanceof MetaThemenbereich) {
                this.setIcon(TOPICFIELD_ICON);
            } else {
                this.setIcon(FEATURE_ICON);
            }
            Color background = null;
            if (!sel) {
                if (this.node.isChanged()) {
                    background = this.compareEditor.getColorForChanges();
                } else if (this.node.hasDifferentValues()) {
                    background = this.compareEditor.getColorForDifferences();
                }
            }
            if (background != null) {
                this.setBackground(background);
                this.setOpaque(true);
            } else {
                this.setOpaque(false);
            }
        }
        return comp;
    }
}

