/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.html;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.cyberneko.html.HTMLComponent;
import org.cyberneko.html.HTMLElements;
import org.cyberneko.html.HTMLErrorReporter;
import org.cyberneko.html.HTMLEventInfo;

public class HTMLTagBalancer
implements XMLDocumentFilter,
HTMLComponent {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    protected static final String REPORT_ERRORS = "http://cyberneko.org/html/features/report-errors";
    protected static final String DOCUMENT_FRAGMENT_DEPRECATED = "http://cyberneko.org/html/features/document-fragment";
    protected static final String DOCUMENT_FRAGMENT = "http://cyberneko.org/html/features/balance-tags/document-fragment";
    protected static final String IGNORE_OUTSIDE_CONTENT = "http://cyberneko.org/html/features/balance-tags/ignore-outside-content";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/namespaces", "http://cyberneko.org/html/features/augmentations", "http://cyberneko.org/html/features/report-errors", "http://cyberneko.org/html/features/document-fragment", "http://cyberneko.org/html/features/balance-tags/document-fragment", "http://cyberneko.org/html/features/balance-tags/ignore-outside-content"};
    private static final Boolean[] RECOGNIZED_FEATURES_DEFAULTS = new Boolean[]{null, null, null, null, Boolean.FALSE, Boolean.FALSE};
    protected static final String NAMES_ELEMS = "http://cyberneko.org/html/properties/names/elems";
    protected static final String NAMES_ATTRS = "http://cyberneko.org/html/properties/names/attrs";
    protected static final String ERROR_REPORTER = "http://cyberneko.org/html/properties/error-reporter";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://cyberneko.org/html/properties/names/elems", "http://cyberneko.org/html/properties/names/attrs", "http://cyberneko.org/html/properties/error-reporter"};
    private static final Object[] RECOGNIZED_PROPERTIES_DEFAULTS = new Object[]{null, null, null};
    protected static final short NAMES_NO_CHANGE = 0;
    protected static final short NAMES_MATCH = 0;
    protected static final short NAMES_UPPERCASE = 1;
    protected static final short NAMES_LOWERCASE = 2;
    protected static final HTMLEventInfo SYNTHESIZED_ITEM = new HTMLEventInfo.SynthesizedItem();
    protected boolean fNamespaces;
    protected boolean fAugmentations;
    protected boolean fReportErrors;
    protected boolean fDocumentFragment;
    protected boolean fIgnoreOutsideContent;
    protected short fNamesElems;
    protected short fNamesAttrs;
    protected HTMLErrorReporter fErrorReporter;
    protected XMLDocumentSource fDocumentSource;
    protected XMLDocumentHandler fDocumentHandler;
    protected final InfoStack fElementStack = new InfoStack();
    protected final InfoStack fInlineStack = new InfoStack();
    protected boolean fSeenAnything;
    protected boolean fSeenDoctype;
    protected boolean fSeenRootElement;
    protected boolean fSeenRootElementEnd;
    protected boolean fSeenHeadElement;
    protected boolean fSeenBodyElement;
    private final QName fQName = new QName();
    private final XMLAttributes fEmptyAttrs = new XMLAttributesImpl();
    private final Augmentations fInfosetAugs = new AugmentationsImpl();
    static /* synthetic */ Class class$org$apache$xerces$xni$XMLLocator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$xerces$xni$NamespaceContext;
    static /* synthetic */ Class class$org$apache$xerces$xni$Augmentations;

    public Boolean getFeatureDefault(String string) {
        int n = RECOGNIZED_FEATURES != null ? RECOGNIZED_FEATURES.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!RECOGNIZED_FEATURES[i].equals(string)) continue;
            return RECOGNIZED_FEATURES_DEFAULTS[i];
        }
        return null;
    }

    public Object getPropertyDefault(String string) {
        int n = RECOGNIZED_PROPERTIES != null ? RECOGNIZED_PROPERTIES.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!RECOGNIZED_PROPERTIES[i].equals(string)) continue;
            return RECOGNIZED_PROPERTIES_DEFAULTS[i];
        }
        return null;
    }

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fNamespaces = xMLComponentManager.getFeature(NAMESPACES);
        this.fAugmentations = xMLComponentManager.getFeature(AUGMENTATIONS);
        this.fReportErrors = xMLComponentManager.getFeature(REPORT_ERRORS);
        this.fDocumentFragment = xMLComponentManager.getFeature(DOCUMENT_FRAGMENT) || xMLComponentManager.getFeature(DOCUMENT_FRAGMENT_DEPRECATED);
        this.fNamesElems = HTMLTagBalancer.getNamesValue(String.valueOf(xMLComponentManager.getProperty(NAMES_ELEMS)));
        this.fNamesAttrs = HTMLTagBalancer.getNamesValue(String.valueOf(xMLComponentManager.getProperty(NAMES_ATTRS)));
        this.fErrorReporter = (HTMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        if (string.equals(AUGMENTATIONS)) {
            this.fAugmentations = bl;
            return;
        }
        if (string.equals(REPORT_ERRORS)) {
            this.fReportErrors = bl;
            return;
        }
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.equals(NAMES_ELEMS)) {
            this.fNamesElems = HTMLTagBalancer.getNamesValue(String.valueOf(object));
            return;
        }
        if (string.equals(NAMES_ATTRS)) {
            this.fNamesAttrs = HTMLTagBalancer.getNamesValue(String.valueOf(object));
            return;
        }
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fElementStack.top = 0;
        this.fSeenAnything = false;
        this.fSeenDoctype = false;
        this.fSeenRootElement = false;
        this.fSeenRootElementEnd = false;
        this.fSeenHeadElement = false;
        this.fSeenBodyElement = false;
        if (this.fDocumentHandler != null) {
            try {
                Class<?> clazz = this.fDocumentHandler.getClass();
                Class[] classArray = new Class[]{class$org$apache$xerces$xni$XMLLocator == null ? (class$org$apache$xerces$xni$XMLLocator = HTMLTagBalancer.class$("org.apache.xerces.xni.XMLLocator")) : class$org$apache$xerces$xni$XMLLocator, class$java$lang$String == null ? (class$java$lang$String = HTMLTagBalancer.class$("java.lang.String")) : class$java$lang$String, class$org$apache$xerces$xni$NamespaceContext == null ? (class$org$apache$xerces$xni$NamespaceContext = HTMLTagBalancer.class$("org.apache.xerces.xni.NamespaceContext")) : class$org$apache$xerces$xni$NamespaceContext, class$org$apache$xerces$xni$Augmentations == null ? (class$org$apache$xerces$xni$Augmentations = HTMLTagBalancer.class$("org.apache.xerces.xni.Augmentations")) : class$org$apache$xerces$xni$Augmentations};
                Method method = clazz.getMethod("startDocument", classArray);
                Object[] objectArray = new Object[]{xMLLocator, string, namespaceContext, augmentations};
                method.invoke((Object)this.fDocumentHandler, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XNIException((Exception)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new XNIException((Exception)invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    Class<?> clazz = this.fDocumentHandler.getClass();
                    Class[] classArray = new Class[]{class$org$apache$xerces$xni$XMLLocator == null ? (class$org$apache$xerces$xni$XMLLocator = HTMLTagBalancer.class$("org.apache.xerces.xni.XMLLocator")) : class$org$apache$xerces$xni$XMLLocator, class$java$lang$String == null ? (class$java$lang$String = HTMLTagBalancer.class$("java.lang.String")) : class$java$lang$String, class$org$apache$xerces$xni$Augmentations == null ? (class$org$apache$xerces$xni$Augmentations = HTMLTagBalancer.class$("org.apache.xerces.xni.Augmentations")) : class$org$apache$xerces$xni$Augmentations};
                    Method method = clazz.getMethod("startDocument", classArray);
                    Object[] objectArray = new Object[]{xMLLocator, string, augmentations};
                    method.invoke((Object)this.fDocumentHandler, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new XNIException((Exception)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new XNIException((Exception)invocationTargetException);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    throw new XNIException((Exception)noSuchMethodException2);
                }
            }
        }
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (!this.fSeenAnything && this.fDocumentHandler != null) {
            this.fDocumentHandler.xmlDecl(string, string2, string3, augmentations);
        }
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        this.fSeenAnything = true;
        if (this.fReportErrors) {
            if (this.fSeenRootElement) {
                this.fErrorReporter.reportError("HTML2010", null);
            } else if (this.fSeenDoctype) {
                this.fErrorReporter.reportError("HTML2011", null);
            }
        }
        if (!this.fSeenRootElement && !this.fSeenDoctype) {
            this.fSeenDoctype = true;
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.doctypeDecl(string, string2, string3, augmentations);
            }
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        if (!this.fSeenRootElement && !this.fDocumentFragment) {
            if (this.fReportErrors) {
                this.fErrorReporter.reportError("HTML2000", null);
            }
            String string = HTMLTagBalancer.modifyName("html", this.fNamesElems);
            this.fQName.setValues(null, string, string, null);
            if (this.fDocumentHandler != null) {
                this.callStartElement(this.fQName, this.emptyAttributes(), this.synthesizedAugs());
                this.callEndElement(this.fQName, this.synthesizedAugs());
            }
        } else {
            int n = this.fElementStack.top;
            for (int i = 0; i < n; ++i) {
                Info info = this.fElementStack.pop();
                if (this.fReportErrors) {
                    String string = info.qname.rawname;
                    this.fErrorReporter.reportWarning("HTML2001", new Object[]{string});
                }
                if (this.fDocumentHandler == null) continue;
                this.callEndElement(info.qname, this.synthesizedAugs());
            }
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument(augmentations);
        }
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fSeenAnything = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.comment(xMLString, augmentations);
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fSeenAnything = true;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.processingInstruction(string, xMLString, augmentations);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fSeenAnything = true;
        if (this.fSeenRootElementEnd) {
            return;
        }
        HTMLElements.Element element = this.getElement(qName.rawname);
        if (this.fSeenRootElement && element.code == 46) {
            return;
        }
        if (element.code == 44) {
            if (this.fSeenHeadElement) {
                return;
            }
            this.fSeenHeadElement = true;
        }
        if (element.code == 14) {
            if (this.fSeenBodyElement) {
                return;
            }
            this.fSeenBodyElement = true;
        }
        if (element.parent != null) {
            Object object;
            if (!this.fSeenRootElement && !this.fDocumentFragment) {
                String string;
                object = element.parent[0].name;
                object = HTMLTagBalancer.modifyName((String)object, this.fNamesElems);
                if (this.fReportErrors) {
                    string = qName.rawname;
                    this.fErrorReporter.reportWarning("HTML2002", new Object[]{string, object});
                }
                string = new QName(null, (String)object, (String)object, null);
                this.startElement((QName)string, null, this.synthesizedAugs());
            } else {
                int n;
                object = element.parent[0];
                if ((((HTMLElements.Element)object).code != 44 || !this.fSeenBodyElement && !this.fDocumentFragment) && (n = this.getParentDepth(element.parent, element.bounds)) == -1) {
                    String string = ((HTMLElements.Element)object).name;
                    string = HTMLTagBalancer.modifyName(string, this.fNamesElems);
                    int n2 = this.getParentDepth(((HTMLElements.Element)object).parent, ((HTMLElements.Element)object).bounds);
                    if (n2 != -1) {
                        Object object2;
                        for (int i = 1; i < n2; ++i) {
                            object2 = this.fElementStack.peek();
                            if (this.fReportErrors) {
                                String string2 = HTMLTagBalancer.modifyName(((Info)object2).qname.rawname, this.fNamesElems);
                                String string3 = qName.rawname;
                                String string4 = ((HTMLElements.Element)object).parent[0].name;
                                string4 = HTMLTagBalancer.modifyName(string4, this.fNamesElems);
                                this.fErrorReporter.reportWarning("HTML2003", new Object[]{string2, string3, string, string4});
                            }
                            this.endElement(((Info)object2).qname, this.synthesizedAugs());
                        }
                        QName qName2 = new QName(null, string, string, null);
                        if (this.fReportErrors) {
                            object2 = qName.rawname;
                            this.fErrorReporter.reportWarning("HTML2004", new Object[]{object2, string});
                        }
                        this.startElement(qName2, null, this.synthesizedAugs());
                    }
                }
            }
        }
        int n = 0;
        if (element.flags == 0) {
            int n3 = this.fElementStack.top;
            this.fInlineStack.top = 0;
            for (int i = n3 - 1; i >= 0; --i) {
                Info info = this.fElementStack.data[i];
                if (!info.element.isInline()) break;
                this.fInlineStack.push(info);
                this.endElement(info.qname, this.synthesizedAugs());
            }
            n = this.fInlineStack.top;
        }
        if (element.closes != null) {
            int n4 = this.fElementStack.top;
            for (int i = n4 - 1; i >= 0; --i) {
                int n5;
                Info info = this.fElementStack.data[i];
                if (element.closes(info.element.code)) {
                    if (this.fReportErrors) {
                        String string = qName.rawname;
                        String string5 = info.qname.rawname;
                        this.fErrorReporter.reportWarning("HTML2005", new Object[]{string, string5});
                    }
                    for (n5 = n4 - 1; n5 >= i; --n5) {
                        info = this.fElementStack.pop();
                        if (this.fDocumentHandler == null) continue;
                        this.callEndElement(info.qname, null);
                    }
                    n4 = i;
                    continue;
                }
                n5 = info.element.isContainer();
                boolean bl = false;
                if (n5 == 0) {
                    for (int j = 0; j < element.parent.length; ++j) {
                        bl = bl || info.element.code == element.parent[j].code;
                    }
                }
                if (n5 != 0 || bl) break;
            }
        }
        this.fSeenRootElement = true;
        if (element != null && element.isEmpty()) {
            if (xMLAttributes == null) {
                xMLAttributes = this.emptyAttributes();
            }
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.emptyElement(qName, xMLAttributes, augmentations);
            }
        } else {
            boolean bl = element != null && element.isInline();
            this.fElementStack.push(new Info(element, qName, (XMLAttributes)(bl ? xMLAttributes : null)));
            if (xMLAttributes == null) {
                xMLAttributes = this.emptyAttributes();
            }
            if (this.fDocumentHandler != null) {
                this.callStartElement(qName, xMLAttributes, augmentations);
            }
        }
        for (int i = 0; i < n; ++i) {
            Info info = this.fInlineStack.pop();
            this.startElement(info.qname, info.attributes, this.synthesizedAugs());
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.startElement(qName, xMLAttributes, augmentations);
        this.endElement(qName, augmentations);
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        this.fSeenAnything = true;
        if (this.fSeenRootElementEnd) {
            return;
        }
        if (!this.fDocumentFragment) {
            Object object;
            boolean bl;
            boolean bl2 = bl = !this.fSeenRootElement;
            if (!bl) {
                object = this.fElementStack.peek();
                if (((Info)object).element.code == 44 || ((Info)object).element.code == 46) {
                    String string3 = HTMLTagBalancer.modifyName("head", this.fNamesElems);
                    String string4 = HTMLTagBalancer.modifyName("body", this.fNamesElems);
                    if (this.fReportErrors) {
                        this.fErrorReporter.reportWarning("HTML2009", new Object[]{string3, string4});
                    }
                    this.fQName.setValues(null, string3, string3, null);
                    this.endElement(this.fQName, this.synthesizedAugs());
                    bl = true;
                }
            }
            if (bl) {
                object = HTMLTagBalancer.modifyName("body", this.fNamesElems);
                this.fQName.setValues(null, (String)object, (String)object, null);
                if (this.fReportErrors) {
                    this.fErrorReporter.reportWarning("HTML2006", new Object[]{object});
                }
                this.startElement(this.fQName, null, this.synthesizedAugs());
            }
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startGeneralEntity(string, xMLResourceIdentifier, string2, augmentations);
        }
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        this.fSeenAnything = true;
        if (this.fSeenRootElementEnd) {
            return;
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.textDecl(string, string2, augmentations);
        }
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        if (this.fSeenRootElementEnd) {
            return;
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endGeneralEntity(string, augmentations);
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        this.fSeenAnything = true;
        if (this.fSeenRootElementEnd) {
            return;
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startCDATA(augmentations);
        }
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        if (this.fSeenRootElementEnd) {
            return;
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endCDATA(augmentations);
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fSeenRootElementEnd) {
            return;
        }
        boolean bl = true;
        for (int i = 0; i < xMLString.length; ++i) {
            if (Character.isWhitespace(xMLString.ch[xMLString.offset + i])) continue;
            bl = false;
            break;
        }
        if (!this.fDocumentFragment) {
            if (!this.fSeenRootElement) {
                if (bl) {
                    return;
                }
                String string = HTMLTagBalancer.modifyName("body", this.fNamesElems);
                this.fQName.setValues(null, string, string, null);
                if (this.fReportErrors) {
                    this.fErrorReporter.reportWarning("HTML2006", new Object[]{string});
                }
                this.startElement(this.fQName, null, this.synthesizedAugs());
            } else if (!bl) {
                Info info = this.fElementStack.peek();
                if (info.element.code == 44 || info.element.code == 46) {
                    String string = HTMLTagBalancer.modifyName("head", this.fNamesElems);
                    String string2 = HTMLTagBalancer.modifyName("body", this.fNamesElems);
                    if (this.fReportErrors) {
                        this.fErrorReporter.reportWarning("HTML2009", new Object[]{string, string2});
                    }
                    this.fQName.setValues(null, string, string, null);
                    this.endElement(this.fQName, this.synthesizedAugs());
                    this.fQName.setValues(null, string2, string2, null);
                    this.startElement(this.fQName, null, this.synthesizedAugs());
                }
            }
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.characters(xMLString, augmentations);
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.characters(xMLString, augmentations);
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        Object object;
        Object object2;
        int n;
        int n2;
        int n3;
        if (this.fSeenRootElementEnd) {
            return;
        }
        HTMLElements.Element element = this.getElement(qName.rawname);
        if (!(this.fIgnoreOutsideContent || element.code != 14 && element.code != 46)) {
            return;
        }
        if (element.code == 46) {
            this.fSeenRootElementEnd = true;
        }
        if ((n3 = this.getElementDepth(element)) == -1 && element.code == 77) {
            this.startElement(qName, this.emptyAttributes(), this.synthesizedAugs());
            this.endElement(qName, augmentations);
            return;
        }
        if (n3 > 1 && element.isInline()) {
            n2 = this.fElementStack.top;
            this.fInlineStack.top = 0;
            for (n = 0; n < n3 - 1; ++n) {
                object2 = this.fElementStack.data[n2 - n - 1];
                object = ((Info)object2).element;
                if (!((HTMLElements.Element)object).isInline()) continue;
                this.fInlineStack.push((Info)object2);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Info info = this.fElementStack.pop();
            if (this.fReportErrors && n2 < n3 - 1) {
                object2 = HTMLTagBalancer.modifyName(qName.rawname, this.fNamesElems);
                object = info.qname.rawname;
                this.fErrorReporter.reportWarning("HTML2007", new Object[]{object2, object});
            }
            if (this.fDocumentHandler == null) continue;
            this.callEndElement(info.qname, augmentations);
        }
        if (n3 > 1) {
            n2 = this.fInlineStack.top;
            for (n = 0; n < n2; ++n) {
                object2 = this.fInlineStack.pop();
                object = ((Info)object2).attributes;
                if (this.fReportErrors) {
                    String string = ((Info)object2).qname.rawname;
                    this.fErrorReporter.reportWarning("HTML2008", new Object[]{string});
                }
                this.startElement(((Info)object2).qname, (XMLAttributes)object, this.synthesizedAugs());
            }
        }
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
        this.fDocumentSource = xMLDocumentSource;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    public void startDocument(XMLLocator xMLLocator, String string, Augmentations augmentations) throws XNIException {
        this.startDocument(xMLLocator, string, null, augmentations);
    }

    public void startPrefixMapping(String string, String string2, Augmentations augmentations) throws XNIException {
        if (this.fSeenRootElementEnd) {
            return;
        }
        if (this.fDocumentHandler != null) {
            Class<?> clazz = this.fDocumentHandler.getClass();
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = HTMLTagBalancer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = HTMLTagBalancer.class$("java.lang.String")) : class$java$lang$String, class$org$apache$xerces$xni$Augmentations == null ? (class$org$apache$xerces$xni$Augmentations = HTMLTagBalancer.class$("org.apache.xerces.xni.Augmentations")) : class$org$apache$xerces$xni$Augmentations};
            try {
                Method method = clazz.getMethod("startPrefixMapping", classArray);
                Object[] objectArray = new Object[]{string, string2, augmentations};
                method.invoke((Object)this.fDocumentHandler, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public void endPrefixMapping(String string, Augmentations augmentations) throws XNIException {
        if (this.fSeenRootElementEnd) {
            return;
        }
        if (this.fDocumentHandler != null) {
            Class<?> clazz = this.fDocumentHandler.getClass();
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = HTMLTagBalancer.class$("java.lang.String")) : class$java$lang$String, class$org$apache$xerces$xni$Augmentations == null ? (class$org$apache$xerces$xni$Augmentations = HTMLTagBalancer.class$("org.apache.xerces.xni.Augmentations")) : class$org$apache$xerces$xni$Augmentations};
            try {
                Method method = clazz.getMethod("endPrefixMapping", classArray);
                Object[] objectArray = new Object[]{string, augmentations};
                method.invoke((Object)this.fDocumentHandler, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    protected HTMLElements.Element getElement(String string) {
        int n;
        if (this.fNamespaces && (n = string.indexOf(58)) != -1) {
            string = string.substring(n + 1);
        }
        return HTMLElements.getElement(string);
    }

    protected final void callStartElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fDocumentHandler.startElement(qName, xMLAttributes, augmentations);
    }

    protected final void callEndElement(QName qName, Augmentations augmentations) throws XNIException {
        this.fDocumentHandler.endElement(qName, augmentations);
    }

    protected final int getElementDepth(HTMLElements.Element element) {
        boolean bl = element.isContainer();
        int n = -1;
        for (int i = this.fElementStack.top - 1; i >= 0; --i) {
            Info info = this.fElementStack.data[i];
            if (info.element.code == element.code) {
                n = this.fElementStack.top - i;
                break;
            }
            if (!bl && info.element.isBlock()) break;
        }
        return n;
    }

    protected int getParentDepth(HTMLElements.Element[] elementArray, short s) {
        if (elementArray != null) {
            for (int i = this.fElementStack.top - 1; i >= 0; --i) {
                Info info = this.fElementStack.data[i];
                if (info.element.code == s) break;
                for (int j = 0; j < elementArray.length; ++j) {
                    if (info.element.code != elementArray[j].code) continue;
                    return this.fElementStack.top - i;
                }
            }
        }
        return -1;
    }

    protected final XMLAttributes emptyAttributes() {
        this.fEmptyAttrs.removeAllAttributes();
        return this.fEmptyAttrs;
    }

    protected final Augmentations synthesizedAugs() {
        Augmentations augmentations = null;
        if (this.fAugmentations) {
            augmentations = this.fInfosetAugs;
            Class<?> clazz = augmentations.getClass();
            Method method = null;
            try {
                method = clazz.getMethod("clear", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = clazz.getMethod("removeAllItems", null);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    augmentations = new AugmentationsImpl();
                }
            }
            if (method != null) {
                try {
                    method.invoke((Object)augmentations, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    augmentations = new AugmentationsImpl();
                }
                catch (InvocationTargetException invocationTargetException) {
                    augmentations = new AugmentationsImpl();
                }
            }
            augmentations.putItem(AUGMENTATIONS, (Object)SYNTHESIZED_ITEM);
        }
        return augmentations;
    }

    protected static final String modifyName(String string, short s) {
        switch (s) {
            case 1: {
                return string.toUpperCase();
            }
            case 2: {
                return string.toLowerCase();
            }
        }
        return string;
    }

    protected static final short getNamesValue(String string) {
        if (string.equals("lower")) {
            return 2;
        }
        if (string.equals("upper")) {
            return 1;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class InfoStack {
        public int top;
        public Info[] data = new Info[10];

        public void push(Info info) {
            if (this.top == this.data.length) {
                Info[] infoArray = new Info[this.top + 10];
                System.arraycopy(this.data, 0, infoArray, 0, this.top);
                this.data = infoArray;
            }
            this.data[this.top++] = info;
        }

        public Info peek() {
            return this.data[this.top - 1];
        }

        public Info pop() {
            return this.data[--this.top];
        }
    }

    public static class Info {
        public HTMLElements.Element element;
        public QName qname;
        public XMLAttributes attributes;

        public Info(HTMLElements.Element element, QName qName) {
            this(element, qName, null);
        }

        public Info(HTMLElements.Element element, QName qName, XMLAttributes xMLAttributes) {
            int n;
            this.element = element;
            this.qname = new QName(qName);
            if (xMLAttributes != null && (n = xMLAttributes.getLength()) > 0) {
                QName qName2 = new QName();
                XMLAttributesImpl xMLAttributesImpl = new XMLAttributesImpl();
                for (int i = 0; i < n; ++i) {
                    xMLAttributes.getName(i, qName2);
                    String string = xMLAttributes.getType(i);
                    String string2 = xMLAttributes.getValue(i);
                    String string3 = xMLAttributes.getNonNormalizedValue(i);
                    boolean bl = xMLAttributes.isSpecified(i);
                    xMLAttributesImpl.addAttribute(qName2, string, string2);
                    xMLAttributesImpl.setNonNormalizedValue(i, string3);
                    xMLAttributesImpl.setSpecified(i, bl);
                }
                this.attributes = xMLAttributesImpl;
            }
        }
    }
}

