/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import mondrian.util.AbstractMemoryMonitor;
import org.apache.log4j.Logger;

public class NotificationMemoryMonitor
extends AbstractMemoryMonitor {
    private static final Logger LOGGER = Logger.getLogger(NotificationMemoryMonitor.class);
    protected static final MemoryPoolMXBean TENURED_POOL = NotificationMemoryMonitor.findTenuredGenPool();

    private static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        throw new AssertionError((Object)"Could not find tenured space");
    }

    NotificationMemoryMonitor() {
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
        emitter.addNotificationListener(new NotificationHandler(), null, null);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void notifyNewLowThreshold(long newLowThreshold) {
        if (newLowThreshold == Long.MAX_VALUE) {
            TENURED_POOL.setUsageThreshold(0L);
        } else {
            TENURED_POOL.setUsageThreshold(newLowThreshold);
        }
    }

    @Override
    public long getMaxMemory() {
        return TENURED_POOL.getUsage().getMax();
    }

    @Override
    public long getUsedMemory() {
        return TENURED_POOL.getUsage().getUsed();
    }

    private class NotificationHandler
    implements NotificationListener {
        private NotificationHandler() {
        }

        @Override
        public void handleNotification(Notification notification, Object unused) {
            String type = notification.getType();
            if (type.equals("java.management.memory.threshold.exceeded")) {
                MemoryUsage usage = TENURED_POOL.getUsage();
                NotificationMemoryMonitor.this.notifyListeners(usage.getUsed(), usage.getMax());
            }
        }
    }
}

