/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import mondrian.olap.Util;
import mondrian.util.SlotFuture;

public class BlockingHashMap<K, V> {
    private final ConcurrentHashMap<K, SlotFuture<V>> map;

    public BlockingHashMap(int capacity) {
        this.map = new ConcurrentHashMap(capacity);
    }

    public void put(K k, V v) {
        this.map.putIfAbsent(k, new SlotFuture());
        this.map.get(k).put(v);
    }

    public V get(K k) throws InterruptedException {
        this.map.putIfAbsent(k, new SlotFuture());
        Object v = Util.safeGet((Future)this.map.get(k), "Waiting to retrieve a value from BlockingHashMap.");
        this.map.remove(k);
        return (V)v;
    }
}

