/*
 * Decompiled with CFR 0.152.
 */
package mondrian.udf;

import java.util.List;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.rolap.RolapUtil;
import mondrian.spi.UserDefinedFunction;

public class LastNonEmptyUdf
implements UserDefinedFunction {
    @Override
    public String getName() {
        return "LastNonEmpty";
    }

    @Override
    public String getDescription() {
        return "Returns the last member of a set whose value is not empty";
    }

    @Override
    public Syntax getSyntax() {
        return Syntax.Function;
    }

    @Override
    public Type getReturnType(Type[] parameterTypes) {
        SetType setType = (SetType)parameterTypes[0];
        MemberType memberType = (MemberType)setType.getElementType();
        return memberType;
    }

    @Override
    public Type[] getParameterTypes() {
        return new Type[]{new SetType(MemberType.Unknown), MemberType.Unknown};
    }

    @Override
    public Object execute(Evaluator evaluator, UserDefinedFunction.Argument[] arguments) {
        UserDefinedFunction.Argument memberListExp = arguments[0];
        List memberList = (List)memberListExp.evaluate(evaluator);
        UserDefinedFunction.Argument exp = arguments[1];
        int nullCount = 0;
        int missCount = 0;
        for (int i = memberList.size() - 1; i >= 0; --i) {
            Member member = (Member)memberList.get(i);
            Evaluator subEvaluator = evaluator.push();
            subEvaluator.setContext(member);
            int missCountBefore = subEvaluator.getMissCount();
            Object o = exp.evaluateScalar(subEvaluator);
            int missCountAfter = subEvaluator.getMissCount();
            if (Util.isNull(o)) {
                ++nullCount;
                continue;
            }
            if (missCountAfter > missCountBefore && ++missCount < 2 * nullCount + 1 || o == RolapUtil.valueNotReadyException) continue;
            if (o instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)o;
                if (o == RolapUtil.valueNotReadyException) continue;
                return runtimeException;
            }
            return member;
        }
        Hierarchy hierarchy = memberListExp.getType().getHierarchy();
        return hierarchy == null ? memberListExp.getType().getDimension().getHierarchies()[0].getNullMember() : hierarchy.getNullMember();
    }

    @Override
    public String[] getReservedWords() {
        return null;
    }
}

