/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.SQLException;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;
import mondrian.spi.impl.PostgreSqlDialect;

public class GreenplumDialect
extends PostgreSqlDialect {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(GreenplumDialect.class, Dialect.DatabaseProduct.POSTGRESQL){

        @Override
        protected boolean acceptsConnection(Connection connection) {
            return super.acceptsConnection(connection) && JdbcDialectImpl.isDatabase(Dialect.DatabaseProduct.GREENPLUM, connection);
        }
    };

    public GreenplumDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public boolean supportsGroupingSets() {
        return true;
    }

    @Override
    public boolean requiresGroupByAlias() {
        return true;
    }

    @Override
    public boolean requiresAliasForFromQuery() {
        return false;
    }

    @Override
    public boolean allowsCountDistinct() {
        return true;
    }

    @Override
    public boolean allowsFromQuery() {
        return false;
    }

    @Override
    public Dialect.DatabaseProduct getDatabaseProduct() {
        return Dialect.DatabaseProduct.GREENPLUM;
    }

    @Override
    public String generateCountExpression(String exp) {
        return this.caseWhenElse(exp + " ISNULL", "'0'", "TEXT(" + exp + ")");
    }

    @Override
    public boolean allowsRegularExpressionInWhereClause() {
        return this.productVersion.compareTo("3.2") >= 0;
    }
}

