/*
 * Decompiled with CFR 0.152.
 */
package mondrian.server;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import mondrian.olap.MondrianProperties;
import mondrian.olap.MondrianServer;
import mondrian.olap.Util;
import mondrian.olap4j.MondrianOlap4jDriver;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapSchema;
import mondrian.server.MondrianServerRegistry;
import mondrian.server.Repository;
import mondrian.server.RepositoryContentFinder;
import mondrian.spi.CatalogLocator;
import mondrian.tui.XmlaSupport;
import mondrian.util.ClassResolver;
import mondrian.util.LockBox;
import mondrian.util.Pair;
import mondrian.xmla.DataSourcesConfig;
import org.apache.log4j.Logger;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapWrapper;
import org.olap4j.impl.Olap4jUtil;

public class FileRepository
implements Repository {
    private static final Object SERVER_INFO_LOCK = new Object();
    private final RepositoryContentFinder repositoryContentFinder;
    private static final Logger LOGGER = Logger.getLogger(MondrianServer.class);
    private static final ScheduledExecutorService executorService = Util.getScheduledExecutorService(1, "mondrian.server.DynamicContentFinder$executorService");
    private ServerInfo serverInfo;
    private final ScheduledFuture<?> scheduledFuture;
    private final CatalogLocator locator;

    public FileRepository(RepositoryContentFinder repositoryContentFinder, CatalogLocator locator) {
        this.repositoryContentFinder = repositoryContentFinder;
        this.locator = locator;
        assert (repositoryContentFinder != null);
        Pair<Long, TimeUnit> interval = Util.parseInterval(String.valueOf(MondrianProperties.instance().XmlaSchemaRefreshInterval.get()), TimeUnit.MILLISECONDS);
        this.scheduledFuture = executorService.scheduleWithFixedDelay(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = SERVER_INFO_LOCK;
                synchronized (object) {
                    FileRepository.this.serverInfo = null;
                }
            }
        }, 0L, (Long)interval.left, (TimeUnit)((Object)interval.right));
    }

    @Override
    public List<Map<String, Object>> getDatabases(RolapConnection connection) {
        ArrayList<Map<String, Object>> propsList = new ArrayList<Map<String, Object>>();
        for (DatabaseInfo dsInfo : this.getServerInfo().datasourceMap.values()) {
            propsList.add(dsInfo.properties);
        }
        return propsList;
    }

    @Override
    public OlapConnection getConnection(MondrianServer server, String databaseName, String catalogName, String roleName, Properties props) throws SQLException {
        CatalogInfo catalogInfo;
        DatabaseInfo datasourceInfo;
        ServerInfo serverInfo = this.getServerInfo();
        if (databaseName == null) {
            if (serverInfo.datasourceMap.size() == 0) {
                throw new OlapException("No databases configured on this server");
            }
            datasourceInfo = (DatabaseInfo)serverInfo.datasourceMap.values().iterator().next();
        } else {
            datasourceInfo = (DatabaseInfo)serverInfo.datasourceMap.get(databaseName);
        }
        if (datasourceInfo == null) {
            throw Util.newError("Unknown database '" + databaseName + "'");
        }
        if (catalogName == null) {
            if (datasourceInfo.catalogMap.size() == 0) {
                throw new OlapException("No catalogs in the database named " + datasourceInfo.name);
            }
            catalogInfo = (CatalogInfo)datasourceInfo.catalogMap.values().iterator().next();
        } else {
            catalogInfo = (CatalogInfo)datasourceInfo.catalogMap.get(catalogName);
        }
        if (catalogInfo == null) {
            throw Util.newError("Unknown catalog '" + catalogName + "'");
        }
        String connectString = catalogInfo.olap4jConnectString;
        LockBox.Entry entry = MondrianServerRegistry.INSTANCE.lockBox.register(server);
        Properties properties = new Properties();
        properties.setProperty(RolapConnectionProperties.Instance.name(), entry.getMoniker());
        if (roleName != null) {
            properties.setProperty(RolapConnectionProperties.Role.name(), roleName);
        }
        properties.putAll((Map<?, ?>)props);
        try {
            ClassResolver.INSTANCE.forName(MondrianOlap4jDriver.class.getName(), true);
        }
        catch (ClassNotFoundException e) {
            throw new OlapException("Cannot find mondrian olap4j driver.");
        }
        Connection connection = DriverManager.getConnection(connectString, properties);
        return (OlapConnection)((OlapWrapper)connection).unwrap(OlapConnection.class);
    }

    @Override
    public void shutdown() {
        this.scheduledFuture.cancel(false);
        this.repositoryContentFinder.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerInfo getServerInfo() {
        Object object = SERVER_INFO_LOCK;
        synchronized (object) {
            if (this.serverInfo != null) {
                return this.serverInfo;
            }
            String content = this.repositoryContentFinder.getContent();
            DataSourcesConfig.DataSources xmlDataSources = XmlaSupport.parseDataSources(content, LOGGER);
            ServerInfo serverInfo = new ServerInfo();
            for (DataSourcesConfig.DataSource xmlDataSource : xmlDataSources.dataSources) {
                Map dsPropsMap = Olap4jUtil.mapOf((Object)"DataSourceName", (Object)xmlDataSource.getDataSourceName(), (Object[])new Object[]{"DataSourceDescription", xmlDataSource.getDataSourceDescription(), "URL", xmlDataSource.getURL(), "DataSourceInfo", xmlDataSource.getDataSourceName(), "ProviderName", xmlDataSource.getProviderName(), "ProviderType", xmlDataSource.providerType, "AuthenticationMode", xmlDataSource.authenticationMode});
                DatabaseInfo databaseInfo = new DatabaseInfo(xmlDataSource.name, dsPropsMap);
                serverInfo.datasourceMap.put(xmlDataSource.name, databaseInfo);
                for (DataSourcesConfig.Catalog xmlCatalog : xmlDataSource.catalogs.catalogs) {
                    if (databaseInfo.catalogMap.containsKey(xmlCatalog.name)) {
                        throw Util.newError("more than one DataSource object has name '" + xmlCatalog.name + "'");
                    }
                    String connectString = xmlCatalog.dataSourceInfo != null ? xmlCatalog.dataSourceInfo : xmlDataSource.dataSourceInfo;
                    Util.PropertyList connectProperties = Util.parseConnectString(connectString);
                    if (connectProperties.get(RolapConnectionProperties.Catalog.name()) == null) {
                        connectString = connectString + ";" + RolapConnectionProperties.Catalog.name() + "=" + xmlCatalog.definition;
                    }
                    CatalogInfo catalogInfo = new CatalogInfo(xmlCatalog.name, connectString, this.locator);
                    databaseInfo.catalogMap.put(xmlCatalog.name, catalogInfo);
                }
            }
            this.serverInfo = serverInfo;
            return serverInfo;
        }
    }

    @Override
    public List<String> getCatalogNames(RolapConnection connection, String databaseName) {
        return new ArrayList<String>(((DatabaseInfo)this.getServerInfo().datasourceMap.get(databaseName)).catalogMap.keySet());
    }

    @Override
    public List<String> getDatabaseNames(RolapConnection connection) {
        return new ArrayList<String>(this.getServerInfo().datasourceMap.keySet());
    }

    @Override
    public Map<String, RolapSchema> getRolapSchemas(RolapConnection connection, String databaseName, String catalogName) {
        RolapSchema schema = ((CatalogInfo)((DatabaseInfo)this.getServerInfo().datasourceMap.get(databaseName)).catalogMap.get(catalogName)).getRolapSchema();
        return Collections.singletonMap(schema.getName(), schema);
    }

    private static class CatalogInfo {
        private final String connectString;
        private RolapSchema rolapSchema;
        private final String olap4jConnectString;
        private final CatalogLocator locator;

        CatalogInfo(String name, String connectString, CatalogLocator locator) {
            this.connectString = connectString;
            this.locator = locator;
            this.olap4jConnectString = connectString.startsWith("jdbc:") ? connectString : "jdbc:mondrian:" + connectString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RolapSchema getRolapSchema() {
            if (this.rolapSchema == null) {
                try (RolapConnection rolapConnection = null;){
                    rolapConnection = (RolapConnection)mondrian.olap.DriverManager.getConnection(this.connectString, this.locator);
                    this.rolapSchema = rolapConnection.getSchema();
                }
            }
            return this.rolapSchema;
        }
    }

    private static class DatabaseInfo {
        private final String name;
        private final Map<String, Object> properties;
        private Map<String, CatalogInfo> catalogMap = new HashMap<String, CatalogInfo>();

        DatabaseInfo(String name, Map<String, Object> properties) {
            this.name = name;
            this.properties = properties;
        }
    }

    private static class ServerInfo {
        private Map<String, DatabaseInfo> datasourceMap = new HashMap<String, DatabaseInfo>();

        private ServerInfo() {
        }
    }
}

