/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.rolap.RolapStar;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.QuerySpec;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.Dialect;
import mondrian.util.Pair;

public abstract class AbstractQuerySpec
implements QuerySpec {
    private final RolapStar star;
    protected final boolean countOnly;

    protected AbstractQuerySpec(RolapStar star, boolean countOnly) {
        this.star = star;
        this.countOnly = countOnly;
    }

    protected SqlQuery newSqlQuery() {
        return this.getStar().getSqlQuery();
    }

    @Override
    public RolapStar getStar() {
        return this.star;
    }

    protected void addMeasure(int i, SqlQuery sqlQuery) {
        RolapStar.Measure measure = this.getMeasure(i);
        if (!this.isPartOfSelect(measure)) {
            return;
        }
        Util.assertTrue(measure.getTable() == this.getStar().getFactTable());
        measure.getTable().addToFrom(sqlQuery, false, true);
        String exprInner = measure.getExpression() == null ? "*" : measure.generateExprString(sqlQuery);
        String exprOuter = measure.getAggregator().getExpression(exprInner);
        sqlQuery.addSelect(exprOuter, measure.getInternalType(), this.getMeasureAlias(i));
    }

    protected abstract boolean isAggregate();

    protected Map<String, String> nonDistinctGenerateSql(SqlQuery sqlQuery) {
        int i;
        RolapStar.Column[] columns = this.getColumns();
        int arity = columns.length;
        if (this.countOnly) {
            sqlQuery.addSelect("count(*)", SqlStatement.Type.INT);
        }
        for (i = 0; i < arity; ++i) {
            RolapStar.Column column = columns[i];
            RolapStar.Table table = column.getTable();
            if (table.isFunky()) continue;
            table.addToFrom(sqlQuery, false, true);
            String expr = column.generateExprString(sqlQuery);
            StarColumnPredicate predicate = this.getColumnPredicate(i);
            String where = RolapStar.Column.createInExpr(expr, predicate, column.getDatatype(), sqlQuery);
            if (!where.equals("true")) {
                sqlQuery.addWhere(where);
            }
            if (this.countOnly || !this.isPartOfSelect(column)) continue;
            Dialect dialect = sqlQuery.getDialect();
            Dialect.DatabaseProduct databaseProduct = dialect.getDatabaseProduct();
            String alias = databaseProduct == Dialect.DatabaseProduct.DB2_AS400 ? sqlQuery.addSelect(expr, column.getInternalType(), null) : sqlQuery.addSelect(expr, column.getInternalType(), this.getColumnAlias(i));
            if (this.isAggregate()) {
                sqlQuery.addGroupBy(expr, alias);
            }
            if (!this.isOrdered()) continue;
            sqlQuery.addOrderBy(expr, alias, true, false, false, true);
        }
        this.extraPredicates(sqlQuery);
        int count = this.getMeasureCount();
        for (i = 0; i < count; ++i) {
            this.addMeasure(i, sqlQuery);
        }
        return Collections.emptyMap();
    }

    protected boolean isPartOfSelect(RolapStar.Column col) {
        return true;
    }

    protected boolean isPartOfSelect(RolapStar.Measure measure) {
        return true;
    }

    protected boolean isOrdered() {
        return false;
    }

    @Override
    public Pair<String, List<SqlStatement.Type>> generateSqlQuery() {
        SqlQuery sqlQuery = this.newSqlQuery();
        int k = this.getDistinctMeasureCount();
        Dialect dialect = sqlQuery.getDialect();
        Map<String, String> groupingSetsAliases = !dialect.allowsCountDistinct() && k > 0 || !dialect.allowsMultipleCountDistinct() && k > 1 ? this.distinctGenerateSql(sqlQuery, this.countOnly) : this.nonDistinctGenerateSql(sqlQuery);
        if (!this.countOnly) {
            this.addGroupingFunction(sqlQuery);
            this.addGroupingSets(sqlQuery, groupingSetsAliases);
        }
        return sqlQuery.toSqlAndTypes();
    }

    protected void addGroupingFunction(SqlQuery sqlQuery) {
        throw new UnsupportedOperationException();
    }

    protected void addGroupingSets(SqlQuery sqlQuery, Map<String, String> groupingSetsAliases) {
        throw new UnsupportedOperationException();
    }

    protected int getDistinctMeasureCount() {
        int k = 0;
        int count = this.getMeasureCount();
        for (int i = 0; i < count; ++i) {
            RolapStar.Measure measure = this.getMeasure(i);
            if (!measure.getAggregator().isDistinct()) continue;
            ++k;
        }
        return k;
    }

    protected Map<String, String> distinctGenerateSql(SqlQuery outerSqlQuery, boolean countOnly) {
        int i;
        Dialect dialect = outerSqlQuery.getDialect();
        Dialect.DatabaseProduct databaseProduct = dialect.getDatabaseProduct();
        HashMap<String, String> groupingSetsAliases = new HashMap<String, String>();
        SqlQuery innerSqlQuery = this.newSqlQuery();
        if (databaseProduct == Dialect.DatabaseProduct.GREENPLUM) {
            innerSqlQuery.setDistinct(false);
        } else {
            innerSqlQuery.setDistinct(true);
        }
        RolapStar.Column[] columns = this.getColumns();
        int arity = columns.length;
        for (i = 0; i < arity; ++i) {
            RolapStar.Column column = columns[i];
            RolapStar.Table table = column.getTable();
            if (table.isFunky()) continue;
            table.addToFrom(innerSqlQuery, false, true);
            String expr = column.generateExprString(innerSqlQuery);
            StarColumnPredicate predicate = this.getColumnPredicate(i);
            String where = RolapStar.Column.createInExpr(expr, predicate, column.getDatatype(), innerSqlQuery);
            if (!where.equals("true")) {
                innerSqlQuery.addWhere(where);
            }
            if (countOnly) continue;
            String alias = "d" + i;
            alias = innerSqlQuery.addSelect(expr, null, alias);
            if (databaseProduct == Dialect.DatabaseProduct.GREENPLUM) {
                innerSqlQuery.addGroupBy(expr, alias);
            }
            String quotedAlias = dialect.quoteIdentifier(alias);
            outerSqlQuery.addSelectGroupBy(quotedAlias, null);
            groupingSetsAliases.put(expr, dialect.quoteIdentifier("dummyname." + alias));
        }
        this.extraPredicates(innerSqlQuery);
        int count = this.getMeasureCount();
        for (i = 0; i < count; ++i) {
            RolapStar.Measure measure = this.getMeasure(i);
            Util.assertTrue(measure.getTable() == this.getStar().getFactTable());
            measure.getTable().addToFrom(innerSqlQuery, false, true);
            String alias = this.getMeasureAlias(i);
            String expr = measure.generateExprString(outerSqlQuery);
            innerSqlQuery.addSelect(expr, measure.getInternalType(), alias);
            if (databaseProduct == Dialect.DatabaseProduct.GREENPLUM) {
                innerSqlQuery.addGroupBy(expr, alias);
            }
            outerSqlQuery.addSelect(measure.getAggregator().getNonDistinctAggregator().getExpression(dialect.quoteIdentifier(alias)), measure.getInternalType());
        }
        outerSqlQuery.addFrom(innerSqlQuery, "dummyname", true);
        return groupingSetsAliases;
    }

    protected void extraPredicates(SqlQuery sqlQuery) {
        List<StarPredicate> predicateList = this.getPredicateList();
        for (StarPredicate predicate : predicateList) {
            for (RolapStar.Column column : predicate.getConstrainedColumnList()) {
                RolapStar.Table table = column.getTable();
                table.addToFrom(sqlQuery, false, true);
            }
            StringBuilder buf = new StringBuilder();
            predicate.toSql(sqlQuery, buf);
            String where = buf.toString();
            if (where.equals("true")) continue;
            sqlQuery.addWhere(where);
        }
    }

    protected List<StarPredicate> getPredicateList() {
        return Collections.emptyList();
    }
}

