/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.AbstractIntegerCalc;
import mondrian.mdx.NamedSetExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.resource.MondrianResource;

public class NamedSetCurrentOrdinalFunDef
extends FunDefBase {
    static final NamedSetCurrentOrdinalFunDef instance = new NamedSetCurrentOrdinalFunDef();

    private NamedSetCurrentOrdinalFunDef() {
        super("CurrentOrdinal", "Returns the ordinal of the current iteration through a named set.", "pix");
    }

    @Override
    public Exp createCall(Validator validator, Exp[] args) {
        assert (args.length == 1);
        Exp arg0 = args[0];
        if (!(arg0 instanceof NamedSetExpr)) {
            throw MondrianResource.instance().NotANamedSet.ex();
        }
        return super.createCall(validator, args);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp arg0 = call.getArg(0);
        assert (arg0 instanceof NamedSetExpr) : "checked this in createCall";
        final NamedSetExpr namedSetExpr = (NamedSetExpr)arg0;
        return new AbstractIntegerCalc(call, new Calc[0]){

            @Override
            public int evaluateInteger(Evaluator evaluator) {
                return namedSetExpr.getEval(evaluator).currentOrdinal();
            }
        };
    }
}

