/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.maxq;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.MultipartPostMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;

public class HttpTestCase
extends TestCase {
    private HashMap connections = new HashMap();
    protected HttpMethod method = null;
    protected HttpClient client = new HttpClient();
    protected String data;
    private boolean followRedirects = false;
    private static String urlSearch;
    private static String urlReplace;

    public static String getUrlReplace() {
        return urlReplace;
    }

    public static String getUrlSearch() {
        return urlSearch;
    }

    public static void setURLReplace(String search, String replace) {
        urlSearch = search.trim();
        urlReplace = replace.trim();
    }

    public static String replaceURL(String url) {
        if (urlSearch == null || urlReplace == null) {
            return url;
        }
        int pos = url.indexOf(urlSearch);
        if (pos == -1) {
            return url;
        }
        String str = url.substring(0, pos) + urlReplace + url.substring(pos + urlSearch.length());
        return str;
    }

    public HttpTestCase(String name) {
        super(name);
    }

    public void Run() throws Throwable {
        Enumeration errors;
        TestResult result = super.run();
        if (result.errorCount() > 0 && (errors = result.errors()).hasMoreElements()) {
            TestFailure err = (TestFailure)errors.nextElement();
            throw err.thrownException();
        }
        if (result.failureCount() > 0) {
            Enumeration failures = result.failures();
            while (failures.hasMoreElements()) {
                TestFailure err = (TestFailure)failures.nextElement();
                if (!(err.thrownException() instanceof AssertionFailedError)) continue;
                String msg = "";
                if (this.method.getResponseBody() != null) {
                    msg = "\n\nResponse Data: \n\n" + new String(this.method.getResponseBody());
                }
                throw new AssertionFailedError(err.trace() + msg);
            }
        }
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    private void cleanupMethod() {
        if (this.method != null) {
            this.method.releaseConnection();
            this.method.recycle();
            this.method = null;
        }
    }

    public void get(String url) throws IOException {
        this.get(url, null);
    }

    public void get(String url, List args) throws IOException {
        this.cleanupMethod();
        url = HttpTestCase.replaceURL(url);
        this.method = new GetMethod(url);
        if (args != null) {
            this.method.setQueryString(this.listToNV(args));
        }
        this.method.setFollowRedirects(this.followRedirects);
        this.client.executeMethod(this.method);
    }

    public void post(String url) throws IOException {
        this.post(url, null);
    }

    public void post(String url, List args) throws IOException {
        this.cleanupMethod();
        url = HttpTestCase.replaceURL(url);
        PostMethod post = new PostMethod(url);
        if (args != null) {
            post.setRequestBody(this.listToNV(args));
        }
        this.method = post;
        this.method.setFollowRedirects(this.followRedirects);
        this.client.executeMethod(this.method);
    }

    public void postMultiPart(String url, String data, int contLen) throws IOException {
        this.postMultiPart(url, data, contLen, null);
    }

    public void postMultiPart(String url, String data, int contLen, List args) throws IOException {
        this.cleanupMethod();
        url = HttpTestCase.replaceURL(url);
        MultipartPostMethod multipartPost = new MultipartPostMethod(url);
        multipartPost.addPart((Part)new StringPart("data", data));
        if (args != null) {
            multipartPost.setQueryString(this.listToNV(args));
        }
        this.method = multipartPost;
        this.method.setFollowRedirects(this.followRedirects);
        this.client.executeMethod(this.method);
    }

    public void setConnections(HttpTestCase test) {
        test.connections = this.connections;
    }

    public NameValuePair[] listToNV(List list) {
        return list.toArray(new NameValuePair[0]);
    }

    public String urlDecode(String s) {
        return HttpTestCase.staticUrlDecode(s);
    }

    public static String staticUrlDecode(String s) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(s.length());
        for (int count = 0; count < s.length(); ++count) {
            if (s.charAt(count) == '%') {
                int b;
                int n = ++count;
                int a = Character.digit(s.charAt(n), 16);
                if ((a <<= 4) + (b = Character.digit(s.charAt(++count), 16)) == 39 || a + b == 132) {
                    out.write(92);
                }
                out.write(a + b);
                continue;
            }
            if (s.charAt(count) == '+') {
                out.write(32);
                continue;
            }
            out.write(s.charAt(count));
        }
        return out.toString();
    }

    protected void responseOK() throws URIException {
        int status = this.method.getStatusCode();
        HttpTestCase.assertTrue((String)("Invalid HTTP response: " + this.method + " for URI: " + this.method.getURI()), (status == 200 || status == 302 || status == 304 ? 1 : 0) != 0);
    }

    protected boolean responseContainsURI(String uri) throws URIException {
        return this.method != null && this.method.getURI().getPath().indexOf(uri) != -1;
    }

    protected boolean responseContains(String text) {
        if (this.method == null || this.method.getResponseBody() == null) {
            return false;
        }
        this.data = new String(this.method.getResponseBody());
        return this.data.indexOf(text) != -1;
    }

    protected void printResponse() {
        System.err.println(new String(this.method.getResponseBody()));
    }
}

