/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.typing.sequence;

import java.util.Collection;
import java.util.LinkedList;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.sequence.AnySequence;
import org.pentaho.reporting.libraries.formula.typing.sequence.RawArraySequence;

public class RecursiveSequence
implements Sequence {
    private LinkedList<Object> stack;
    private FormulaContext context;

    public RecursiveSequence(Object object, FormulaContext context) {
        this.context = context;
        this.stack = new LinkedList();
        this.stack.push(object);
    }

    @Override
    public boolean hasNext() throws EvaluationException {
        if (this.stack.isEmpty()) {
            return false;
        }
        Object o = this.stack.pop();
        if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            RawArraySequence s = new RawArraySequence(array);
            this.stack.push(s);
            return this.hasNext();
        }
        if (o instanceof Collection) {
            Collection array = (Collection)o;
            RawArraySequence s = new RawArraySequence(array);
            this.stack.push(s);
            return this.hasNext();
        }
        if (o instanceof ArrayCallback) {
            ArrayCallback array = (ArrayCallback)o;
            AnySequence s = new AnySequence(array, this.context);
            this.stack.push(s);
            return this.hasNext();
        }
        if (o instanceof Sequence) {
            Sequence s = (Sequence)o;
            if (s.hasNext()) {
                Object object = s.next();
                this.stack.push(s);
                this.stack.push(object);
            }
            return this.hasNext();
        }
        this.stack.push(o);
        return true;
    }

    @Override
    public Object next() throws EvaluationException {
        Object o = this.stack.pop();
        if (o instanceof Sequence) {
            Sequence sequence = (Sequence)o;
            return sequence.next();
        }
        return o;
    }

    @Override
    public LValue nextRawValue() throws EvaluationException {
        throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
    }
}

