/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.userdefined;

import java.util.ArrayList;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;
import org.pentaho.reporting.libraries.formula.typing.sequence.RecursiveSequence;

public class ArrayMidFunction
implements Function {
    @Override
    public String getCanonicalName() {
        return "ARRAYMID";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount != 3) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Object textValue = parameters.getValue(0);
        Type startType = parameters.getType(1);
        Object startValue = parameters.getValue(1);
        Type lengthType = parameters.getType(2);
        Object lengthValue = parameters.getValue(2);
        RecursiveSequence text = new RecursiveSequence(textValue, context);
        Number start = typeRegistry.convertToNumber(startType, startValue);
        Number length = typeRegistry.convertToNumber(lengthType, lengthValue);
        if (length.doubleValue() < 0.0 || start.doubleValue() < 1.0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        return new TypeValuePair(AnyType.ANY_ARRAY, ArrayMidFunction.process(text, start.intValue(), length.intValue()));
    }

    public static Object[] process(Sequence text, int start, int length) throws EvaluationException {
        ArrayList<Object> retval = new ArrayList<Object>(length);
        int counter = 0;
        int end = start + length;
        while (text.hasNext()) {
            Object o = text.next();
            if (++counter == end) break;
            if (counter < start) continue;
            retval.add(o);
        }
        return retval.toArray();
    }
}

