/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.database;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.ExtendedComparator;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class InFunction
implements Function {
    private static final TypeValuePair RETURN_TRUE = new TypeValuePair(LogicalType.TYPE, Boolean.TRUE);
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final long serialVersionUID = -3737884974501253814L;

    @Override
    public String getCanonicalName() {
        return "IN";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int length = parameters.getParameterCount();
        if (length < 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Object value1Raw = parameters.getValue(0);
        Type type1 = parameters.getType(0);
        for (int i = 1; i < parameters.getParameterCount(); ++i) {
            Object value2Raw = parameters.getValue(i);
            if (value1Raw == null || value2Raw == null) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_NA_VALUE);
            }
            Type type2 = parameters.getType(i);
            ExtendedComparator comparator = typeRegistry.getComparator(type1, type2);
            boolean result = comparator.isEqual(type1, value1Raw, type2, value2Raw);
            if (!result) continue;
            return RETURN_TRUE;
        }
        return RETURN_FALSE;
    }
}

