/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.Serializable;
import java.util.HashMap;

public class LFUMap<K, V>
implements Serializable,
Cloneable {
    private HashMap<K, MapEntry<K, V>> map;
    private MapEntry<K, V> first;
    private MapEntry<K, V> last;
    private int cacheSize;

    public LFUMap(int cacheSize) {
        this.cacheSize = Math.max(3, cacheSize);
        this.map = new HashMap(cacheSize);
    }

    public void clear() {
        this.map.clear();
        this.first = null;
        this.last = null;
    }

    public V get(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.first == null) {
            return null;
        }
        if (this.first == this.last) {
            if (this.first.getKey().equals(key)) {
                return this.first.getValue();
            }
            return null;
        }
        MapEntry<K, V> metrics = this.map.get(key);
        if (metrics == null) {
            return null;
        }
        MapEntry<K, V> prev = metrics.getPrevious();
        if (prev == null) {
            return metrics.getValue();
        }
        MapEntry<K, V> next = metrics.getNext();
        if (next == null) {
            prev.setNext(null);
            this.last = prev;
            metrics.setPrevious(null);
            metrics.setNext(this.first);
            this.first.setPrevious(metrics);
            this.first = metrics;
            return metrics.getValue();
        }
        next.setPrevious(prev);
        prev.setNext(next);
        metrics.setPrevious(null);
        metrics.setNext(this.first);
        this.first.setPrevious(metrics);
        this.first = metrics;
        return metrics.getValue();
    }

    public void put(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.first == null) {
            if (value == null) {
                return;
            }
            this.first = new MapEntry<K, V>(key, value);
            this.last = this.first;
            this.map.put(key, this.first);
            return;
        }
        if (value == null) {
            this.remove(key);
            return;
        }
        if (this.first.getKey().equals(key)) {
            this.first.setValue(value);
            return;
        }
        MapEntry entry = this.map.get(key);
        if (entry == null) {
            if (1 + this.map.size() >= this.cacheSize) {
                this.map.remove(this.last.getKey());
                MapEntry previous = this.last.getPrevious();
                this.last.setNext(null);
                this.last.setPrevious(null);
                previous.setNext(null);
                this.last = previous;
            }
            MapEntry<K, V> cacheEntry = new MapEntry<K, V>(key, value);
            this.first.setPrevious(cacheEntry);
            cacheEntry.setNext(this.first);
            this.map.put(key, cacheEntry);
            this.first = cacheEntry;
            return;
        }
        entry.setValue(value);
        if (entry == this.first) {
            throw new IllegalStateException("Duplicate return?");
        }
        if (entry == this.last) {
            MapEntry previous = this.last.getPrevious();
            previous.setNext(null);
            this.last = previous;
            this.first.setPrevious(entry);
            entry.setNext(this.first);
            entry.setPrevious(null);
            this.first = entry;
            return;
        }
        MapEntry<K, V> previous = entry.getPrevious();
        MapEntry<K, V> next = entry.getNext();
        previous.setNext(next);
        next.setPrevious(previous);
        this.first.setPrevious(entry);
        entry.setNext(this.first);
        entry.setPrevious(null);
        this.first = entry;
    }

    public void remove(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.first == null) {
            return;
        }
        MapEntry entry = this.map.remove(key);
        if (entry == null) {
            return;
        }
        if (entry == this.first) {
            MapEntry nextEntry = this.first.getNext();
            if (nextEntry == null) {
                this.first = null;
                this.last = null;
                entry.setNext(null);
                entry.setPrevious(null);
                return;
            }
            this.first = nextEntry;
            nextEntry.setPrevious(null);
            entry.setNext(null);
            entry.setPrevious(null);
            return;
        }
        if (entry == this.last) {
            MapEntry prev = this.last.getPrevious();
            prev.setNext(null);
            this.last = prev;
            entry.setNext(null);
            entry.setPrevious(null);
            return;
        }
        MapEntry<K, V> previous = entry.getPrevious();
        MapEntry<K, V> next = entry.getNext();
        previous.setNext(next);
        next.setPrevious(previous);
        entry.setNext(null);
        entry.setPrevious(null);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public int getMaximumSize() {
        return this.cacheSize;
    }

    public void validate() {
        if (this.first == null) {
            return;
        }
        if (this.first.getPrevious() != null) {
            throw new IllegalStateException();
        }
        if (this.last.getNext() != null) {
            throw new IllegalStateException();
        }
        int counter = 0;
        MapEntry<K, V> p = null;
        MapEntry<K, V> entryFromStart = this.first;
        while (entryFromStart != null) {
            if (entryFromStart.getPrevious() != p) {
                throw new IllegalStateException();
            }
            p = entryFromStart;
            entryFromStart = entryFromStart.getNext();
            ++counter;
        }
        if (counter != this.size()) {
            throw new IllegalStateException();
        }
        int fromEndCounter = 0;
        MapEntry<K, V> n = null;
        MapEntry<K, V> entryFromEnd = this.last;
        while (entryFromEnd != null) {
            if (entryFromEnd.getNext() != n) {
                throw new IllegalStateException();
            }
            n = entryFromEnd;
            entryFromEnd = entryFromEnd.getPrevious();
            ++fromEndCounter;
        }
        if (n != this.first) {
            throw new IllegalStateException();
        }
        if (fromEndCounter != this.size()) {
            throw new IllegalStateException();
        }
        if (this.size() > this.cacheSize) {
            throw new IllegalStateException();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        LFUMap map = (LFUMap)super.clone();
        map.map = (HashMap)this.map.clone();
        map.map.clear();
        for (MapEntry<K, V> entry = this.first; entry != null; entry = entry.getNext()) {
            K key = entry.getKey();
            V value = entry.getValue();
            map.put(key, value);
        }
        return map;
    }

    private static class MapEntry<K, V> {
        private K key;
        private V value;
        private MapEntry<K, V> previous;
        private MapEntry<K, V> next;

        protected MapEntry(K key, V value) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                throw new NullPointerException();
            }
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public MapEntry<K, V> getPrevious() {
            return this.previous;
        }

        public void setPrevious(MapEntry<K, V> previous) {
            this.previous = previous;
        }

        public MapEntry<K, V> getNext() {
            return this.next;
        }

        public void setNext(MapEntry<K, V> next) {
            this.next = next;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.value = value;
        }
    }
}

