/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.IOException;
import java.io.Writer;

public final class CSVQuoter {
    private char separator;
    private char quate;
    private String doubleQuate;
    private boolean forceQuote;

    public CSVQuoter() {
        this(',', '\"');
    }

    public CSVQuoter(char separator) {
        this(separator, '\"');
    }

    public CSVQuoter(char separator, char quate) {
        this(separator, quate, false);
    }

    public CSVQuoter(char separator, char quate, boolean forceQuoting) {
        this.forceQuote = forceQuoting;
        this.separator = separator;
        this.quate = quate;
        this.doubleQuate = String.valueOf(quate) + quate;
    }

    public String doQuoting(String original) {
        if (this.forceQuote || this.isQuotingNeeded(original)) {
            StringBuffer retval = new StringBuffer(original.length() + 5);
            retval.append(this.quate);
            this.applyQuote(retval, original);
            retval.append(this.quate);
            return retval.toString();
        }
        return original;
    }

    public void doQuoting(String original, Writer writer) throws IOException {
        if (this.isQuotingNeeded(original)) {
            writer.write(this.quate);
            this.applyQuote(writer, original);
            writer.write(this.quate);
        } else {
            writer.write(original);
        }
    }

    public String undoQuoting(String nativeString) {
        if (this.isQuotingNeeded(nativeString)) {
            int start;
            StringBuilder b = new StringBuilder(nativeString.length());
            int length = nativeString.length() - 1;
            int pos = start = 1;
            while (pos != -1) {
                pos = nativeString.indexOf(this.doubleQuate, start);
                if (pos == -1) {
                    b.append(nativeString.substring(start, length));
                    continue;
                }
                b.append(nativeString.substring(start, pos));
                start = pos + 1;
            }
            return b.toString();
        }
        return nativeString;
    }

    private boolean isQuotingNeeded(String str) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c == this.separator) {
                return true;
            }
            if (c == '\n') {
                return true;
            }
            if (c != this.quate) continue;
            return true;
        }
        return false;
    }

    private void applyQuote(StringBuffer b, String original) {
        int length = original.length();
        for (int i = 0; i < length; ++i) {
            char c = original.charAt(i);
            if (c == this.quate) {
                b.append(this.doubleQuate);
                continue;
            }
            b.append(c);
        }
    }

    private void applyQuote(Writer b, String original) throws IOException {
        int length = original.length();
        for (int i = 0; i < length; ++i) {
            char c = original.charAt(i);
            if (c == this.quate) {
                b.write(this.doubleQuate);
                continue;
            }
            b.write(c);
        }
    }

    public char getSeparator() {
        return this.separator;
    }

    public char getQuate() {
        return this.quate;
    }
}

