/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.libformula.editor.function;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.libformula.editor.function.FunctionExample;
import org.w3c.dom.Node;

public class FunctionDescription {
    public static final String XML_TAG = "function";
    private String category;
    private String name;
    private String description;
    private String syntax;
    private String returns;
    private String constraints;
    private String semantics;
    private List<FunctionExample> functionExamples;

    public FunctionDescription(String category, String name, String description, String syntax, String returns, String constraints, String semantics, List<FunctionExample> functionExamples) {
        this.category = category;
        this.name = name;
        this.description = description;
        this.syntax = syntax;
        this.returns = returns;
        this.constraints = constraints;
        this.semantics = semantics;
        this.functionExamples = functionExamples;
    }

    public FunctionDescription(Node node) {
        this.category = XMLHandler.getTagValue((Node)node, (String)"category");
        this.name = XMLHandler.getTagValue((Node)node, (String)"name");
        this.description = XMLHandler.getTagValue((Node)node, (String)"description");
        this.syntax = XMLHandler.getTagValue((Node)node, (String)"syntax");
        this.returns = XMLHandler.getTagValue((Node)node, (String)"returns");
        this.constraints = XMLHandler.getTagValue((Node)node, (String)"constraints");
        this.semantics = XMLHandler.getTagValue((Node)node, (String)"semantics");
        this.functionExamples = new ArrayList<FunctionExample>();
        Node examplesNode = XMLHandler.getSubNode((Node)node, (String)"examples");
        int nrExamples = XMLHandler.countNodes((Node)examplesNode, (String)"example");
        for (int i = 0; i < nrExamples; ++i) {
            Node exampleNode = XMLHandler.getSubNodeByNr((Node)examplesNode, (String)"example", (int)i);
            this.functionExamples.add(new FunctionExample(exampleNode));
        }
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    public String getReturns() {
        return this.returns;
    }

    public void setReturns(String returns) {
        this.returns = returns;
    }

    public String getConstraints() {
        return this.constraints;
    }

    public void setConstraints(String constraints) {
        this.constraints = constraints;
    }

    public String getSemantics() {
        return this.semantics;
    }

    public void setSemantics(String semantics) {
        this.semantics = semantics;
    }

    public List<FunctionExample> getFunctionExamples() {
        return this.functionExamples;
    }

    public void setFunctionExamples(List<FunctionExample> functionExamples) {
        this.functionExamples = functionExamples;
    }

    public String getHtmlReport() {
        StringBuffer report = new StringBuffer();
        report.append("<H2>").append(this.name).append("</H2>").append(Const.CR);
        report.append("<b><u>Description:</u></b> ").append(this.description).append("<br>").append(Const.CR);
        if (!Const.isEmpty((String)this.syntax)) {
            report.append("<b><u>Syntax:</u></b> <pre>").append(this.syntax).append("</pre><br>").append(Const.CR);
        }
        if (!Const.isEmpty((String)this.returns)) {
            report.append("<b><u>Returns:</u></b>  ").append(this.returns).append("<br>").append(Const.CR);
        }
        if (!Const.isEmpty((String)this.constraints)) {
            report.append("<b><u>Constraints:</u></b>  ").append(this.constraints).append("<br>").append(Const.CR);
        }
        if (!Const.isEmpty((String)this.semantics)) {
            report.append("<b><u>Semantics:</u></b>  ").append(this.semantics).append("<br>").append(Const.CR);
        }
        if (this.functionExamples.size() > 0) {
            report.append(Const.CR);
            report.append("<br><b><u>Examples:</u></b><p>  ").append(Const.CR);
            report.append("<table border=\"1\">");
            report.append("<tr>");
            report.append("<th>Expression</th>");
            report.append("<th>Result</th>");
            report.append("<th>Comment</th>");
            report.append("</tr>");
            for (FunctionExample example : this.functionExamples) {
                report.append("<tr>");
                report.append("<td>").append(example.getExpression()).append("</td>");
                report.append("<td>").append(example.getResult()).append("</td>");
                if (!Const.isEmpty((String)example.getComment())) {
                    report.append("<td>").append(example.getComment()).append("</td>");
                }
                report.append("</tr>");
                report.append(Const.CR);
            }
            report.append("</table>");
        }
        return report.toString();
    }
}

