/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.webservices.wsdl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.trans.steps.webservices.wsdl.DomUtils;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlOpParameter;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlOpReturnType;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlOperation;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlTypes;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlUtils;
import org.w3c.dom.Element;

public final class WsdlOpParameterList
extends ArrayList<WsdlOpParameter> {
    private static final long serialVersionUID = 1L;
    private final Operation _operation;
    private final WsdlTypes _wsdlTypes;
    private final HashSet<String> _headerNames;
    private WsdlOperation.SOAPParameterStyle _parameterStyle;
    private WsdlOpParameter _returnParam;
    private boolean _outOnly = false;

    protected WsdlOpParameterList(Operation op, Binding binding, WsdlTypes wsdlTypes) {
        this._wsdlTypes = wsdlTypes;
        this._returnParam = null;
        this._operation = op;
        this._parameterStyle = WsdlOperation.SOAPParameterStyle.BARE;
        this._headerNames = WsdlUtils.getSOAPHeaders(binding, op.getName());
    }

    protected WsdlOpReturnType getReturnType() {
        return this._returnParam;
    }

    protected WsdlOperation.SOAPParameterStyle getParameterStyle() {
        return this._parameterStyle;
    }

    public Operation getOperation() {
        return this._operation;
    }

    protected boolean add(Part p, boolean requestPart) throws KettleStepException {
        List<WsdlOpParameter> params = this.getParameter(p, requestPart);
        for (WsdlOpParameter op : params) {
            if (this._headerNames.contains(op.getName().getLocalPart())) {
                op.setHeader();
            }
            if (requestPart) {
                op.setMode(op.getMode());
                this.add(op);
                continue;
            }
            this.addOutputParameter(op);
        }
        return true;
    }

    private List<WsdlOpParameter> getParameter(Part part, boolean requesPart) throws KettleStepException {
        ArrayList<WsdlOpParameter> params = new ArrayList<WsdlOpParameter>();
        if (part.getElementName() != null) {
            if (WsdlUtils.isWrappedParameterStyle(this._operation.getName(), !requesPart, part.getName())) {
                this._parameterStyle = WsdlOperation.SOAPParameterStyle.WRAPPED;
            }
            params.addAll(this.resolvePartElement(part));
        } else {
            params.add(new WsdlOpParameter(part.getName(), part.getTypeName(), this._wsdlTypes.findNamedType(part.getTypeName()), this._wsdlTypes));
        }
        return params;
    }

    private void addOutputParameter(WsdlOpParameter responseParam) {
        List parameterOrder = this._operation.getParameterOrdering();
        if (parameterOrder != null) {
            if (!parameterOrder.contains(responseParam.getName().getLocalPart())) {
                this._returnParam = responseParam;
            } else {
                this.add(responseParam);
            }
        } else if (this._returnParam == null && !this._outOnly) {
            this._returnParam = responseParam;
        } else if (this._returnParam != null) {
            this.add(this._returnParam);
            this._returnParam = null;
            this._outOnly = true;
            this.add(responseParam);
        } else {
            this.add(responseParam);
        }
    }

    private List<WsdlOpParameter> resolvePartElement(Part p) throws KettleStepException {
        ArrayList<WsdlOpParameter> resolvedParams = new ArrayList<WsdlOpParameter>();
        Element schemaElement = this._wsdlTypes.findNamedElement(p.getElementName());
        if (schemaElement.hasAttribute("type")) {
            resolvedParams.add(new WsdlOpParameter(p.getName(), schemaElement, this._wsdlTypes));
        } else {
            Element complex = DomUtils.getChildElementByName(schemaElement, "complexType");
            Element sequence = DomUtils.getChildElementByName(complex, "sequence");
            if (sequence == null) {
                return resolvedParams;
            }
            List<Element> seqElements = DomUtils.getChildElementsByName(sequence, "element");
            for (Element e : seqElements) {
                WsdlOpParameter op = new WsdlOpParameter(e, this._wsdlTypes);
                if (op.isArray() && this._parameterStyle == WsdlOperation.SOAPParameterStyle.BARE) {
                    op.setName(schemaElement.getAttribute("name"), this._wsdlTypes);
                }
                resolvedParams.add(op);
            }
        }
        return resolvedParams;
    }

    public HashSet<String> getHeaderNames() {
        return this._headerNames;
    }
}

