/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.univariatestats;

import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStatsMetaFunction;

public class FieldIndex {
    public int m_columnIndex;
    public double m_count;
    public double m_mean;
    public double m_stdDev;
    public double m_max;
    public double m_min;
    public double m_median;
    public double m_arbitraryPercentile;
    public double m_sum;
    public double m_sumSq;

    public void calculateDerived() {
        this.m_mean = Double.NaN;
        this.m_stdDev = Double.NaN;
        if (this.m_count > 0.0) {
            this.m_mean = this.m_sum / this.m_count;
            this.m_stdDev = Double.POSITIVE_INFINITY;
            if (this.m_count > 1.0) {
                this.m_stdDev = this.m_sumSq - this.m_sum * this.m_sum / this.m_count;
                this.m_stdDev /= this.m_count - 1.0;
                if (this.m_stdDev < 0.0) {
                    this.m_stdDev = 0.0;
                }
                this.m_stdDev = Math.sqrt(this.m_stdDev);
            }
        }
    }

    private double percentile(double p, double[] vals, boolean interpolate) {
        double n = this.m_count;
        if (interpolate) {
            double i = p * (n + 1.0);
            if (i <= 1.0) {
                return this.m_min;
            }
            if (i >= n) {
                return this.m_max;
            }
            double low_obs = Math.floor(i);
            double high_obs = low_obs + 1.0;
            double r1 = high_obs - i;
            double r2 = 1.0 - r1;
            double x1 = vals[(int)low_obs - 1];
            double x2 = vals[(int)high_obs - 1];
            return r1 * x1 + r2 * x2;
        }
        double i = p * n;
        double res = 0.0;
        if (i == 0.0) {
            return this.m_min;
        }
        if (i == n) {
            return this.m_max;
        }
        if (i - Math.floor(i) > 0.0) {
            i = Math.floor(i);
            res = vals[(int)i];
        } else {
            res = (vals[(int)(i - 1.0)] + vals[(int)i]) / 2.0;
        }
        return res;
    }

    public Object[] generateOutputValues(UnivariateStatsMetaFunction usmf, ArrayList<Number> cache) {
        Object[] result;
        this.calculateDerived();
        if (cache != null) {
            result = new double[(int)this.m_count];
            for (int i = 0; i < cache.size(); ++i) {
                result[i] = cache.get(i).doubleValue();
            }
            Arrays.sort((double[])result);
            if (usmf.getCalcMedian()) {
                this.m_median = this.percentile(0.5, (double[])result, usmf.getInterpolatePercentile());
            }
            if (usmf.getCalcPercentile() >= 0.0) {
                this.m_arbitraryPercentile = this.percentile(usmf.getCalcPercentile(), (double[])result, usmf.getInterpolatePercentile());
            }
        }
        result = new Object[usmf.numberOfMetricsRequested()];
        int index = 0;
        if (usmf.getCalcN()) {
            result[index++] = new Double(this.m_count);
        }
        if (usmf.getCalcMean()) {
            result[index++] = new Double(this.m_mean);
        }
        if (usmf.getCalcStdDev()) {
            result[index++] = new Double(this.m_stdDev);
        }
        if (usmf.getCalcMin()) {
            result[index++] = new Double(this.m_min);
        }
        if (usmf.getCalcMax()) {
            result[index++] = new Double(this.m_max);
        }
        if (usmf.getCalcMedian()) {
            result[index++] = new Double(this.m_median);
        }
        if (usmf.getCalcPercentile() >= 0.0) {
            result[index++] = new Double(this.m_arbitraryPercentile);
        }
        return result;
    }
}

