/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileoutput;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepInjectionUtil;
import org.pentaho.di.trans.step.StepMetaInjectionEntryInterface;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;

public class TextFileOutputMetaInjection
implements StepMetaInjectionInterface {
    private TextFileOutputMeta meta;

    public TextFileOutputMetaInjection(TextFileOutputMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        Entry[] fieldsEntries;
        Entry[] topEntries;
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        for (Entry topEntry : topEntries = new Entry[]{Entry.FILENAME, Entry.RUN_AS_COMMAND, Entry.PASS_TO_SERVLET, Entry.CREATE_PARENT_FOLDER, Entry.FILENAME_IN_FIELD, Entry.FILENAME_FIELD, Entry.EXTENSION, Entry.INC_STEPNR_IN_FILENAME, Entry.INC_PARTNR_IN_FILENAME, Entry.INC_DATE_IN_FILENAME, Entry.INC_TIME_IN_FILENAME, Entry.SPECIFY_DATE_FORMAT, Entry.DATE_FORMAT, Entry.ADD_TO_RESULT, Entry.APPEND, Entry.SEPARATOR, Entry.ENCLOSURE, Entry.FORCE_ENCLOSURE, Entry.DISABLE_ENCLOSURE_FIX, Entry.HEADER, Entry.FOOTER, Entry.FORMAT, Entry.COMPRESSION, Entry.ENCODING, Entry.RIGHT_PAD_FIELDS, Entry.FAST_DATA_DUMP, Entry.SPLIT_EVERY, Entry.ADD_ENDING_LINE}) {
            all.add(new StepInjectionMetaEntry(topEntry.name(), topEntry.getValueType(), topEntry.getDescription()));
        }
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry(Entry.OUTPUT_FIELDS.name(), 0, Entry.OUTPUT_FIELDS.description);
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry(Entry.OUTPUT_FIELD.name(), 0, Entry.OUTPUT_FIELD.description);
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : fieldsEntries = new Entry[]{Entry.OUTPUT_FIELDNAME, Entry.OUTPUT_TYPE, Entry.OUTPUT_LENGTH, Entry.OUTPUT_FORMAT, Entry.OUTPUT_PRECISION, Entry.OUTPUT_CURRENCY, Entry.OUTPUT_DECIMAL, Entry.OUTPUT_GROUP, Entry.OUTPUT_TRIM, Entry.OUTPUT_NULL}) {
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<String> outputFields = new ArrayList<String>();
        ArrayList<String> outputTypes = new ArrayList<String>();
        ArrayList<String> outputLengths = new ArrayList<String>();
        ArrayList<String> outputFormats = new ArrayList<String>();
        ArrayList<String> outputPrecisions = new ArrayList<String>();
        ArrayList<String> outputCurrencies = new ArrayList<String>();
        ArrayList<String> outputDecimals = new ArrayList<String>();
        ArrayList<String> outputGroups = new ArrayList<String>();
        ArrayList<String> outputTrims = new ArrayList<String>();
        ArrayList<String> outputNulls = new ArrayList<String>();
        block43: for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            String lookValue = (String)lookFields.getValue();
            switch (fieldsEntry) {
                case OUTPUT_FIELDS: {
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        Entry fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry != Entry.OUTPUT_FIELD) continue;
                        String outputFieldname = null;
                        String outputType = null;
                        String outputLength = null;
                        String outputFormat = null;
                        String outputPrecision = null;
                        String outputCurrency = null;
                        String outputDecimal = null;
                        String outputGroup = null;
                        String outputTrim = null;
                        String outputNull = null;
                        List<StepInjectionMetaEntry> entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            Entry metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            String value = (String)entry.getValue();
                            switch (metaEntry) {
                                case OUTPUT_FIELDNAME: {
                                    outputFieldname = value;
                                    break;
                                }
                                case OUTPUT_TYPE: {
                                    outputType = value;
                                    break;
                                }
                                case OUTPUT_LENGTH: {
                                    outputLength = value;
                                    break;
                                }
                                case OUTPUT_FORMAT: {
                                    outputFormat = value;
                                    break;
                                }
                                case OUTPUT_PRECISION: {
                                    outputPrecision = value;
                                    break;
                                }
                                case OUTPUT_CURRENCY: {
                                    outputCurrency = value;
                                    break;
                                }
                                case OUTPUT_DECIMAL: {
                                    outputDecimal = value;
                                    break;
                                }
                                case OUTPUT_GROUP: {
                                    outputGroup = value;
                                    break;
                                }
                                case OUTPUT_TRIM: {
                                    outputTrim = value;
                                    break;
                                }
                                case OUTPUT_NULL: {
                                    outputNull = value;
                                    break;
                                }
                            }
                        }
                        outputFields.add(outputFieldname);
                        outputTypes.add(outputType);
                        outputLengths.add(outputLength);
                        outputFormats.add(outputFormat);
                        outputPrecisions.add(outputPrecision);
                        outputCurrencies.add(outputCurrency);
                        outputDecimals.add(outputDecimal);
                        outputGroups.add(outputGroup);
                        outputTrims.add(outputTrim);
                        outputNulls.add(outputNull);
                    }
                    continue block43;
                }
                case FILENAME: {
                    this.meta.setFileName(lookValue);
                    break;
                }
                case RUN_AS_COMMAND: {
                    this.meta.setFileAsCommand("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case PASS_TO_SERVLET: {
                    this.meta.setServletOutput("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case CREATE_PARENT_FOLDER: {
                    this.meta.setCreateParentFolder("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case FILENAME_IN_FIELD: {
                    this.meta.setFileNameInField("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case FILENAME_FIELD: {
                    this.meta.setFileNameField(lookValue);
                    break;
                }
                case EXTENSION: {
                    this.meta.setExtension(lookValue);
                    break;
                }
                case INC_STEPNR_IN_FILENAME: {
                    this.meta.setStepNrInFilename("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case INC_PARTNR_IN_FILENAME: {
                    this.meta.setPartNrInFilename("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case INC_DATE_IN_FILENAME: {
                    this.meta.setDateInFilename("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case INC_TIME_IN_FILENAME: {
                    this.meta.setTimeInFilename("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case SPECIFY_DATE_FORMAT: {
                    this.meta.setSpecifyingFormat("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case DATE_FORMAT: {
                    this.meta.setDateTimeFormat(lookValue);
                    break;
                }
                case ADD_TO_RESULT: {
                    this.meta.setAddToResultFiles("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case APPEND: {
                    this.meta.setFileAppended("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case SEPARATOR: {
                    this.meta.setSeparator(lookValue);
                    break;
                }
                case ENCLOSURE: {
                    this.meta.setEnclosure(lookValue);
                    break;
                }
                case FORCE_ENCLOSURE: {
                    this.meta.setEnclosureForced("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case DISABLE_ENCLOSURE_FIX: {
                    this.meta.setEnclosureFixDisabled("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case HEADER: {
                    this.meta.setHeaderEnabled("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case FOOTER: {
                    this.meta.setFooterEnabled("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case FORMAT: {
                    this.meta.setFileFormat(lookValue);
                    break;
                }
                case COMPRESSION: {
                    this.meta.setFileCompression(lookValue);
                    break;
                }
                case ENCODING: {
                    this.meta.setEncoding(lookValue);
                    break;
                }
                case RIGHT_PAD_FIELDS: {
                    this.meta.setPadded("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case FAST_DATA_DUMP: {
                    this.meta.setFastDump("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case SPLIT_EVERY: {
                    this.meta.setSplitEvery(Const.toInt((String)lookValue, (int)0));
                    break;
                }
                case ADD_ENDING_LINE: {
                    this.meta.setEndedLine(lookValue);
                    break;
                }
            }
        }
        if (outputFields.size() > 0) {
            TextFileField[] tff = new TextFileField[outputFields.size()];
            Iterator iOutputFields = outputFields.iterator();
            Iterator iOutputTypes = outputTypes.iterator();
            Iterator iOutputLengths = outputLengths.iterator();
            Iterator iOutputFormats = outputFormats.iterator();
            Iterator iOutputPrecisions = outputPrecisions.iterator();
            Iterator iOutputCurrencies = outputCurrencies.iterator();
            Iterator iOutputDecimals = outputDecimals.iterator();
            Iterator iOutputGroups = outputGroups.iterator();
            Iterator iOutputTrims = outputTrims.iterator();
            Iterator iOutputNulls = outputNulls.iterator();
            int i = 0;
            while (iOutputFields.hasNext()) {
                TextFileField field = new TextFileField();
                field.setName((String)iOutputFields.next());
                field.setType(ValueMeta.getType((String)((String)iOutputTypes.next())));
                field.setFormat((String)iOutputFormats.next());
                field.setLength(Const.toInt((String)((String)iOutputLengths.next()), (int)-1));
                field.setPrecision(Const.toInt((String)((String)iOutputPrecisions.next()), (int)-1));
                field.setCurrencySymbol((String)iOutputCurrencies.next());
                field.setDecimalSymbol((String)iOutputDecimals.next());
                field.setGroupingSymbol((String)iOutputGroups.next());
                field.setNullString((String)iOutputNulls.next());
                field.setTrimType(ValueMeta.getTrimTypeByDesc((String)((String)iOutputTrims.next())));
                tff[i] = field;
                ++i;
            }
            this.meta.setOutputFields(tff);
        }
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() {
        ArrayList<StepInjectionMetaEntry> list = new ArrayList<StepInjectionMetaEntry>();
        list.add(StepInjectionUtil.getEntry(Entry.FILENAME, this.meta.getFileName()));
        list.add(StepInjectionUtil.getEntry(Entry.RUN_AS_COMMAND, this.meta.isFileAsCommand()));
        list.add(StepInjectionUtil.getEntry(Entry.PASS_TO_SERVLET, this.meta.isServletOutput()));
        list.add(StepInjectionUtil.getEntry(Entry.CREATE_PARENT_FOLDER, this.meta.isCreateParentFolder()));
        list.add(StepInjectionUtil.getEntry(Entry.FILENAME_IN_FIELD, this.meta.isFileNameInField()));
        list.add(StepInjectionUtil.getEntry(Entry.FILENAME_FIELD, this.meta.getFileNameField()));
        list.add(StepInjectionUtil.getEntry(Entry.EXTENSION, this.meta.getExtension()));
        list.add(StepInjectionUtil.getEntry(Entry.INC_STEPNR_IN_FILENAME, this.meta.isStepNrInFilename()));
        list.add(StepInjectionUtil.getEntry(Entry.INC_PARTNR_IN_FILENAME, this.meta.isPartNrInFilename()));
        list.add(StepInjectionUtil.getEntry(Entry.INC_DATE_IN_FILENAME, this.meta.isDateInFilename()));
        list.add(StepInjectionUtil.getEntry(Entry.INC_TIME_IN_FILENAME, this.meta.isTimeInFilename()));
        list.add(StepInjectionUtil.getEntry(Entry.SPECIFY_DATE_FORMAT, this.meta.isSpecifyingFormat()));
        list.add(StepInjectionUtil.getEntry(Entry.DATE_FORMAT, this.meta.getDateTimeFormat()));
        list.add(StepInjectionUtil.getEntry(Entry.ADD_TO_RESULT, this.meta.isAddToResultFiles()));
        list.add(StepInjectionUtil.getEntry(Entry.APPEND, this.meta.isFileAppended()));
        list.add(StepInjectionUtil.getEntry(Entry.SEPARATOR, this.meta.getSeparator()));
        list.add(StepInjectionUtil.getEntry(Entry.ENCLOSURE, this.meta.getEnclosure()));
        list.add(StepInjectionUtil.getEntry(Entry.FORCE_ENCLOSURE, this.meta.isEnclosureForced()));
        list.add(StepInjectionUtil.getEntry(Entry.DISABLE_ENCLOSURE_FIX, this.meta.isEnclosureFixDisabled()));
        list.add(StepInjectionUtil.getEntry(Entry.HEADER, this.meta.isHeaderEnabled()));
        list.add(StepInjectionUtil.getEntry(Entry.FOOTER, this.meta.isFooterEnabled()));
        list.add(StepInjectionUtil.getEntry(Entry.FORMAT, this.meta.getFileFormat()));
        list.add(StepInjectionUtil.getEntry(Entry.COMPRESSION, this.meta.getFileCompression()));
        list.add(StepInjectionUtil.getEntry(Entry.ENCODING, this.meta.getEncoding()));
        list.add(StepInjectionUtil.getEntry(Entry.RIGHT_PAD_FIELDS, this.meta.isPadded()));
        list.add(StepInjectionUtil.getEntry(Entry.FAST_DATA_DUMP, this.meta.isFastDump()));
        list.add(StepInjectionUtil.getEntry(Entry.SPLIT_EVERY, this.meta.getSplitEvery()));
        list.add(StepInjectionUtil.getEntry(Entry.ADD_ENDING_LINE, this.meta.getEndedLine()));
        StepInjectionMetaEntry fieldsEntry = StepInjectionUtil.getEntry(Entry.OUTPUT_FIELDS);
        list.add(fieldsEntry);
        for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
            StepInjectionMetaEntry fieldEntry = StepInjectionUtil.getEntry(Entry.OUTPUT_FIELD);
            List<StepInjectionMetaEntry> details = fieldEntry.getDetails();
            details.add(StepInjectionUtil.getEntry(Entry.OUTPUT_FIELDNAME, this.meta.getOutputFields()[i].getName()));
            details.add(StepInjectionUtil.getEntry(Entry.OUTPUT_TYPE, this.meta.getOutputFields()[i].getTypeDesc()));
            details.add(StepInjectionUtil.getEntry(Entry.OUTPUT_FORMAT, this.meta.getOutputFields()[i].getFormat()));
            details.add(StepInjectionUtil.getEntry(Entry.OUTPUT_LENGTH, this.meta.getOutputFields()[i].getLength()));
            details.add(StepInjectionUtil.getEntry(Entry.OUTPUT_PRECISION, this.meta.getOutputFields()[i].getPrecision()));
            details.add(StepInjectionUtil.getEntry(Entry.OUTPUT_CURRENCY, this.meta.getOutputFields()[i].getCurrencySymbol()));
            details.add(StepInjectionUtil.getEntry(Entry.OUTPUT_DECIMAL, this.meta.getOutputFields()[i].getDecimalSymbol()));
            details.add(StepInjectionUtil.getEntry(Entry.OUTPUT_GROUP, this.meta.getOutputFields()[i].getGroupingSymbol()));
            details.add(StepInjectionUtil.getEntry(Entry.OUTPUT_TRIM, this.meta.getOutputFields()[i].getTrimTypeDesc()));
            details.add(StepInjectionUtil.getEntry(Entry.OUTPUT_NULL, this.meta.getOutputFields()[i].getNullString()));
            fieldsEntry.getDetails().add(fieldEntry);
        }
        return list;
    }

    public TextFileOutputMeta getMeta() {
        return this.meta;
    }

    public static enum Entry implements StepMetaInjectionEntryInterface
    {
        FILENAME(2, "The filename"),
        RUN_AS_COMMAND(2, "Run this as command instead? (Y/N)"),
        PASS_TO_SERVLET(2, "Pass output to servlet? (Y/N)"),
        CREATE_PARENT_FOLDER(2, "Create parent folder? (Y/N)"),
        FILENAME_IN_FIELD(2, "Accept filename from field? (Y/N)"),
        FILENAME_FIELD(2, "The filename field"),
        EXTENSION(2, "The file extension"),
        INC_STEPNR_IN_FILENAME(2, "Include stepnr in filename? (Y/N)"),
        INC_PARTNR_IN_FILENAME(2, "Include partition nr in filename? (Y/N)"),
        INC_DATE_IN_FILENAME(2, "Include date in filename? (Y/N)"),
        INC_TIME_IN_FILENAME(2, "Include time in filename? (Y/N)"),
        SPECIFY_DATE_FORMAT(2, "Specify date time format for filename? (Y/N)"),
        DATE_FORMAT(2, "Date time format for filename"),
        ADD_TO_RESULT(2, "Add filenames to result? (Y/N)"),
        APPEND(2, "Append if file exists? (Y/N)"),
        SEPARATOR(2, "The separator"),
        ENCLOSURE(2, "The enclosure"),
        FORCE_ENCLOSURE(2, "Force the enclosure around fields? (Y/N)"),
        DISABLE_ENCLOSURE_FIX(2, "Disable the enclosure fix? (Y/N)"),
        HEADER(2, "Include header row? (Y/N)"),
        FOOTER(2, "Include footer row? (Y/N)"),
        FORMAT(2, "The file format line termination? (DOS, UNIX, CR, None)"),
        COMPRESSION(2, "The compression? (GZip, Hadoop-Snappy, Snappy, Zip, None)"),
        ENCODING(2, "Encoding type (for allowed values see: http://wiki.pentaho.com/display/EAI/Text+File+Output)"),
        RIGHT_PAD_FIELDS(2, "Right pad fields? (Y/N)"),
        FAST_DATA_DUMP(2, "Fast data dump? (Y/N)"),
        SPLIT_EVERY(2, "Split every ... rows"),
        ADD_ENDING_LINE(2, "Add ending line after last row"),
        OUTPUT_FIELDS(0, "The fields to output"),
        OUTPUT_FIELD(0, "One field to output"),
        OUTPUT_FIELDNAME(2, "Field to output"),
        OUTPUT_TYPE(2, "Field type (for allowed values see: http://wiki.pentaho.com/display/EAI/Text+File+Output)"),
        OUTPUT_FORMAT(2, "Field format"),
        OUTPUT_LENGTH(2, "Field length"),
        OUTPUT_PRECISION(2, "Field precision"),
        OUTPUT_CURRENCY(2, "Field currency symbol"),
        OUTPUT_DECIMAL(2, "Field decimal symbol"),
        OUTPUT_GROUP(2, "Field grouping symbol"),
        OUTPUT_TRIM(2, "Field trim type (none,left,both,right)"),
        OUTPUT_NULL(2, "Value to replace nulls with");

        private int valueType;
        private String description;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        @Override
        public int getValueType() {
            return this.valueType;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }
    }
}

