/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.symmetriccrypto.symmetricalgorithm;

import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.symmetriccrypto.symmetricalgorithm.CryptoException;
import org.pentaho.di.trans.steps.symmetriccrypto.symmetricalgorithm.SymmetricCryptoInterface;

public class SymmetricCryptoMeta {
    private static Class<?> PKG = SymmetricCryptoMeta.class;
    private SymmetricCryptoInterface cryptographyInterface;
    private static SymmetricCryptoInterface[] allSymmetricCryptoInterface;
    public static final String[] TYPE_ALGORYTHM_CODE;
    public static final int TYPE_ALGORYTHM_NONE = 0;
    public static final int TYPE_ALGORYTHM_DES = 1;
    public static final int TYPE_ALGORYTHM_TRIPLE_DES = 2;
    public static final int TYPE_ALGORYTHM_AES = 3;
    public static final String ALGORYTHM_DES = "DES";
    public static final String ALGORYTHM_TRIPLE_DES = "DESede";
    public static final String ALGORYTHM_AES = "AES";

    public SymmetricCryptoMeta(String algorythm) throws CryptoException {
        this.cryptographyInterface = SymmetricCryptoMeta.getSymmetricCryptoInterface(algorythm);
    }

    public static final SymmetricCryptoInterface getSymmetricCryptoInterface(String cryptoname) throws CryptoException {
        return SymmetricCryptoMeta.findSymmetricCryptoInterface(cryptoname);
    }

    private static final synchronized SymmetricCryptoInterface findSymmetricCryptoInterface(String cryptograhname) throws CryptoException {
        SymmetricCryptoInterface[] di = SymmetricCryptoMeta.getSymmetricCryptoInterfaces();
        for (int i = 0; i < di.length; ++i) {
            if (!di[i].getAlgorithm().equalsIgnoreCase(cryptograhname)) continue;
            return di[i];
        }
        throw new CryptoException(BaseMessages.getString(PKG, (String)"SymmetricCryptoMeta.CouldNotFoundAlgorithm", (String[])new String[]{cryptograhname}));
    }

    public static final synchronized SymmetricCryptoInterface[] getSymmetricCryptoInterfaces() {
        if (allSymmetricCryptoInterface != null) {
            return allSymmetricCryptoInterface;
        }
        Class<?>[] ic = SymmetricCryptoInterface.implementingClasses;
        allSymmetricCryptoInterface = new SymmetricCryptoInterface[ic.length];
        for (int i = 0; i < ic.length; ++i) {
            try {
                Class.forName(ic[i].getName());
                SymmetricCryptoMeta.allSymmetricCryptoInterface[i] = (SymmetricCryptoInterface)ic[i].newInstance();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating class for : " + ic[i].getName(), e);
            }
        }
        return allSymmetricCryptoInterface;
    }

    public String getAlgorithm() {
        return this.cryptographyInterface.getAlgorithm();
    }

    public int getAlgorithmType() {
        return this.cryptographyInterface.getAlgorithmType();
    }

    public String getDefaultScheme() {
        return this.cryptographyInterface.getDefaultScheme();
    }

    public static int getAlgorithmTypeFromCode(String code) {
        if (!Const.isEmpty((String)code)) {
            int nr = TYPE_ALGORYTHM_CODE.length;
            for (int i = 0; i < nr; ++i) {
                if (!TYPE_ALGORYTHM_CODE[i].equals(code)) continue;
                return i + 1;
            }
        }
        return 0;
    }

    static {
        TYPE_ALGORYTHM_CODE = new String[]{ALGORYTHM_DES, ALGORYTHM_TRIPLE_DES, ALGORYTHM_AES};
    }
}

