/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.simplemapping;

import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.steps.mapping.MappingIODefinition;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.simplemapping.PutRowInterface;

public class RowOutputDataMapper
extends RowAdapter {
    private MappingIODefinition inputDefinition;
    private MappingIODefinition outputDefinition;
    private boolean first = true;
    private RowMetaInterface renamedRowMeta;
    private PutRowInterface putRowInterface;

    public RowOutputDataMapper(MappingIODefinition inputDefinition, MappingIODefinition outputDefinition, PutRowInterface putRowInterface) {
        this.inputDefinition = inputDefinition;
        this.outputDefinition = outputDefinition;
        this.putRowInterface = putRowInterface;
    }

    @Override
    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        if (this.first) {
            ValueMetaInterface valueMeta;
            this.first = false;
            this.renamedRowMeta = rowMeta.clone();
            if (this.inputDefinition.isRenamingOnOutput()) {
                for (MappingValueRename valueRename : this.inputDefinition.getValueRenames()) {
                    valueMeta = this.renamedRowMeta.searchValueMeta(valueRename.getTargetValueName());
                    if (valueMeta == null) continue;
                    valueMeta.setName(valueRename.getSourceValueName());
                }
            }
            for (MappingValueRename valueRename : this.outputDefinition.getValueRenames()) {
                valueMeta = this.renamedRowMeta.searchValueMeta(valueRename.getSourceValueName());
                if (valueMeta == null) continue;
                valueMeta.setName(valueRename.getTargetValueName());
            }
        }
        this.putRowInterface.putRow(this.renamedRowMeta, row);
    }
}

