/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.javafilter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.janino.ExpressionEvaluator;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.javafilter.JavaFilterData;
import org.pentaho.di.trans.steps.javafilter.JavaFilterMeta;

public class JavaFilter
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = JavaFilterMeta.class;
    private JavaFilterMeta meta;
    private JavaFilterData data;

    public JavaFilter(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (JavaFilterMeta)smi;
        this.data = (JavaFilterData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            if (this.data.chosesTargetSteps) {
                List<StreamInterface> targetStreams = this.meta.getStepIOMeta().getTargetStreams();
                this.data.trueRowSet = this.findOutputRowSet(this.getStepname(), this.getCopy(), targetStreams.get(0).getStepname(), 0);
                if (this.data.trueRowSet == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JavaFilter.Log.TargetStepInvalid", (String[])new String[]{targetStreams.get(0).getStepname()}));
                }
                this.data.falseRowSet = this.findOutputRowSet(this.getStepname(), this.getCopy(), targetStreams.get(1).getStepname(), 0);
                if (this.data.falseRowSet == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JavaFilter.Log.TargetStepInvalid", (String[])new String[]{targetStreams.get(1).getStepname()}));
                }
            }
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel("Read row #" + this.getLinesRead() + " : " + this.getInputRowMeta().getString(r));
        }
        boolean keep = this.calcFields(this.getInputRowMeta(), r);
        if (!this.data.chosesTargetSteps) {
            if (keep) {
                this.putRow(this.data.outputRowMeta, r);
            }
        } else if (keep) {
            if (this.log.isRowLevel()) {
                this.logRowlevel("Sending row to true  :" + this.data.trueStepname + " : " + this.getInputRowMeta().getString(r));
            }
            this.putRowTo(this.data.outputRowMeta, r, this.data.trueRowSet);
        } else {
            if (this.log.isRowLevel()) {
                this.logRowlevel("Sending row to false :" + this.data.falseStepname + " : " + this.getInputRowMeta().getString(r));
            }
            this.putRowTo(this.data.outputRowMeta, r, this.data.falseRowSet);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"JavaFilter.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    private boolean calcFields(RowMetaInterface rowMeta, Object[] r) throws KettleValueException {
        try {
            if (this.data.expressionEvaluator == null) {
                String realCondition = this.environmentSubstitute(this.meta.getCondition());
                this.data.argumentIndexes = new ArrayList<Integer>();
                ArrayList<String> parameterNames = new ArrayList<String>();
                ArrayList<Class<String>> parameterTypes = new ArrayList<Class<String>>();
                for (int i = 0; i < this.data.outputRowMeta.size(); ++i) {
                    Class parameterType;
                    ValueMetaInterface valueMeta = this.data.outputRowMeta.getValueMeta(i);
                    if (!realCondition.contains(valueMeta.getName())) continue;
                    this.data.argumentIndexes.add(i);
                    switch (valueMeta.getType()) {
                        case 2: {
                            parameterType = String.class;
                            break;
                        }
                        case 1: {
                            parameterType = Double.class;
                            break;
                        }
                        case 5: {
                            parameterType = Long.class;
                            break;
                        }
                        case 3: {
                            parameterType = Date.class;
                            break;
                        }
                        case 6: {
                            parameterType = BigDecimal.class;
                            break;
                        }
                        case 4: {
                            parameterType = Boolean.class;
                            break;
                        }
                        case 8: {
                            parameterType = byte[].class;
                            break;
                        }
                        default: {
                            parameterType = String.class;
                        }
                    }
                    parameterTypes.add(parameterType);
                    parameterNames.add(valueMeta.getName());
                }
                this.data.expressionEvaluator = new ExpressionEvaluator();
                this.data.expressionEvaluator.setParameters(parameterNames.toArray(new String[parameterNames.size()]), parameterTypes.toArray(new Class[parameterTypes.size()]));
                this.data.expressionEvaluator.setReturnType(Object.class);
                this.data.expressionEvaluator.setThrownExceptions(new Class[]{Exception.class});
                this.data.expressionEvaluator.cook(realCondition);
                this.data.argumentData = new Object[this.data.argumentIndexes.size()];
            }
            for (int x = 0; x < this.data.argumentIndexes.size(); ++x) {
                int index = this.data.argumentIndexes.get(x);
                ValueMetaInterface outputValueMeta = this.data.outputRowMeta.getValueMeta(index);
                this.data.argumentData[x] = outputValueMeta.convertToNormalStorageType(r[index]);
            }
            Object formulaResult = this.data.expressionEvaluator.evaluate(this.data.argumentData);
            if (formulaResult instanceof Boolean) {
                return (Boolean)formulaResult;
            }
            throw new KettleException("The result of the filter expression must be a boolean and we got back : " + formulaResult.getClass().getName());
        }
        catch (Exception e) {
            throw new KettleValueException((Throwable)e);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (JavaFilterMeta)smi;
        this.data = (JavaFilterData)sdi;
        if (super.init(smi, sdi)) {
            List<StreamInterface> targetStreams = this.meta.getStepIOMeta().getTargetStreams();
            this.data.trueStepname = targetStreams.get(0).getStepname();
            this.data.falseStepname = targetStreams.get(1).getStepname();
            if (targetStreams.get(0).getStepMeta() != null ^ targetStreams.get(1).getStepMeta() != null) {
                this.logError(BaseMessages.getString(PKG, (String)"JavaFilter.Log.BothTrueAndFalseNeeded", (String[])new String[0]));
            } else {
                this.data.chosesTargetSteps = targetStreams.get(0).getStepMeta() != null && targetStreams.get(1).getStepMeta() != null;
                return true;
            }
        }
        return false;
    }
}

