/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput.jxl;

import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.LabelCell;
import jxl.NumberCell;
import org.pentaho.di.core.spreadsheet.KCell;
import org.pentaho.di.core.spreadsheet.KCellType;

public class XLSCell
implements KCell {
    private Cell cell;

    public XLSCell(Cell cell) {
        this.cell = cell;
    }

    public KCellType getType() {
        CellType type = this.cell.getType();
        if (type.equals(CellType.BOOLEAN)) {
            return KCellType.BOOLEAN;
        }
        if (type.equals(CellType.BOOLEAN_FORMULA)) {
            return KCellType.BOOLEAN_FORMULA;
        }
        if (type.equals(CellType.DATE)) {
            return KCellType.DATE;
        }
        if (type.equals(CellType.DATE_FORMULA)) {
            return KCellType.DATE_FORMULA;
        }
        if (type.equals(CellType.LABEL)) {
            return KCellType.LABEL;
        }
        if (type.equals(CellType.STRING_FORMULA)) {
            return KCellType.STRING_FORMULA;
        }
        if (type.equals(CellType.EMPTY)) {
            return KCellType.EMPTY;
        }
        if (type.equals(CellType.NUMBER)) {
            return KCellType.NUMBER;
        }
        if (type.equals(CellType.NUMBER_FORMULA)) {
            return KCellType.NUMBER_FORMULA;
        }
        return null;
    }

    public Object getValue() {
        switch (this.getType()) {
            case BOOLEAN_FORMULA: 
            case BOOLEAN: {
                return ((BooleanCell)this.cell).getValue();
            }
            case DATE_FORMULA: 
            case DATE: {
                return ((DateCell)this.cell).getDate();
            }
            case NUMBER_FORMULA: 
            case NUMBER: {
                return ((NumberCell)this.cell).getValue();
            }
            case STRING_FORMULA: 
            case LABEL: {
                return ((LabelCell)this.cell).getString();
            }
        }
        return null;
    }

    public String getContents() {
        return this.cell.getContents();
    }

    public int getRow() {
        return this.cell.getRow();
    }
}

