/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databasejoin;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.databasejoin.DatabaseJoin;
import org.pentaho.di.trans.steps.databasejoin.DatabaseJoinData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class DatabaseJoinMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = DatabaseJoinMeta.class;
    private DatabaseMeta databaseMeta;
    private String sql;
    private int rowLimit;
    private boolean outerJoin;
    private String[] parameterField;
    private int[] parameterType;
    private boolean replacevars;

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public boolean isOuterJoin() {
        return this.outerJoin;
    }

    public void setOuterJoin(boolean outerJoin) {
        this.outerJoin = outerJoin;
    }

    public boolean isVariableReplace() {
        return this.replacevars;
    }

    public void setVariableReplace(boolean replacevars) {
        this.replacevars = replacevars;
    }

    public String[] getParameterField() {
        return this.parameterField;
    }

    public void setParameterField(String[] parameterField) {
        this.parameterField = parameterField;
    }

    public int[] getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(int[] parameterType) {
        this.parameterType = parameterType;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.parameterField = null;
        this.parameterType = null;
        this.outerJoin = false;
        this.replacevars = false;
        this.readData(stepnode, databases);
    }

    public void allocate(int nrparam) {
        this.parameterField = new String[nrparam];
        this.parameterType = new int[nrparam];
    }

    @Override
    public Object clone() {
        DatabaseJoinMeta retval = (DatabaseJoinMeta)super.clone();
        int nrparam = this.parameterField.length;
        retval.allocate(nrparam);
        for (int i = 0; i < nrparam; ++i) {
            retval.parameterField[i] = this.parameterField[i];
            retval.parameterType[i] = this.parameterType[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List<DatabaseMeta> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            this.sql = XMLHandler.getTagValue((Node)stepnode, (String)"sql");
            this.outerJoin = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"outer_join"));
            this.replacevars = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"replace_vars"));
            this.rowLimit = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"rowlimit"), (int)0);
            Node param = XMLHandler.getSubNode((Node)stepnode, (String)"parameter");
            int nrparam = XMLHandler.countNodes((Node)param, (String)"field");
            this.allocate(nrparam);
            for (int i = 0; i < nrparam; ++i) {
                Node pnode = XMLHandler.getSubNodeByNr((Node)param, (String)"field", (int)i);
                this.parameterField[i] = XMLHandler.getTagValue((Node)pnode, (String)"name");
                String ptype = XMLHandler.getTagValue((Node)pnode, (String)"type");
                this.parameterType[i] = ValueMeta.getType((String)ptype);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.Exception.UnableToLoadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.databaseMeta = null;
        this.rowLimit = 0;
        this.sql = "";
        this.outerJoin = false;
        this.parameterField = null;
        this.parameterType = null;
        this.outerJoin = false;
        this.replacevars = false;
        int nrparam = 0;
        this.allocate(nrparam);
        for (int i = 0; i < nrparam; ++i) {
            this.parameterField[i] = "param" + i;
            this.parameterType[i] = 1;
        }
    }

    public RowMetaInterface getParameterRow(RowMetaInterface fields) {
        RowMeta param = new RowMeta();
        if (fields != null) {
            for (int i = 0; i < this.parameterField.length; ++i) {
                ValueMetaInterface v = fields.searchValueMeta(this.parameterField[i]);
                if (v == null) continue;
                param.addValueMeta(v);
            }
        }
        return param;
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (this.databaseMeta == null) {
            return;
        }
        Database db = new Database(loggingObject, this.databaseMeta);
        this.databases = new Database[]{db};
        RowMetaInterface param = this.getParameterRow(row);
        RowMetaInterface add = null;
        try {
            add = db.getQueryFields(space.environmentSubstitute(this.sql), true, param, new Object[param.size()]);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.Exception.UnableToDetermineQueryFields", (String[])new String[0]) + Const.CR + this.sql, (Throwable)dbe);
        }
        if (add != null) {
            for (int i = 0; i < add.size(); ++i) {
                ValueMetaInterface v = add.getValueMeta(i);
                v.setOrigin(name);
            }
            row.addRowMeta(add);
        } else {
            try {
                db.connect();
                add = db.getQueryFields(space.environmentSubstitute(this.sql), true, param, new Object[param.size()]);
                for (int i = 0; i < add.size(); ++i) {
                    ValueMetaInterface v = add.getValueMeta(i);
                    v.setOrigin(name);
                }
                row.addRowMeta(add);
                db.disconnect();
            }
            catch (KettleDatabaseException dbe) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.Exception.ErrorObtainingFields", (String[])new String[0]), (Throwable)dbe);
            }
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rowlimit", (int)this.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sql", (String)this.sql));
        retval.append("    ").append(XMLHandler.addTagValue((String)"outer_join", (boolean)this.outerJoin));
        retval.append("    ").append(XMLHandler.addTagValue((String)"replace_vars", (boolean)this.replacevars));
        retval.append("    <parameter>").append(Const.CR);
        for (int i = 0; i < this.parameterField.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.parameterField[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.parameterType[i])));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </parameter>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "rowlimit");
            this.sql = rep.getStepAttributeString(id_step, "sql");
            this.outerJoin = rep.getStepAttributeBoolean(id_step, "outer_join");
            this.replacevars = rep.getStepAttributeBoolean(id_step, "replace_vars");
            int nrparam = rep.countNrStepAttributes(id_step, "parameter_field");
            this.allocate(nrparam);
            for (int i = 0; i < nrparam; ++i) {
                this.parameterField[i] = rep.getStepAttributeString(id_step, i, "parameter_field");
                String stype = rep.getStepAttributeString(id_step, i, "parameter_type");
                this.parameterType[i] = ValueMeta.getType((String)stype);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "rowlimit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "sql", this.sql);
            rep.saveStepAttribute(id_transformation, id_step, "outer_join", this.outerJoin);
            rep.saveStepAttribute(id_transformation, id_step, "replace_vars", this.replacevars);
            for (int i = 0; i < this.parameterField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "parameter_field", this.parameterField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "parameter_type", ValueMeta.getTypeDesc((int)this.parameterType[i]));
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                if (this.sql != null && this.sql.length() != 0) {
                    RowMetaInterface param = this.getParameterRow(prev);
                    error_message = "";
                    RowMetaInterface r = db.getQueryFields(transMeta.environmentSubstitute(this.sql), true, param, new Object[param.size()]);
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.QueryOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    } else {
                        error_message = BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.InvalidDBQuery", (String[])new String[0]);
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                    int q = db.countParameters(transMeta.environmentSubstitute(this.sql));
                    if (q != this.parameterField.length) {
                        error_message = BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.DismatchBetweenParametersAndQuestion", (String[])new String[0]) + Const.CR;
                        error_message = error_message + BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.DismatchBetweenParametersAndQuestion2", (String[])new String[0]) + q + Const.CR;
                        error_message = error_message + BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.DismatchBetweenParametersAndQuestion3", (String[])new String[0]) + this.parameterField.length;
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    } else {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.NumberOfParamCorrect", (String[])new String[0]) + q + ")", (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    boolean first = true;
                    error_message = "";
                    boolean error_found = false;
                    for (int i = 0; i < this.parameterField.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.parameterField[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.MissingFields", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.parameterField[i] + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                error_message = BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.CounldNotReadFields", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                error_message = BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.ReceivingInfo", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowMetaInterface getTableFields() {
        RowMeta param = new RowMeta();
        for (int i = 0; i < this.parameterField.length; ++i) {
            param.addValueMeta((ValueMetaInterface)new ValueMeta(this.parameterField[i], this.parameterType[i]));
        }
        RowMetaInterface fields = null;
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                fields = db.getQueryFields(this.databaseMeta.environmentSubstitute(this.sql), true, (RowMetaInterface)param, new Object[param.size()]);
            }
            catch (KettleDatabaseException dbe) {
                this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.Log.DatabaseErrorOccurred", (String[])new String[0]) + dbe.getMessage());
            }
            finally {
                db.disconnect();
            }
        }
        return fields;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new DatabaseJoin(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new DatabaseJoinData();
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) throws KettleStepException {
        RowMetaInterface out = prev.clone();
        this.getFields(out, stepMeta.getName(), new RowMetaInterface[]{info}, null, transMeta, repository, metaStore);
        if (out != null) {
            for (int i = 0; i < out.size(); ++i) {
                ValueMetaInterface outvalue = out.getValueMeta(i);
                DatabaseImpact di = new DatabaseImpact(1, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), "", outvalue.getName(), outvalue.getName(), stepMeta.getName(), transMeta.environmentSubstitute(this.sql), BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.DatabaseImpact.Title", (String[])new String[0]));
                impact.add(di);
            }
        }
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

