/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.closure;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.closure.ClosureGenerator;
import org.pentaho.di.trans.steps.closure.ClosureGeneratorData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class ClosureGeneratorMeta
extends BaseStepMeta
implements StepMetaInterface {
    private boolean rootIdZero;
    private String parentIdFieldName;
    private String childIdFieldName;
    private String distanceFieldName;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        ClosureGeneratorMeta retval = (ClosureGeneratorMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.parentIdFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"parent_id_field");
            this.childIdFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"child_id_field");
            this.distanceFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"distance_field");
            this.rootIdZero = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"is_root_zero"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaInterface childValueMeta;
        RowMeta result = new RowMeta();
        ValueMetaInterface parentValueMeta = row.searchValueMeta(this.parentIdFieldName);
        if (parentValueMeta != null) {
            result.addValueMeta(parentValueMeta);
        }
        if ((childValueMeta = row.searchValueMeta(this.childIdFieldName)) != null) {
            result.addValueMeta(childValueMeta);
        }
        ValueMeta distanceValueMeta = new ValueMeta(this.distanceFieldName, 5);
        distanceValueMeta.setLength(10);
        result.addValueMeta((ValueMetaInterface)distanceValueMeta);
        row.clear();
        row.addRowMeta((RowMetaInterface)result);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"parent_id_field", (String)this.parentIdFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"child_id_field", (String)this.childIdFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"distance_field", (String)this.distanceFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"is_root_zero", (boolean)this.rootIdZero));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.parentIdFieldName = rep.getStepAttributeString(id_step, "parent_id_field");
            this.childIdFieldName = rep.getStepAttributeString(id_step, "child_id_field");
            this.distanceFieldName = rep.getStepAttributeString(id_step, "distance_field");
            this.rootIdZero = rep.getStepAttributeBoolean(id_step, "is_root_zero");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "parent_id_field", this.parentIdFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "child_id_field", this.childIdFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "distance_field", this.distanceFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "is_root_zero", this.rootIdZero);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        ValueMetaInterface parentValueMeta = prev.searchValueMeta(this.parentIdFieldName);
        if (parentValueMeta != null) {
            cr = new CheckResult(4, "The fieldname of the parent id could not be found.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "The fieldname of the parent id could be found", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        ValueMetaInterface childValueMeta = prev.searchValueMeta(this.childIdFieldName);
        if (childValueMeta != null) {
            cr = new CheckResult(4, "The fieldname of the child id could not be found.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "The fieldname of the child id could be found", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ClosureGenerator(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ClosureGeneratorData();
    }

    public boolean isRootIdZero() {
        return this.rootIdZero;
    }

    public void setRootIdZero(boolean rootIdZero) {
        this.rootIdZero = rootIdZero;
    }

    public String getParentIdFieldName() {
        return this.parentIdFieldName;
    }

    public void setParentIdFieldName(String parentIdFieldName) {
        this.parentIdFieldName = parentIdFieldName;
    }

    public String getChildIdFieldName() {
        return this.childIdFieldName;
    }

    public void setChildIdFieldName(String childIdFieldName) {
        this.childIdFieldName = childIdFieldName;
    }

    public String getDistanceFieldName() {
        return this.distanceFieldName;
    }

    public void setDistanceFieldName(String distanceFieldName) {
        this.distanceFieldName = distanceFieldName;
    }
}

