/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.append;

import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleRowException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.append.AppendData;
import org.pentaho.di.trans.steps.append.AppendMeta;

public class Append
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = Append.class;
    private AppendMeta meta;
    private AppendData data;

    public Append(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (AppendMeta)smi;
        this.data = (AppendData)sdi;
        Object[] input = null;
        if (this.data.processHead) {
            input = this.getRowFrom(this.data.headRowSet);
            if (input == null) {
                this.data.processHead = false;
                this.data.processTail = true;
            } else if (this.data.outputRowMeta == null) {
                this.data.outputRowMeta = this.data.headRowSet.getRowMeta();
            }
        }
        if (this.data.processTail) {
            input = this.getRowFrom(this.data.tailRowSet);
            if (input == null) {
                this.setOutputDone();
                return false;
            }
            if (this.data.outputRowMeta == null) {
                this.data.outputRowMeta = this.data.tailRowSet.getRowMeta();
            }
            if (this.data.firstTail) {
                this.data.firstTail = false;
                try {
                    this.checkInputLayoutValid(this.data.headRowSet.getRowMeta(), this.data.tailRowSet.getRowMeta());
                }
                catch (KettleRowException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Append.Exception.InvalidLayoutDetected", (String[])new String[0]), (Throwable)e);
                }
            }
        }
        if (input != null) {
            this.putRow(this.data.outputRowMeta, input);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"AppendRows.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AppendMeta)smi;
        this.data = (AppendData)sdi;
        if (super.init(smi, sdi)) {
            this.data.processHead = true;
            this.data.processTail = false;
            this.data.firstTail = true;
            List<StreamInterface> infoStreams = this.meta.getStepIOMeta().getInfoStreams();
            StreamInterface headStream = infoStreams.get(0);
            StreamInterface tailStream = infoStreams.get(1);
            if (headStream.getStepname() == null || tailStream.getStepname() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"AppendRows.Log.BothHopsAreNeeded", (String[])new String[0]));
            } else {
                try {
                    this.data.headRowSet = this.findInputRowSet(headStream.getStepname());
                    this.data.tailRowSet = this.findInputRowSet(tailStream.getStepname());
                    return true;
                }
                catch (Exception e) {
                    this.logError(e.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    protected void checkInputLayoutValid(RowMetaInterface referenceRowMeta, RowMetaInterface compareRowMeta) throws KettleRowException {
        if (referenceRowMeta != null && compareRowMeta != null) {
            BaseStep.safeModeChecking(referenceRowMeta, compareRowMeta);
        }
    }
}

