/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Node;

public class BaseRepositoryMeta {
    protected String id;
    protected String name;
    protected String description;

    public BaseRepositoryMeta(String id) {
        this.id = id;
    }

    public String getDialogClassName() {
        String className = this.getClass().getCanonicalName();
        if ((className = className.replaceFirst("\\.di\\.", ".di.ui.")).endsWith("Meta")) {
            className = className.substring(0, className.length() - 4);
        }
        className = className + "Dialog";
        return className;
    }

    public String getRevisionBrowserDialogClassName() {
        String className = this.getClass().getCanonicalName();
        if ((className = className.replaceFirst("\\.di\\.", ".di.ui.")).endsWith("Meta")) {
            className = className.substring(0, className.length() - 4);
        }
        className = className + "RevisionBrowserDialog";
        return className;
    }

    public BaseRepositoryMeta(String id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public void loadXML(Node repnode, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.id = Const.NVL((String)XMLHandler.getTagValue((Node)repnode, (String)"id"), (String)this.id);
            this.name = XMLHandler.getTagValue((Node)repnode, (String)"name");
            this.description = XMLHandler.getTagValue((Node)repnode, (String)"description");
        }
        catch (Exception e) {
            throw new KettleException("Unable to load repository meta object", (Throwable)e);
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(100);
        retval.append("    ").append(XMLHandler.addTagValue((String)"id", (String)this.id));
        retval.append("    ").append(XMLHandler.addTagValue((String)"name", (String)this.name));
        retval.append("    ").append(XMLHandler.addTagValue((String)"description", (String)this.description));
        return retval.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

