/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.gui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.jfree.text.TextUtilities;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SwingUniversalImage;
import org.pentaho.di.core.SwingUniversalImageBitmap;
import org.pentaho.di.core.SwingUniversalImageSvg;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.PrimitiveGCInterface;
import org.pentaho.di.core.gui.SwingGUIResource;
import org.pentaho.di.core.svg.SvgImage;
import org.pentaho.di.core.svg.SvgSupport;
import org.pentaho.di.core.util.SwingSvgImageUtil;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.laf.BasePropertyHandler;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;

public class SwingDirectGC
implements GCInterface {
    private static SwingUniversalImage imageLocked;
    private static SwingUniversalImage imageStepError;
    private static SwingUniversalImage imageEdit;
    private static SwingUniversalImage imageContextMenu;
    private static SwingUniversalImage imageTrue;
    private static SwingUniversalImage imageFalse;
    private static SwingUniversalImage imageErrorHop;
    private static SwingUniversalImage imageInfoHop;
    private static SwingUniversalImage imageHopTarget;
    private static SwingUniversalImage imageHopInput;
    private static SwingUniversalImage imageHopOutput;
    private static SwingUniversalImage imageArrow;
    private static SwingUniversalImage imageCopyHop;
    private static SwingUniversalImage imageLoadBalance;
    private static SwingUniversalImage imageCheckpoint;
    private static SwingUniversalImage imageDatabase;
    private static SwingUniversalImage imageParallelHop;
    private static SwingUniversalImage imageUnconditionalHop;
    private static SwingUniversalImage imageStart;
    private static SwingUniversalImage imageDummy;
    private static SwingUniversalImage imageBusy;
    private static SwingUniversalImage imageInject;
    private static SwingUniversalImage defaultArrow;
    private static SwingUniversalImage okArrow;
    private static SwingUniversalImage errorArrow;
    private static SwingUniversalImage disabledArrow;
    protected Color background;
    protected Color black;
    protected Color red;
    protected Color yellow;
    protected Color orange;
    protected Color green;
    protected Color blue;
    protected Color magenta;
    protected Color gray;
    protected Color lightGray;
    protected Color darkGray;
    protected Color lightBlue;
    protected Color crystal;
    protected Color hopDefault;
    protected Color hopOK;
    private Graphics2D gc;
    private int iconsize;
    private int small_icon_size = 16;
    private Map<String, SwingUniversalImage> stepImages;
    private Map<String, SwingUniversalImage> entryImages;
    private BufferedImage image;
    private ImageObserver observer;
    private Point area;
    private int alpha;
    private Font fontGraph;
    private Font fontNote;
    private Font fontSmall;
    private int lineWidth;
    private PrimitiveGCInterface.ELineStyle lineStyle;
    private int yOffset;
    private int xOffset;
    private boolean drawingPixelatedImages;

    public SwingDirectGC(ImageObserver observer, Point area, int iconsize, int xOffset, int yOffset) throws KettleException {
        this.image = new BufferedImage(area.x, area.y, 2);
        this.gc = this.image.createGraphics();
        this.observer = observer;
        this.stepImages = SwingGUIResource.getInstance().getStepImages();
        this.entryImages = SwingGUIResource.getInstance().getEntryImages();
        this.iconsize = iconsize;
        this.area = area;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.init();
    }

    public SwingDirectGC(Graphics2D gc, Rectangle2D rect, int iconsize, int xOffset, int yOffset) throws KettleException {
        this.image = null;
        this.gc = gc;
        this.observer = null;
        this.stepImages = SwingGUIResource.getInstance().getStepImages();
        this.entryImages = SwingGUIResource.getInstance().getEntryImages();
        this.iconsize = iconsize;
        this.area = new Point((int)rect.getWidth(), (int)rect.getHeight());
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.init();
    }

    private void init() throws KettleException {
        this.lineStyle = PrimitiveGCInterface.ELineStyle.SOLID;
        this.lineWidth = 1;
        this.alpha = 255;
        this.background = new Color(255, 255, 255);
        this.black = new Color(0, 0, 0);
        this.red = new Color(255, 0, 0);
        this.yellow = new Color(255, 255, 0);
        this.orange = new Color(255, 165, 0);
        this.green = new Color(0, 255, 0);
        this.blue = new Color(0, 0, 255);
        this.magenta = new Color(255, 0, 255);
        this.gray = new Color(128, 128, 128);
        this.lightGray = new Color(200, 200, 200);
        this.darkGray = new Color(80, 80, 80);
        this.lightBlue = new Color(135, 206, 250);
        this.crystal = new Color(61, 99, 128);
        this.hopDefault = new Color(61, 99, 128);
        this.hopOK = new Color(12, 178, 15);
        imageLocked = this.getImageIcon(BasePropertyHandler.getProperty((String)"Locked_image"));
        imageStepError = this.getImageIcon(BasePropertyHandler.getProperty((String)"StepErrorLines_image"));
        imageEdit = this.getImageIcon(BasePropertyHandler.getProperty((String)"Edit_image"));
        imageContextMenu = this.getImageIcon(BasePropertyHandler.getProperty((String)"ContextMenu_image"));
        imageTrue = this.getImageIcon(BasePropertyHandler.getProperty((String)"True_image"));
        imageFalse = this.getImageIcon(BasePropertyHandler.getProperty((String)"False_image"));
        imageErrorHop = this.getImageIcon(BasePropertyHandler.getProperty((String)"ErrorHop_image"));
        imageInfoHop = this.getImageIcon(BasePropertyHandler.getProperty((String)"InfoHop_image"));
        imageHopTarget = this.getImageIcon(BasePropertyHandler.getProperty((String)"HopTarget_image"));
        imageHopInput = this.getImageIcon(BasePropertyHandler.getProperty((String)"HopInput_image"));
        imageHopOutput = this.getImageIcon(BasePropertyHandler.getProperty((String)"HopOutput_image"));
        imageArrow = this.getImageIcon(BasePropertyHandler.getProperty((String)"ArrowIcon_image"));
        imageCopyHop = this.getImageIcon(BasePropertyHandler.getProperty((String)"CopyHop_image"));
        imageLoadBalance = this.getImageIcon(BasePropertyHandler.getProperty((String)"LoadBalance_image"));
        imageCheckpoint = this.getImageIcon(BasePropertyHandler.getProperty((String)"CheckeredFlag_image"));
        imageDatabase = this.getImageIcon(BasePropertyHandler.getProperty((String)"Database_image"));
        imageParallelHop = this.getImageIcon(BasePropertyHandler.getProperty((String)"ParallelHop_image"));
        imageUnconditionalHop = this.getImageIcon(BasePropertyHandler.getProperty((String)"UnconditionalHop_image"));
        imageStart = this.getImageIcon(BasePropertyHandler.getProperty((String)"STR_image"));
        imageDummy = this.getImageIcon(BasePropertyHandler.getProperty((String)"DUM_image"));
        imageBusy = this.getImageIcon(BasePropertyHandler.getProperty((String)"Busy_image"));
        imageInject = this.getImageIcon(BasePropertyHandler.getProperty((String)"Inject_image"));
        defaultArrow = this.getImageIcon(BasePropertyHandler.getProperty((String)"defaultArrow_image"));
        okArrow = this.getImageIcon(BasePropertyHandler.getProperty((String)"okArrow_image"));
        errorArrow = this.getImageIcon(BasePropertyHandler.getProperty((String)"errorArrow_image"));
        disabledArrow = this.getImageIcon(BasePropertyHandler.getProperty((String)"disabledArrow_image"));
        this.fontGraph = new Font("FreeSans", 0, 10);
        this.fontNote = new Font("FreeSans", 0, 10);
        this.fontSmall = new Font("FreeSans", 0, 8);
        this.gc.setFont(this.fontGraph);
        this.gc.setColor(this.background);
        this.gc.fillRect(0, 0, this.area.x, this.area.y);
    }

    private SwingUniversalImage getImageIcon(String fileName) throws KettleException {
        SwingUniversalImageSvg image = null;
        InputStream inputStream = null;
        if (fileName == null) {
            throw new KettleException("Image icon file name can not be null");
        }
        if (SvgSupport.isSvgEnabled() && SvgSupport.isSvgName((String)fileName)) {
            try {
                inputStream = new FileInputStream(fileName);
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream("/" + fileName);
                }
                catch (FileNotFoundException ex) {
                    // empty catch block
                }
            }
            if (inputStream == null) {
                inputStream = this.getClass().getResourceAsStream(fileName);
            }
            if (inputStream == null) {
                inputStream = this.getClass().getResourceAsStream("/" + fileName);
            }
            if (inputStream != null) {
                try {
                    SvgImage svg = SvgSupport.loadSvgImage((InputStream)inputStream);
                    image = new SwingUniversalImageSvg(svg);
                }
                catch (Exception ex) {
                    throw new KettleException("Unable to load image from classpath : '" + fileName + "'", (Throwable)ex);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
        if (image == null) {
            fileName = SvgSupport.toPngName((String)fileName);
            try {
                inputStream = new FileInputStream(fileName);
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream("/" + fileName);
                }
                catch (FileNotFoundException ex) {
                    // empty catch block
                }
            }
            if (inputStream == null) {
                inputStream = this.getClass().getResourceAsStream(fileName);
            }
            if (inputStream == null) {
                inputStream = this.getClass().getResourceAsStream("/" + fileName);
            }
            if (inputStream != null) {
                try {
                    BufferedImage bitmap = ImageIO.read(inputStream);
                    WaitingImageObserver wia = new WaitingImageObserver((Image)bitmap);
                    wia.waitImageLoaded();
                    image = new SwingUniversalImageBitmap(bitmap);
                }
                catch (Exception ex) {
                    throw new KettleException("Unable to load image from classpath : '" + fileName + "'", (Throwable)ex);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
        if (image == null) {
            throw new KettleException("Unable to load image from classpath : '" + fileName + "'");
        }
        return image;
    }

    public void dispose() {
    }

    public void drawLine(int x, int y, int x2, int y2) {
        this.gc.drawLine(x + this.xOffset, y + this.yOffset, x2 + this.xOffset, y2 + this.yOffset);
    }

    public void drawImage(String location, ClassLoader classLoader, int x, int y) {
        SwingUniversalImage img = SwingSvgImageUtil.getUniversalImage(classLoader, location);
        this.drawImage(img, x, y, this.small_icon_size);
    }

    public void drawImage(PrimitiveGCInterface.EImage image, int x, int y) {
        this.drawImage(image, x, y, 0.0f);
    }

    public void drawImage(PrimitiveGCInterface.EImage image, int locationX, int locationY, float magnification) {
        SwingUniversalImage img = SwingDirectGC.getNativeImage(image);
        this.drawImage(img, locationX, locationY, this.small_icon_size);
    }

    public void drawImage(PrimitiveGCInterface.EImage image, int locationX, int locationY, float magnification, double angle) {
        SwingUniversalImage img = SwingDirectGC.getNativeImage(image);
        this.drawImage(img, locationX, locationY, angle, this.small_icon_size);
    }

    private void drawImage(SwingUniversalImage img, int locationX, int locationY, int imageSize) {
        if (this.isDrawingPixelatedImages() && img.isBitmap()) {
            BufferedImage bi = new BufferedImage(imageSize, imageSize, 2);
            Graphics2D g2 = (Graphics2D)bi.getGraphics();
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, imageSize, imageSize);
            g2.drawImage((Image)img.getAsBitmapForSize(imageSize, imageSize), 0, 0, this.observer);
            g2.dispose();
            for (int x = 0; x < bi.getWidth(this.observer); ++x) {
                for (int y = 0; y < bi.getHeight(this.observer); ++y) {
                    int rgb = bi.getRGB(x, y);
                    this.gc.setColor(new Color(rgb));
                    this.gc.setStroke(new BasicStroke(1.0f));
                    this.gc.drawLine(locationX + this.xOffset + x, locationY + this.yOffset + y, locationX + this.xOffset + x, locationY + this.yOffset + y);
                }
            }
        } else {
            this.gc.setBackground(Color.white);
            this.gc.clearRect(locationX, locationY, imageSize, imageSize);
            img.drawToGraphics(this.gc, locationX, locationY, imageSize, imageSize);
        }
    }

    private void drawImage(SwingUniversalImage img, int centerX, int centerY, double angle, int imageSize) {
        if (this.isDrawingPixelatedImages() && img.isBitmap()) {
            BufferedImage bi = img.getAsBitmapForSize(imageSize, imageSize, angle);
            int offx = centerX + this.xOffset - bi.getWidth() / 2;
            int offy = centerY + this.yOffset - bi.getHeight() / 2;
            for (int x = 0; x < bi.getWidth(this.observer); ++x) {
                for (int y = 0; y < bi.getHeight(this.observer); ++y) {
                    int rgb = bi.getRGB(x, y);
                    this.gc.setColor(new Color(rgb));
                    this.gc.setStroke(new BasicStroke(1.0f));
                    this.gc.drawLine(offx + x, offy + y, offx + x, offy + y);
                }
            }
        } else {
            this.gc.setBackground(Color.white);
            this.gc.clearRect(centerX, centerY, imageSize, imageSize);
            img.drawToGraphics(this.gc, centerX, centerY, imageSize, imageSize, angle);
        }
    }

    public Point getImageBounds(PrimitiveGCInterface.EImage image) {
        return new Point(this.small_icon_size, this.small_icon_size);
    }

    public static final SwingUniversalImage getNativeImage(PrimitiveGCInterface.EImage image) {
        switch (image) {
            case LOCK: {
                return imageLocked;
            }
            case STEP_ERROR: {
                return imageStepError;
            }
            case EDIT: {
                return imageEdit;
            }
            case CONTEXT_MENU: {
                return imageContextMenu;
            }
            case TRUE: {
                return imageTrue;
            }
            case FALSE: {
                return imageFalse;
            }
            case ERROR: {
                return imageErrorHop;
            }
            case INFO: {
                return imageInfoHop;
            }
            case TARGET: {
                return imageHopTarget;
            }
            case INPUT: {
                return imageHopInput;
            }
            case OUTPUT: {
                return imageHopOutput;
            }
            case ARROW: {
                return imageArrow;
            }
            case COPY_ROWS: {
                return imageCopyHop;
            }
            case LOAD_BALANCE: {
                return imageLoadBalance;
            }
            case CHECKPOINT: {
                return imageCheckpoint;
            }
            case DB: {
                return imageDatabase;
            }
            case PARALLEL: {
                return imageParallelHop;
            }
            case UNCONDITIONAL: {
                return imageUnconditionalHop;
            }
            case BUSY: {
                return imageBusy;
            }
            case INJECT: {
                return imageInject;
            }
            case ARROW_DEFAULT: {
                return defaultArrow;
            }
            case ARROW_OK: {
                return okArrow;
            }
            case ARROW_ERROR: {
                return errorArrow;
            }
            case ARROW_DISABLED: {
                return disabledArrow;
            }
        }
        return null;
    }

    public void drawPoint(int x, int y) {
        this.gc.drawLine(x + this.xOffset, y + this.yOffset, x + this.xOffset, y + this.yOffset);
    }

    public void drawPolygon(int[] polygon) {
        this.gc.drawPolygon(this.getSwingPolygon(polygon));
    }

    private Polygon getSwingPolygon(int[] polygon) {
        int nPoints = polygon.length / 2;
        int[] xPoints = new int[polygon.length / 2];
        int[] yPoints = new int[polygon.length / 2];
        for (int i = 0; i < nPoints; ++i) {
            xPoints[i] = polygon[2 * i + 0] + this.xOffset;
            yPoints[i] = polygon[2 * i + 1] + this.yOffset;
        }
        return new Polygon(xPoints, yPoints, nPoints);
    }

    public void drawPolyline(int[] polyline) {
        int nPoints = polyline.length / 2;
        int[] xPoints = new int[polyline.length / 2];
        int[] yPoints = new int[polyline.length / 2];
        for (int i = 0; i < nPoints; ++i) {
            xPoints[i] = polyline[2 * i + 0] + this.xOffset;
            yPoints[i] = polyline[2 * i + 1] + this.yOffset;
        }
        this.gc.drawPolyline(xPoints, yPoints, nPoints);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.gc.drawRect(x + this.xOffset, y + this.yOffset, width, height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int circleWidth, int circleHeight) {
        this.gc.drawRoundRect(x + this.xOffset, y + this.yOffset, width, height, circleWidth, circleHeight);
    }

    public void drawText(String text, int x, int y) {
        String[] lines;
        int height = this.gc.getFontMetrics().getHeight();
        for (String line : lines = text.split("\n")) {
            this.gc.drawString(line, x + this.xOffset, y + height + this.yOffset);
            y += height;
        }
    }

    public void drawText(String text, int x, int y, boolean transparent) {
        this.drawText(text, x, y);
    }

    public void fillPolygon(int[] polygon) {
        this.switchForegroundBackgroundColors();
        this.gc.fillPolygon(this.getSwingPolygon(polygon));
        this.switchForegroundBackgroundColors();
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.switchForegroundBackgroundColors();
        this.gc.fillRect(x + this.xOffset, y + this.yOffset, width, height);
        this.switchForegroundBackgroundColors();
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        this.fillRectangle(x, y, width, height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int circleWidth, int circleHeight) {
        this.switchForegroundBackgroundColors();
        this.gc.fillRoundRect(x + this.xOffset, y + this.yOffset, width, height, circleWidth, circleHeight);
        this.switchForegroundBackgroundColors();
    }

    public Point getDeviceBounds() {
        return this.area;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, alpha / 255);
        this.gc.setComposite(alphaComposite);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setBackground(PrimitiveGCInterface.EColor color) {
        this.gc.setBackground(this.getColor(color));
    }

    private Color getColor(PrimitiveGCInterface.EColor color) {
        switch (color) {
            case BACKGROUND: {
                return this.background;
            }
            case BLACK: {
                return this.black;
            }
            case RED: {
                return this.red;
            }
            case YELLOW: {
                return this.yellow;
            }
            case ORANGE: {
                return this.orange;
            }
            case GREEN: {
                return this.green;
            }
            case BLUE: {
                return this.blue;
            }
            case MAGENTA: {
                return this.magenta;
            }
            case GRAY: {
                return this.gray;
            }
            case LIGHTGRAY: {
                return this.lightGray;
            }
            case DARKGRAY: {
                return this.darkGray;
            }
            case LIGHTBLUE: {
                return this.lightBlue;
            }
            case CRYSTAL: {
                return this.crystal;
            }
            case HOP_DEFAULT: {
                return this.hopDefault;
            }
            case HOP_OK: {
                return this.hopOK;
            }
        }
        return null;
    }

    public void setFont(PrimitiveGCInterface.EFont font) {
        switch (font) {
            case GRAPH: {
                this.gc.setFont(this.fontGraph);
                break;
            }
            case NOTE: {
                this.gc.setFont(this.fontNote);
                break;
            }
            case SMALL: {
                this.gc.setFont(this.fontSmall);
                break;
            }
        }
    }

    public void setForeground(PrimitiveGCInterface.EColor color) {
        this.gc.setColor(this.getColor(color));
    }

    public void setLineStyle(PrimitiveGCInterface.ELineStyle lineStyle) {
        this.lineStyle = lineStyle;
        this.gc.setStroke(this.createStroke());
    }

    private Stroke createStroke() {
        float[] dash;
        switch (this.lineStyle) {
            case SOLID: {
                dash = null;
                break;
            }
            case DOT: {
                dash = new float[]{5.0f};
                break;
            }
            case DASHDOT: {
                dash = new float[]{10.0f, 5.0f, 5.0f, 5.0f};
                break;
            }
            case PARALLEL: {
                dash = new float[]{10.0f, 5.0f, 10.0f, 5.0f};
                break;
            }
            default: {
                throw new RuntimeException("Unhandled line style!");
            }
        }
        return new BasicStroke(this.lineWidth, 0, 0, 2.0f, dash, 0.0f);
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
        this.gc.setStroke(this.createStroke());
    }

    public void setTransform(float translationX, float translationY, int shadowsize, float magnification) {
        AffineTransform transform = new AffineTransform();
        transform.translate(translationX + (float)shadowsize * magnification, translationY + (float)shadowsize * magnification);
        transform.scale(magnification, magnification);
        this.gc.setTransform(transform);
    }

    public Point textExtent(String text) {
        String[] lines = text.split(Const.CR);
        int maxWidth = 0;
        for (String line : lines) {
            Rectangle2D bounds = TextUtilities.getTextBounds((String)line, (Graphics2D)this.gc, (FontMetrics)this.gc.getFontMetrics());
            if (!(bounds.getWidth() > (double)maxWidth)) continue;
            maxWidth = (int)bounds.getWidth();
        }
        int height = this.gc.getFontMetrics().getHeight() * lines.length;
        return new Point(maxWidth, height);
    }

    @Override
    public void drawStepIcon(int x, int y, StepMeta stepMeta, float magnification) {
        String steptype = stepMeta.getStepID();
        SwingUniversalImage im = this.stepImages.get(steptype);
        if (im != null) {
            this.drawImage(im, x + this.xOffset, y + this.xOffset, this.iconsize);
        }
    }

    @Override
    public void drawJobEntryIcon(int x, int y, JobEntryCopy jobEntryCopy, float magnification) {
        if (jobEntryCopy == null) {
            return;
        }
        SwingUniversalImage image = null;
        if (jobEntryCopy.isSpecial()) {
            if (jobEntryCopy.isStart()) {
                image = imageStart;
            }
            if (jobEntryCopy.isDummy()) {
                image = imageDummy;
            }
        } else {
            String configId = jobEntryCopy.getEntry().getPluginId();
            if (configId != null) {
                image = this.entryImages.get(configId);
            }
        }
        if (image == null) {
            return;
        }
        this.drawImage(image, x + this.xOffset, y + this.xOffset, this.iconsize);
    }

    @Override
    public void drawJobEntryIcon(int x, int y, JobEntryCopy jobEntryCopy) {
        this.drawJobEntryIcon(x, y, jobEntryCopy, 1.0f);
    }

    @Override
    public void drawStepIcon(int x, int y, StepMeta stepMeta) {
        this.drawStepIcon(x, y, stepMeta, 1.0f);
    }

    public void setAntialias(boolean antiAlias) {
        if (antiAlias) {
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            this.gc.setRenderingHints(hints);
        }
    }

    public void setBackground(int r, int g, int b) {
        Color color = this.getColor(r, g, b);
        this.gc.setBackground(color);
    }

    public void setForeground(int r, int g, int b) {
        Color color = this.getColor(r, g, b);
        this.gc.setColor(color);
    }

    private Color getColor(int r, int g, int b) {
        return new Color(r, g, b);
    }

    public void setFont(String fontName, int fontSize, boolean fontBold, boolean fontItalic) {
        int style = 0;
        if (fontBold) {
            style = 1;
        }
        if (fontItalic) {
            style |= 2;
        }
        Font font = new Font(fontName, style, fontSize);
        this.gc.setFont(font);
    }

    public Object getImage() {
        return this.image;
    }

    public void switchForegroundBackgroundColors() {
        Color fg = this.gc.getColor();
        Color bg = this.gc.getBackground();
        this.gc.setColor(bg);
        this.gc.setBackground(fg);
    }

    public Point getArea() {
        return this.area;
    }

    public boolean isDrawingPixelatedImages() {
        return this.drawingPixelatedImages;
    }

    public void setDrawingPixelatedImages(boolean drawingPixelatedImages) {
        this.drawingPixelatedImages = drawingPixelatedImages;
    }

    public void drawImage(BufferedImage image, int x, int y) {
        this.gc.drawImage((Image)image, x, y, this.observer);
    }
}

