/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.changed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.di.core.changed.PDIObserver;

public class ChangedFlag
implements ChangedFlagInterface {
    private List<PDIObserver> obs = Collections.synchronizedList(new ArrayList());
    private AtomicBoolean changed = new AtomicBoolean();

    public void addObserver(PDIObserver o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!this.obs.contains(o)) {
            this.obs.add(o);
        }
    }

    public synchronized void deleteObserver(PDIObserver o) {
        this.obs.remove(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object arg) {
        PDIObserver[] lobs;
        ChangedFlag changedFlag = this;
        synchronized (changedFlag) {
            if (!this.changed.get()) {
                return;
            }
            lobs = this.obs.toArray(new PDIObserver[this.obs.size()]);
            this.clearChanged();
        }
        for (int i = lobs.length - 1; i >= 0; --i) {
            lobs[i].update(this, arg);
        }
    }

    @Override
    public void setChanged() {
        this.changed.set(true);
    }

    @Override
    public void setChanged(boolean b) {
        this.changed.set(b);
    }

    @Override
    public void clearChanged() {
        this.changed.set(false);
    }

    @Override
    public synchronized boolean hasChanged() {
        return this.changed.get();
    }
}

