/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;
import org.pentaho.di.core.logging.LogChannelInterface;

public class SortedFileOutputStream
extends FileOutputStream {
    private StringBuffer sb = null;
    private LogChannelInterface log = null;

    public SortedFileOutputStream(File file) throws FileNotFoundException {
        super(file);
    }

    public void setLogger(LogChannelInterface log) {
        this.log = log;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.sb == null) {
            this.sb = new StringBuffer();
        }
        this.sb.append(new String(b, off, len));
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.sb == null) {
            this.sb = new StringBuffer();
        }
        this.sb.append(new String(b));
    }

    @Override
    public void write(int b) throws IOException {
        if (this.sb == null) {
            this.sb = new StringBuffer();
        }
        this.sb.append(b);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.sb == null || this.sb.length() == 0) {
            super.flush();
            super.close();
        }
        int[] iPos = new int[]{0};
        String sLine = this.nextLine(iPos);
        Vector<String> lines = new Vector<String>();
        while (sLine != null) {
            if (sLine.length() == 0) {
                sLine = this.nextLine(iPos);
                continue;
            }
            if (sLine.charAt(0) == '#') {
                super.write(sLine.getBytes());
                sLine = this.nextLine(iPos);
                continue;
            }
            int idx = sLine.indexOf(61);
            if (idx <= 0) {
                this.log.logError(this.getClass().getName(), "Unexpected: '=' character not found or found at first position.");
                super.write(sLine.getBytes());
            } else {
                while (idx != -1 && sLine.charAt(idx - 1) == '\\') {
                    idx = sLine.indexOf(61, idx + 1);
                }
                if (idx == -1) {
                    this.log.logError(this.getClass().getName(), "Unexpected: No '=' character found that is not escaped by a '\\'.");
                    super.write(sLine.getBytes());
                } else {
                    lines.add(sLine);
                }
            }
            sLine = this.nextLine(iPos);
        }
        Collections.sort(lines);
        for (String line : lines) {
            super.write(line.getBytes());
        }
        super.flush();
        super.close();
    }

    private String nextLine(int[] iPos) {
        if (iPos[0] >= this.sb.length()) {
            return null;
        }
        int iStart = iPos[0];
        char c = this.sb.charAt(iPos[0]);
        while (iPos[0] < this.sb.length() && c != '\n' && c != '\r') {
            int n = iPos[0];
            iPos[0] = n + 1;
            c = this.sb.charAt(n);
            if (iPos[0] < 2 || c != '\n' && c != '\r' || iPos[0] - 2 != 92 || iPos[0] >= this.sb.length()) continue;
            int n2 = iPos[0];
            iPos[0] = n2 + 1;
            c = this.sb.charAt(n2);
        }
        if (iPos[0] == this.sb.length()) {
            return this.sb.substring(iStart);
        }
        while (iPos[0] < this.sb.length() && (c == '\n' || c == '\r')) {
            int n = iPos[0];
            iPos[0] = n + 1;
            c = this.sb.charAt(n);
        }
        if (iPos[0] == this.sb.length()) {
            return this.sb.substring(iStart);
        }
        iPos[0] = iPos[0] - 1;
        return this.sb.substring(iStart, iPos[0]);
    }
}

