/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.sql;

public enum ServiceCacheMethod {
    None("No caching"),
    LocalMemory("Cache in local memory");

    private String description;

    private ServiceCacheMethod(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static ServiceCacheMethod getMethodByName(String string) {
        for (ServiceCacheMethod method : ServiceCacheMethod.values()) {
            if (!method.name().equalsIgnoreCase(string)) continue;
            return method;
        }
        return None;
    }

    public static ServiceCacheMethod getMethodByDescription(String description) {
        for (ServiceCacheMethod method : ServiceCacheMethod.values()) {
            if (!method.getDescription().equalsIgnoreCase(description)) continue;
            return method;
        }
        return None;
    }

    public static String[] getDescriptions() {
        String[] strings = new String[ServiceCacheMethod.values().length];
        for (int i = 0; i < ServiceCacheMethod.values().length; ++i) {
            strings[i] = ServiceCacheMethod.values()[i].getDescription();
        }
        return strings;
    }
}

