/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.Metrics;
import org.pentaho.di.core.logging.MetricsInterface;
import org.pentaho.di.core.plugins.ClassLoadingPluginInterface;
import org.pentaho.di.core.plugins.JarFileCache;
import org.pentaho.di.core.plugins.KettleSelectiveParentFirstClassLoader;
import org.pentaho.di.core.plugins.KettleURLClassLoader;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistryExtension;
import org.pentaho.di.core.plugins.PluginRegistryPluginType;
import org.pentaho.di.core.plugins.PluginTypeCategoriesOrder;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.PluginTypeListener;
import org.pentaho.di.core.row.RowBuffer;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.i18n.BaseMessages;

public class PluginRegistry {
    private static final Class<?> PKG = PluginRegistry.class;
    private static final PluginRegistry pluginRegistry = new PluginRegistry();
    private static final List<PluginTypeInterface> pluginTypes = new ArrayList<PluginTypeInterface>();
    private static final List<PluginRegistryExtension> extensions = new ArrayList<PluginRegistryExtension>();
    public static final LogChannelInterface log = new LogChannel((Object)"PluginRegistry", true);
    private final Map<Class<? extends PluginTypeInterface>, List<PluginInterface>> pluginMap;
    private final Map<String, URLClassLoader> folderBasedClassLoaderMap = new HashMap<String, URLClassLoader>();
    private final Map<Class<? extends PluginTypeInterface>, Map<PluginInterface, URLClassLoader>> classLoaderMap;
    private final Map<String, URLClassLoader> classLoaderGroupsMap;
    private final Map<Class<? extends PluginTypeInterface>, List<String>> categoryMap;
    private final Map<PluginInterface, String[]> parentClassloaderPatternMap = new HashMap<PluginInterface, String[]>();
    private final Map<Class<? extends PluginTypeInterface>, List<PluginTypeListener>> listeners = new HashMap<Class<? extends PluginTypeInterface>, List<PluginTypeListener>>();
    private final ReentrantReadWriteLock lock;

    private PluginRegistry() {
        this.pluginMap = new HashMap<Class<? extends PluginTypeInterface>, List<PluginInterface>>();
        this.classLoaderMap = new HashMap<Class<? extends PluginTypeInterface>, Map<PluginInterface, URLClassLoader>>();
        this.categoryMap = new HashMap<Class<? extends PluginTypeInterface>, List<String>>();
        this.classLoaderGroupsMap = new HashMap<String, URLClassLoader>();
        this.lock = new ReentrantReadWriteLock();
    }

    public static PluginRegistry getInstance() {
        return pluginRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPluginType(Class<? extends PluginTypeInterface> pluginType) {
        this.lock.writeLock().lock();
        try {
            if (this.pluginMap.get(pluginType) == null) {
                this.pluginMap.put(pluginType, new ArrayList());
            }
            if (this.categoryMap.get(pluginType) == null) {
                this.categoryMap.put(pluginType, new ArrayList());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlugin(Class<? extends PluginTypeInterface> pluginType, PluginInterface plugin) {
        this.lock.writeLock().lock();
        try {
            List<PluginTypeListener> listeners;
            Map<PluginInterface, URLClassLoader> classLoaders;
            List<PluginInterface> list = this.pluginMap.get(pluginType);
            if (list != null) {
                list.remove(plugin);
            }
            if ((classLoaders = this.classLoaderMap.get(plugin.getPluginType())) != null) {
                classLoaders.remove(plugin);
            }
            if (!Const.isEmpty(plugin.getClassLoaderGroup())) {
                this.classLoaderGroupsMap.remove(plugin.getClassLoaderGroup());
            }
            if ((listeners = this.listeners.get(pluginType)) != null) {
                for (PluginTypeListener listener : listeners) {
                    listener.pluginRemoved(plugin);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
            PluginRegistry pluginRegistry = this;
            synchronized (pluginRegistry) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParentClassLoaderPatterns(PluginInterface plugin, String[] patterns) {
        this.lock.writeLock().lock();
        try {
            this.parentClassloaderPatternMap.put(plugin, patterns);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPlugin(Class<? extends PluginTypeInterface> pluginType, PluginInterface plugin) throws KettlePluginException {
        this.lock.writeLock().lock();
        try {
            List<PluginTypeListener> listeners;
            int index;
            boolean changed = false;
            if (plugin.getIds()[0] == null) {
                throw new KettlePluginException("Not a valid id specified in plugin :" + plugin);
            }
            List<PluginInterface> list = this.pluginMap.get(pluginType);
            if (list == null) {
                list = new ArrayList<PluginInterface>();
                this.pluginMap.put(pluginType, list);
            }
            if ((index = list.indexOf(plugin)) < 0) {
                list.add(plugin);
            } else {
                list.set(index, plugin);
                changed = true;
            }
            Collections.sort(list, new Comparator<PluginInterface>(){

                @Override
                public int compare(PluginInterface p1, PluginInterface p2) {
                    return p1.getName().compareToIgnoreCase(p2.getName());
                }
            });
            if (!Const.isEmpty(plugin.getCategory())) {
                List<String> categories = this.categoryMap.get(pluginType);
                if (categories == null) {
                    categories = new ArrayList<String>();
                    this.categoryMap.put(pluginType, categories);
                }
                if (!categories.contains(plugin.getCategory())) {
                    categories.add(plugin.getCategory());
                    String[] naturalOrder = null;
                    PluginTypeCategoriesOrder naturalOrderAnnotation = pluginType.getAnnotation(PluginTypeCategoriesOrder.class);
                    if (naturalOrderAnnotation != null) {
                        String[] naturalOrderKeys = naturalOrderAnnotation.getNaturalCategoriesOrder();
                        Class<?> i18nClass = naturalOrderAnnotation.i18nPackageClass();
                        naturalOrder = new String[naturalOrderKeys.length];
                        for (int i = 0; i < naturalOrderKeys.length; ++i) {
                            naturalOrder[i] = BaseMessages.getString(i18nClass, naturalOrderKeys[i], new String[0]);
                        }
                    }
                    if (naturalOrder != null) {
                        final String[] fNaturalOrder = naturalOrder;
                        Collections.sort(categories, new Comparator<String>(){

                            @Override
                            public int compare(String one, String two) {
                                int idx1 = Const.indexOfString(one, fNaturalOrder);
                                int idx2 = Const.indexOfString(two, fNaturalOrder);
                                return idx1 - idx2;
                            }
                        });
                    }
                }
            }
            if ((listeners = this.listeners.get(pluginType)) != null) {
                for (PluginTypeListener listener : listeners) {
                    if (changed) {
                        listener.pluginChanged(plugin);
                        continue;
                    }
                    listener.pluginAdded(plugin);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
            PluginRegistry pluginRegistry = this;
            synchronized (pluginRegistry) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<? extends PluginTypeInterface>> getPluginTypes() {
        this.lock.readLock().lock();
        try {
            List<Class<? extends PluginTypeInterface>> list = Collections.unmodifiableList(new ArrayList<Class<? extends PluginTypeInterface>>(this.pluginMap.keySet()));
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PluginInterface, K extends PluginTypeInterface> List<T> getPlugins(Class<K> type) {
        HashSet<PluginInterface> set = new HashSet<PluginInterface>();
        this.lock.readLock().lock();
        try {
            for (Class<? extends PluginTypeInterface> pi : this.pluginMap.keySet()) {
                List<PluginInterface> mapList;
                if (!Const.classIsOrExtends(pi, type) || (mapList = this.pluginMap.get(pi)) == null) continue;
                Iterator<PluginInterface> i$ = mapList.iterator();
                while (i$.hasNext()) {
                    PluginInterface p;
                    PluginInterface t = p = i$.next();
                    set.add(t);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return new ArrayList(set);
    }

    public PluginInterface getPlugin(Class<? extends PluginTypeInterface> pluginType, String id) {
        if (Const.isEmpty(id)) {
            return null;
        }
        for (PluginInterface plugin : this.getPlugins(pluginType)) {
            if (!plugin.matches(id)) continue;
            return plugin;
        }
        return null;
    }

    public <T extends PluginTypeInterface> List<PluginInterface> getPluginsByCategory(Class<T> pluginType, String pluginCategory) {
        ArrayList<PluginInterface> plugins = new ArrayList<PluginInterface>();
        for (PluginInterface verify : this.getPlugins(pluginType)) {
            if (verify.getCategory() == null || !verify.getCategory().equals(pluginCategory)) continue;
            plugins.add(verify);
        }
        return Collections.unmodifiableList(plugins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCategories(Class<? extends PluginTypeInterface> pluginType) {
        this.lock.readLock().lock();
        try {
            List<String> list = this.categoryMap.get(pluginType);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Object loadClass(PluginInterface plugin) throws KettlePluginException {
        return this.loadClass(plugin, plugin.getMainType());
    }

    public <T> T loadClass(Class<? extends PluginTypeInterface> pluginType, Object object, Class<T> classType) throws KettlePluginException {
        PluginInterface plugin = this.getPlugin(pluginType, object);
        if (plugin == null) {
            return null;
        }
        return this.loadClass(plugin, classType);
    }

    public <T> T loadClass(Class<? extends PluginTypeInterface> pluginType, String pluginId, Class<T> classType) throws KettlePluginException {
        PluginInterface plugin = this.getPlugin(pluginType, pluginId);
        if (plugin == null) {
            return null;
        }
        return this.loadClass(plugin, classType);
    }

    private KettleURLClassLoader createClassLoader(PluginInterface plugin) throws MalformedURLException, UnsupportedEncodingException {
        List<String> jarfiles = plugin.getLibraries();
        URL[] urls = new URL[jarfiles.size()];
        for (int i = 0; i < jarfiles.size(); ++i) {
            File jarfile = new File(jarfiles.get(i));
            urls[i] = new URL(URLDecoder.decode(jarfile.toURI().toURL().toString(), "UTF-8"));
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        String[] patterns = this.parentClassloaderPatternMap.get(plugin);
        if (patterns != null) {
            return new KettleSelectiveParentFirstClassLoader(urls, classLoader, plugin.getDescription(), patterns);
        }
        return new KettleURLClassLoader(urls, classLoader, plugin.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T loadClass(PluginInterface plugin, Class<T> pluginClass) throws KettlePluginException {
        if (plugin == null) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.NoValidStepOrPlugin.PLUGINREGISTRY001", new String[0]));
        }
        if (plugin instanceof ClassLoadingPluginInterface) {
            return ((ClassLoadingPluginInterface)((Object)plugin)).loadClass(pluginClass);
        }
        String className = plugin.getClassMap().get(pluginClass);
        if (className == null) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.NoValidClassRequested.PLUGINREGISTRY002", pluginClass.getName()));
        }
        try {
            Class<?> cl;
            if (plugin.isNativePlugin()) {
                cl = Class.forName(className);
            } else {
                URLClassLoader ucl = null;
                this.lock.writeLock().lock();
                try {
                    if (plugin.isSeparateClassLoaderNeeded()) {
                        ucl = this.createClassLoader(plugin);
                    } else {
                        Map<PluginInterface, URLClassLoader> classLoaders = this.classLoaderMap.get(plugin.getPluginType());
                        if (classLoaders == null) {
                            classLoaders = new HashMap<PluginInterface, URLClassLoader>();
                            this.classLoaderMap.put(plugin.getPluginType(), classLoaders);
                        } else {
                            ucl = classLoaders.get(plugin);
                        }
                        if (ucl == null) {
                            if (plugin.getPluginDirectory() != null) {
                                ucl = this.folderBasedClassLoaderMap.get(plugin.getPluginDirectory().toString());
                                if (ucl == null) {
                                    ucl = this.createClassLoader(plugin);
                                    classLoaders.put(plugin, ucl);
                                    this.folderBasedClassLoaderMap.put(plugin.getPluginDirectory().toString(), ucl);
                                }
                            } else {
                                ucl = classLoaders.get(plugin);
                                if (ucl == null) {
                                    ucl = this.createClassLoader(plugin);
                                    classLoaders.put(plugin, ucl);
                                }
                            }
                        }
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
                cl = ucl.loadClass(className);
            }
            return (T)cl.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.ClassNotFound.PLUGINREGISTRY003", new String[0]), e);
        }
        catch (InstantiationException e) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.UnableToInstantiateClass.PLUGINREGISTRY004", new String[0]), e);
        }
        catch (IllegalAccessException e) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.IllegalAccessToClass.PLUGINREGISTRY005", new String[0]), e);
        }
        catch (MalformedURLException e) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.MalformedURL.PLUGINREGISTRY006", new String[0]), e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.UnExpectedErrorLoadingClass.PLUGINREGISTRY007", new String[0]), e);
        }
    }

    public static synchronized void addPluginType(PluginTypeInterface type) {
        pluginTypes.add(type);
    }

    public static List<PluginTypeInterface> getAddedPluginTypes() {
        return Collections.unmodifiableList(pluginTypes);
    }

    public static synchronized void init() throws KettlePluginException {
        PluginRegistry.init(false);
    }

    public static synchronized void init(boolean keepCache) throws KettlePluginException {
        PluginRegistry registry = PluginRegistry.getInstance();
        log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_REGISTER_EXTENSIONS_START, new long[0]);
        try {
            registry.registerType(PluginRegistryPluginType.getInstance());
            List plugins = registry.getPlugins(PluginRegistryPluginType.class);
            for (PluginInterface extensionPlugin : plugins) {
                log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_REGISTER_EXTENSION_START, extensionPlugin.getName(), new long[0]);
                PluginRegistryExtension extension = (PluginRegistryExtension)registry.loadClass(extensionPlugin);
                extension.init(registry);
                extensions.add(extension);
                log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_REGISTER_EXTENSIONS_STOP, extensionPlugin.getName(), new long[0]);
            }
        }
        catch (KettlePluginException e) {
            e.printStackTrace();
        }
        log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_REGISTER_EXTENSIONS_STOP, new long[0]);
        log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_PLUGIN_REGISTRATION_START, new long[0]);
        for (PluginTypeInterface pluginType : pluginTypes) {
            log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_PLUGIN_TYPE_REGISTRATION_START, pluginType.getName(), new long[0]);
            registry.registerType(pluginType);
            log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_PLUGIN_TYPE_REGISTRATION_STOP, pluginType.getName(), new long[0]);
        }
        log.snap((MetricsInterface)Metrics.METRIC_PLUGIN_REGISTRY_PLUGIN_REGISTRATION_STOP, new long[0]);
        if (!keepCache) {
            JarFileCache.getInstance().clear();
        }
    }

    private void registerType(PluginTypeInterface pluginType) throws KettlePluginException {
        this.registerPluginType(pluginType.getClass());
        long startScan = System.currentTimeMillis();
        pluginType.searchPlugins();
        for (PluginRegistryExtension ext : extensions) {
            ext.searchForType(pluginType);
        }
        ArrayList<String> pluginClassNames = new ArrayList<String>();
        String pluginClasses = EnvUtil.getSystemProperty("KETTLE_PLUGIN_CLASSES");
        if (!Const.isEmpty(pluginClasses)) {
            String[] classNames;
            for (String className : classNames = pluginClasses.split(",")) {
                if (pluginClassNames.contains(className)) continue;
                pluginClassNames.add(className);
            }
        }
        for (String className : pluginClassNames) {
            try {
                PluginAnnotationType annotationType = pluginType.getClass().getAnnotation(PluginAnnotationType.class);
                if (annotationType != null) {
                    Class<? extends Annotation> annotationClass = annotationType.value();
                    Class<?> clazz = Class.forName(className);
                    Annotation annotation = clazz.getAnnotation(annotationClass);
                    if (annotation != null) {
                        pluginType.handlePluginAnnotation(clazz, annotation, new ArrayList<String>(), true, null);
                        LogChannel.GENERAL.logBasic("Plugin class " + className + " registered for plugin type '" + pluginType.getName() + "'");
                        continue;
                    }
                    if (!KettleLogStore.isInitialized() || !LogChannel.GENERAL.isDebug()) continue;
                    LogChannel.GENERAL.logDebug("Plugin class " + className + " doesn't contain annotation for plugin type '" + pluginType.getName() + "'");
                    continue;
                }
                if (!KettleLogStore.isInitialized() || !LogChannel.GENERAL.isDebug()) continue;
                LogChannel.GENERAL.logDebug("Plugin class " + className + " doesn't contain valid class for plugin type '" + pluginType.getName() + "'");
            }
            catch (Exception e) {
                if (!KettleLogStore.isInitialized()) continue;
                LogChannel.GENERAL.logError("Error registring plugin class from KETTLE_PLUGIN_CLASSES: " + className + Const.CR + Const.getStackTracker(e));
            }
        }
        if (LogChannel.GENERAL.isDetailed()) {
            LogChannel.GENERAL.logDetailed("Registered " + this.getPlugins(pluginType.getClass()).size() + " plugins of type '" + pluginType.getName() + "' in " + (System.currentTimeMillis() - startScan) + "ms.");
        }
    }

    public String getPluginId(Object pluginClass) {
        for (Class<? extends PluginTypeInterface> pluginType : this.getPluginTypes()) {
            String id = this.getPluginId(pluginType, pluginClass);
            if (id == null) continue;
            return id;
        }
        return null;
    }

    public String getPluginId(Class<? extends PluginTypeInterface> pluginType, Object pluginClass) {
        String className = pluginClass.getClass().getName();
        for (PluginInterface plugin : this.getPlugins(pluginType)) {
            for (String check : plugin.getClassMap().values()) {
                if (check == null || !check.equals(className)) continue;
                return plugin.getIds()[0];
            }
        }
        for (PluginRegistryExtension ext : extensions) {
            String id = ext.getPluginId(pluginType, pluginClass);
            if (id == null) continue;
            return id;
        }
        return null;
    }

    public PluginInterface getPlugin(Class<? extends PluginTypeInterface> pluginType, Object pluginClass) {
        String pluginId = this.getPluginId(pluginType, pluginClass);
        if (pluginId == null) {
            return null;
        }
        return this.getPlugin(pluginType, pluginId);
    }

    public PluginInterface findPluginWithName(Class<? extends PluginTypeInterface> pluginType, String pluginName) {
        for (PluginInterface plugin : this.getPlugins(pluginType)) {
            if (!plugin.getName().equals(pluginName)) continue;
            return plugin;
        }
        return null;
    }

    public PluginInterface findPluginWithDescription(Class<? extends PluginTypeInterface> pluginType, String pluginDescription) {
        for (PluginInterface plugin : this.getPlugins(pluginType)) {
            if (!plugin.getDescription().equals(pluginDescription)) continue;
            return plugin;
        }
        return null;
    }

    public PluginInterface findPluginWithId(Class<? extends PluginTypeInterface> pluginType, String pluginId) {
        for (PluginInterface plugin : this.getPlugins(pluginType)) {
            if (!plugin.matches(pluginId)) continue;
            return plugin;
        }
        return null;
    }

    public List<String> getPluginPackages(Class<? extends PluginTypeInterface> pluginType) {
        ArrayList<String> list = new ArrayList<String>();
        for (PluginInterface plugin : this.getPlugins(pluginType)) {
            for (String className : plugin.getClassMap().values()) {
                String packageName;
                int lastIndex = className.lastIndexOf(".");
                if (lastIndex <= -1 || list.contains(packageName = className.substring(0, lastIndex))) continue;
                list.add(packageName);
            }
        }
        Collections.sort(list);
        return list;
    }

    private RowMetaInterface getPluginInformationRowMeta() {
        RowMeta row = new RowMeta();
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.Type.Label", new String[0]), 2));
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.ID.Label", new String[0]), 2));
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.Name.Label", new String[0]), 2));
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.Description.Label", new String[0]), 2));
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.Libraries.Label", new String[0]), 2));
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.ImageFile.Label", new String[0]), 2));
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.ClassName.Label", new String[0]), 2));
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.Category.Label", new String[0]), 2));
        return row;
    }

    public RowBuffer getPluginInformation(Class<? extends PluginTypeInterface> pluginType) throws KettlePluginException {
        RowBuffer rowBuffer = new RowBuffer(this.getPluginInformationRowMeta());
        for (PluginInterface plugin : this.getPlugins(pluginType)) {
            Object[] row = new Object[this.getPluginInformationRowMeta().size()];
            int rowIndex = 0;
            row[rowIndex++] = this.getPluginType(plugin.getPluginType()).getName();
            row[rowIndex++] = plugin.getIds()[0];
            row[rowIndex++] = plugin.getName();
            row[rowIndex++] = Const.NVL(plugin.getDescription(), "");
            row[rowIndex++] = Const.isEmpty(plugin.getLibraries()) ? "" : plugin.getLibraries().toString();
            row[rowIndex++] = Const.NVL(plugin.getImageFile(), "");
            row[rowIndex++] = plugin.getClassMap().values().toString();
            row[rowIndex++] = Const.NVL(plugin.getCategory(), "");
            rowBuffer.getBuffer().add(row);
        }
        return rowBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getClass(PluginInterface plugin, String className) throws KettlePluginException {
        try {
            if (plugin.isNativePlugin()) {
                return (T)Class.forName(className);
            }
            URLClassLoader ucl = null;
            this.lock.writeLock().lock();
            try {
                Map<PluginInterface, URLClassLoader> classLoaders = this.classLoaderMap.get(plugin.getPluginType());
                if (classLoaders == null) {
                    classLoaders = new HashMap<PluginInterface, URLClassLoader>();
                    this.classLoaderMap.put(plugin.getPluginType(), classLoaders);
                } else {
                    ucl = classLoaders.get(plugin);
                }
                if (ucl == null && plugin.getPluginDirectory() != null) {
                    ucl = this.folderBasedClassLoaderMap.get(plugin.getPluginDirectory().toString());
                    classLoaders.put(plugin, ucl);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            if (ucl == null) {
                throw new KettlePluginException("Unable to find class loader for plugin: " + plugin);
            }
            return (T)ucl.loadClass(className);
        }
        catch (Exception e) {
            throw new KettlePluginException("Unexpected error loading class with name: " + className, e);
        }
    }

    public <T> T getClass(PluginInterface plugin, T classType) throws KettlePluginException {
        String className = plugin.getClassMap().get(classType);
        return (T)this.getClass(plugin, (T)className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClassLoader getClassLoader(PluginInterface plugin) throws KettlePluginException {
        if (plugin == null) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.NoValidStepOrPlugin.PLUGINREGISTRY001", new String[0]));
        }
        try {
            if (plugin.isNativePlugin()) {
                return this.getClass().getClassLoader();
            }
            Object var2_2 = null;
            this.lock.writeLock().lock();
            try {
                void var2_5;
                void var2_12;
                if (plugin.isSeparateClassLoaderNeeded()) {
                    KettleURLClassLoader kettleURLClassLoader = this.createClassLoader(plugin);
                    return var2_12;
                }
                Map<PluginInterface, URLClassLoader> classLoaders = this.classLoaderMap.get(plugin.getPluginType());
                if (classLoaders == null) {
                    classLoaders = new HashMap<PluginInterface, URLClassLoader>();
                    this.classLoaderMap.put(plugin.getPluginType(), classLoaders);
                } else {
                    URLClassLoader uRLClassLoader = classLoaders.get(plugin);
                }
                if (var2_5 != null) return var2_12;
                if (!Const.isEmpty(plugin.getClassLoaderGroup())) {
                    URLClassLoader uRLClassLoader = this.classLoaderGroupsMap.get(plugin.getClassLoaderGroup());
                    if (uRLClassLoader != null) return var2_12;
                    KettleURLClassLoader kettleURLClassLoader = this.createClassLoader(plugin);
                    classLoaders.put(plugin, kettleURLClassLoader);
                    this.classLoaderGroupsMap.put(plugin.getClassLoaderGroup(), kettleURLClassLoader);
                    return var2_12;
                }
                if (plugin.getPluginDirectory() != null) {
                    URLClassLoader uRLClassLoader = this.folderBasedClassLoaderMap.get(plugin.getPluginDirectory().toString());
                    if (uRLClassLoader != null) return var2_12;
                    KettleURLClassLoader kettleURLClassLoader = this.createClassLoader(plugin);
                    classLoaders.put(plugin, kettleURLClassLoader);
                    this.folderBasedClassLoaderMap.put(plugin.getPluginDirectory().toString(), kettleURLClassLoader);
                    return var2_12;
                }
                URLClassLoader uRLClassLoader = classLoaders.get(plugin);
                if (uRLClassLoader != null) return var2_12;
                if (plugin.getLibraries().size() == 0 && plugin instanceof ClassLoadingPluginInterface) {
                    ClassLoader classLoader = ((ClassLoadingPluginInterface)((Object)plugin)).getClassLoader();
                    return classLoader;
                }
                KettleURLClassLoader kettleURLClassLoader = this.createClassLoader(plugin);
                classLoaders.put(plugin, kettleURLClassLoader);
                return var2_12;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.MalformedURL.PLUGINREGISTRY006", new String[0]), malformedURLException);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.UnExpectedCreatingClassLoader.PLUGINREGISTRY008", new String[0]), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PluginTypeInterface> void addPluginListener(Class<T> typeToTrack, PluginTypeListener listener) {
        this.lock.writeLock().lock();
        try {
            List<PluginTypeListener> list = this.listeners.get(typeToTrack);
            if (list == null) {
                list = new ArrayList<PluginTypeListener>();
                this.listeners.put(typeToTrack, list);
            }
            if (!list.contains(listener)) {
                list.add(listener);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassLoader(URLClassLoader ucl, PluginInterface plugin) {
        this.lock.writeLock().lock();
        try {
            Map<PluginInterface, URLClassLoader> classLoaders = this.classLoaderMap.get(plugin.getPluginType());
            if (classLoaders == null) {
                classLoaders = new HashMap<PluginInterface, URLClassLoader>();
                this.classLoaderMap.put(plugin.getPluginType(), classLoaders);
            }
            classLoaders.put(plugin, ucl);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public PluginTypeInterface getPluginType(Class<? extends PluginTypeInterface> pluginTypeClass) throws KettlePluginException {
        try {
            Method method = pluginTypeClass.getMethod("getInstance", new Class[0]);
            PluginTypeInterface pluginTypeInterface = (PluginTypeInterface)method.invoke(null, new Object[0]);
            return pluginTypeInterface;
        }
        catch (Exception e) {
            throw new KettlePluginException("Unable to get instance of plugin type: " + pluginTypeClass.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PluginInterface> findPluginsByFolder(URL folder) {
        String path = folder.getPath();
        try {
            path = folder.toURI().normalize().getPath();
        }
        catch (URISyntaxException e) {
            log.logError(e.getLocalizedMessage(), e);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        ArrayList<PluginInterface> result = new ArrayList<PluginInterface>();
        this.lock.readLock().lock();
        try {
            for (List<PluginInterface> typeInterfaces : this.pluginMap.values()) {
                for (PluginInterface plugin : typeInterfaces) {
                    URL pluginFolder = plugin.getPluginDirectory();
                    try {
                        if (pluginFolder == null || !pluginFolder.toURI().normalize().getPath().startsWith(path)) continue;
                        result.add(plugin);
                    }
                    catch (URISyntaxException e) {
                        log.logError(e.getLocalizedMessage(), e);
                    }
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }
}

