/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

public class Mod {
    public static final short NONE = 0;
    public static final short PUBLIC = 1;
    public static final short PRIVATE = 2;
    public static final short PROTECTED = 4;
    public static final short PACKAGE = 0;
    public static final short PPP = 7;
    public static final short STATIC = 8;
    public static final short FINAL = 16;
    public static final short SUPER = 32;
    public static final short SYNCHRONIZED = 32;
    public static final short VOLATILE = 64;
    public static final short TRANSIENT = 128;
    public static final short NATIVE = 256;
    public static final short INTERFACE = 512;
    public static final short ABSTRACT = 1024;
    public static final short STRICTFP = 2048;
    public static final short SYNTHETIC = 4096;
    public static final short ANNOTATION = 8192;
    public static final short ENUM = 16384;
    private static final Object[] mappings = new Object[]{"public", new Short(1), "private", new Short(2), "protected", new Short(4), "static", new Short(8), "final", new Short(16), "synchronized", new Short(32), "volatile", new Short(64), "transient", new Short(128), "native", new Short(256), "interface", new Short(512), "abstract", new Short(1024), "strictfp", new Short(2048)};

    private Mod() {
    }

    public static boolean isPublicAccess(short sh) {
        return (sh & 7) == 1;
    }

    public static boolean isPrivateAccess(short sh) {
        return (sh & 7) == 2;
    }

    public static boolean isProtectedAccess(short sh) {
        return (sh & 7) == 4;
    }

    public static boolean isPackageAccess(short sh) {
        return (sh & 7) == 0;
    }

    public static short changeAccess(short sh, short newAccess) {
        return (short)(sh & 0xFFFFFFF8 | newAccess);
    }

    public static String shortToString(short sh) {
        String res = "";
        for (int i = 0; i < mappings.length; i += 2) {
            if ((sh & (Short)mappings[i + 1]) == 0) continue;
            if (res.length() > 0) {
                res = res + ' ';
            }
            res = res + (String)mappings[i];
        }
        return res;
    }
}

