/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.janino.JavaSourceClassLoader;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.enumerator.EnumeratorSet;
import org.codehaus.janino.util.resource.DirectoryResourceCreator;
import org.codehaus.janino.util.resource.DirectoryResourceFinder;
import org.codehaus.janino.util.resource.PathResourceFinder;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceCreator;
import org.codehaus.janino.util.resource.ResourceFinder;

public class CachingJavaSourceClassLoader
extends JavaSourceClassLoader {
    private final ResourceFinder classFileCacheResourceFinder;
    private final ResourceCreator classFileCacheResourceCreator;
    private final ResourceFinder sourceFinder;

    public CachingJavaSourceClassLoader(ClassLoader parentClassLoader, File[] optionalSourcePath, String optionalCharacterEncoding, File cacheDirectory, EnumeratorSet debuggingInformation) {
        this(parentClassLoader, optionalSourcePath == null ? new DirectoryResourceFinder(new File(".")) : new PathResourceFinder(optionalSourcePath), optionalCharacterEncoding, new DirectoryResourceFinder(cacheDirectory), new DirectoryResourceCreator(cacheDirectory), debuggingInformation);
    }

    public CachingJavaSourceClassLoader(ClassLoader parentClassLoader, ResourceFinder sourceFinder, String optionalCharacterEncoding, ResourceFinder classFileCacheResourceFinder, ResourceCreator classFileCacheResourceCreator, EnumeratorSet debuggingInformation) {
        super(parentClassLoader, sourceFinder, optionalCharacterEncoding, debuggingInformation);
        this.classFileCacheResourceFinder = classFileCacheResourceFinder;
        this.classFileCacheResourceCreator = classFileCacheResourceCreator;
        this.sourceFinder = sourceFinder;
    }

    protected Map generateBytecodes(String className) throws ClassNotFoundException {
        Map bytecodes;
        Resource classFileResource = this.classFileCacheResourceFinder.findResource(ClassFile.getClassFileResourceName(className));
        if (classFileResource != null) {
            Resource sourceResource = this.sourceFinder.findResource(ClassFile.getSourceResourceName(className));
            if (sourceResource == null) {
                return null;
            }
            if (sourceResource.lastModified() < classFileResource.lastModified()) {
                byte[] bytecode;
                try {
                    bytecode = CachingJavaSourceClassLoader.readResource(classFileResource);
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("Reading class file from \"" + classFileResource + "\"", ex);
                }
                HashMap<String, byte[]> m = new HashMap<String, byte[]>();
                m.put(className, bytecode);
                return m;
            }
        }
        if ((bytecodes = super.generateBytecodes(className)) == null) {
            return null;
        }
        Iterator it = bytecodes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String className2 = (String)me.getKey();
            byte[] bytecode = (byte[])me.getValue();
            try {
                CachingJavaSourceClassLoader.writeResource(this.classFileCacheResourceCreator, ClassFile.getClassFileResourceName(className2), bytecode);
            }
            catch (IOException ex) {
                throw new ClassNotFoundException("Writing class file to \"" + ClassFile.getClassFileResourceName(className2) + "\"", ex);
            }
        }
        return bytecodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readResource(Resource r) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        InputStream is = r.open();
        try {
            int cnt;
            while ((cnt = is.read(buffer)) != -1) {
                baos.write(buffer, 0, cnt);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {}
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResource(ResourceCreator resourceCreator, String resourceName, byte[] data) throws IOException {
        OutputStream os = resourceCreator.createResource(resourceName);
        try {
            os.write(data);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException ex) {}
        }
    }
}

