/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.csvinspector;

import de.destatis.core.connect.util.Contract;

public class CsvInspectionProblem {
    public static final ProblemClass WORST_PROBLEM_CLASS = ProblemClass.FATAL;
    private final ProblemClass problemClass;
    private final ProblemType problemType;
    private final String text;
    private final String condition;
    private final int declno;
    private final int recno;
    private final String varname;
    private final int line;
    private final int column;

    public CsvInspectionProblem(ProblemClass problemClass, ProblemType problemType, String text, String condition, int declno, int recno, String varname, int line, int column) {
        Contract.verify((problemClass != null ? 1 : 0) != 0, (String)"Problemklasse muss ungleich null sein.");
        Contract.verify((declno > 0 || declno == -1 ? 1 : 0) != 0, (String)"Meldungsnummer muss eine positive Zahl sein oder -1.");
        Contract.verify((recno > 0 || recno == -1 ? 1 : 0) != 0, (String)"Satznummer muss eine positive Zahl sein oder -1.");
        Contract.verify((declno > 0 || recno == -1 ? 1 : 0) != 0, (String)"Meldungsnummer muss eine positive Zahl sein");
        Contract.verify((line > 0 || line == -1 ? 1 : 0) != 0, (String)"Zeilennummer muss gr\u00f6\u00dfer 0 oder -1 sein.");
        Contract.verify((column > 0 || column == -1 ? 1 : 0) != 0, (String)"Spaltennummer muss gr\u00f6\u00dfer 0 oder -1 sein.");
        this.problemClass = problemClass;
        this.problemType = problemType;
        this.text = text;
        this.condition = condition;
        this.declno = declno;
        this.recno = recno;
        this.varname = varname;
        this.line = line;
        this.column = column;
    }

    public ProblemClass getProblemClass() {
        return this.problemClass;
    }

    public ProblemType getProblemType() {
        return this.problemType;
    }

    public String getComment() {
        return this.text;
    }

    public String getCondition() {
        return this.condition;
    }

    public int getDeclarationNo() {
        return this.declno;
    }

    public int getRecordNo() {
        return this.recno;
    }

    public String getVariableName() {
        return this.varname;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("Klasse:             ");
        switch (this.problemClass) {
            case INFO: {
                buffer.append("Information / Hinweis");
                break;
            }
            case WARN: {
                buffer.append("Warnung");
                break;
            }
            case ERROR: {
                buffer.append("Fehler");
                break;
            }
            case FATAL: {
                buffer.append("Nicht behebbarer Fehler");
            }
        }
        buffer.append(lineSeparator);
        buffer.append("Erl\u00e4uterungstext:   ");
        buffer.append(this.text);
        if (this.condition != null && this.condition.length() > 0) {
            buffer.append(lineSeparator);
            buffer.append("Bedingung:          ");
            buffer.append(this.condition);
        }
        if (this.declno != -1) {
            buffer.append(lineSeparator);
            buffer.append("Meldungsnummer:     ");
            buffer.append(this.declno);
        }
        if (this.recno != -1) {
            buffer.append(lineSeparator);
            buffer.append("Satznummer:         ");
            buffer.append(this.recno);
        }
        if (this.varname != null && this.varname.length() > 0) {
            buffer.append(lineSeparator);
            buffer.append("Variablenname:      ");
            buffer.append(this.varname);
        }
        if (this.line != -1) {
            buffer.append(lineSeparator);
            buffer.append("Zeile:              ");
            buffer.append(this.line);
        }
        if (this.column != -1) {
            buffer.append(lineSeparator);
            buffer.append("Spalte:             ");
            buffer.append(this.column);
        }
        return buffer.toString();
    }

    public static enum ProblemType {
        SDF_FORMAT_ERROR,
        UNSUPPORTED_CONDITION_FORMAT,
        ILLEGAL_HELP_FEATURE,
        INVALID_REQUIRED_HELP_FEATURE_VALUE,
        INVALID_OPTIONAL_HELP_FEATURE_VALUE,
        MISSING_HELP_FEATURE,
        MISSING_CONDITIONAL_HELP_FEATURE,
        ILLEGAL_CONDITIONAL_HELP_FEATURE,
        ILLEGAL_FEATURE,
        ILLEGAL_FEATURE_GROUP,
        INVALID_REQUIRED_FEATURE_VALUE,
        INVALID_OPTIONAL_FEATURE_VALUE,
        MISSING_FEATURE,
        MISSING_CONDITIONAL_FEATURE,
        ILLEGAL_CONDITIONAL_FEATURE,
        INVALID_RECORD,
        INVALID_NUMBER_OF_RECORDS,
        NO_RECORDS,
        INVALID_NUMBER_OF_FEATURE_GROUPS,
        MISSING_INDEX_FEATURE,
        INVALID_INDEX_FEATURE,
        DUPLICATE_INDEX_FEATURE,
        MISSING_FEATURE_GROUP,
        MISSING_CONDITIONAL_FEATURE_GROUP,
        ILLEGAL_CONDITIONAL_FEATURE_GROUP,
        INVALID_UNIT_ID,
        COLLECTOR_CORRECTION;

    }

    public static enum ProblemClass {
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

