/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.lang.IfxToJavaType;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;

class IfxCryptoUtils {
    static final int BYTESHIFT = 8;
    static final int IFX_INT4_SIZE = 4;
    static final int IFX_INT3_SIZE = 3;
    static final int IFX_INT2_SIZE = 2;
    static final int IFX_INT1_SIZE = 1;
    static final int IFX_UINT4_SIZE = 4;

    IfxCryptoUtils() {
    }

    static byte[] JavaToIfxInt(int i, int array_size) {
        byte[] b = new byte[array_size];
        for (int k = 0; k <= array_size - 1; ++k) {
            b[k] = (byte)(i >> 8 * (array_size - 1 - k));
        }
        return b;
    }

    static byte[] JavaToIfx2Int(int i, int array_size) {
        byte[] b = new byte[array_size];
        int shift_byte = 2;
        for (int k = 0; k <= shift_byte - 1; ++k) {
            b[k] = (byte)(i >> 8 * (shift_byte - 1 - k));
        }
        return b;
    }

    static byte[] JavaToIfxLong(long i, int array_size) {
        byte[] b = new byte[array_size];
        for (int k = 0; k <= array_size - 1; ++k) {
            b[k] = (byte)(i >> 8 * (array_size - 1 - k));
        }
        return b;
    }

    static int Ifx4ToJavaInt(byte[] b, int offset) {
        return IfxToJavaType.IfxToJavaInt(b, offset);
    }

    static int Ifx4ToJavaInt(byte[] b) {
        return IfxCryptoUtils.Ifx4ToJavaInt(b, 0);
    }

    static long Ifx4ToJavaLong(byte[] b, int offset) {
        long i = IfxCryptoUtils.widenByte(b[0 + offset]);
        i = (((i << 8) + (long)IfxCryptoUtils.widenByte(b[1 + offset]) << 8) + (long)IfxCryptoUtils.widenByte(b[2 + offset]) << 8) + (long)IfxCryptoUtils.widenByte(b[3 + offset]);
        return i;
    }

    static long Ifx4ToJavaLong(byte[] b) {
        return IfxCryptoUtils.Ifx4ToJavaLong(b, 0);
    }

    static int Ifx3ToJavaInt(byte[] b, int offset) {
        int i = IfxCryptoUtils.widenByte(b[0 + offset]);
        i = ((i << 8) + IfxCryptoUtils.widenByte(b[1 + offset]) << 8) + IfxCryptoUtils.widenByte(b[2 + offset]);
        return i;
    }

    static int Ifx3ToJavaInt(byte[] b) {
        return IfxCryptoUtils.Ifx3ToJavaInt(b, 0);
    }

    static int Ifx2ToJavaInt(byte[] b, int offset) {
        int i = IfxCryptoUtils.widenByte(b[0 + offset]);
        i = (i << 8) + IfxCryptoUtils.widenByte(b[1 + offset]);
        return i;
    }

    static int Ifx2ToJavaInt(byte[] b) {
        return IfxCryptoUtils.Ifx2ToJavaInt(b, 0);
    }

    static int Ifx1ToJavaInt(byte[] b, int offset) {
        short i = IfxCryptoUtils.widenByte(b[0 + offset]);
        return i;
    }

    private static final short widenByte(byte b) {
        return (short)((short)b & 0xFF);
    }

    private static int readInt3(ByteArrayInputStream bis) {
        return IfxCryptoUtils.Ifx3ToJavaInt(IfxCryptoUtils.readByteInputStream(bis, 3));
    }

    private static int readInt4(ByteArrayInputStream bis) {
        return IfxCryptoUtils.Ifx4ToJavaInt(IfxCryptoUtils.readByteInputStream(bis, 4));
    }

    private static int readInt2(ByteArrayInputStream bis) {
        return IfxCryptoUtils.Ifx2ToJavaInt(IfxCryptoUtils.readByteInputStream(bis, 2));
    }

    private static int readInt1(ByteArrayInputStream bis) {
        return IfxCryptoUtils.Ifx2ToJavaInt(IfxCryptoUtils.readByteInputStream(bis, 1));
    }

    static long readUInt4(ByteArrayInputStream bis) {
        return IfxCryptoUtils.Ifx4ToJavaLong(IfxCryptoUtils.readByteInputStream(bis, 4));
    }

    static long readUInt4(ByteArrayInputStream bis, int byteLength) {
        switch (byteLength) {
            case 4: {
                return IfxCryptoUtils.readUInt4(bis);
            }
        }
        return IfxCryptoUtils.readUInt4(bis);
    }

    static int readInt(ByteArrayInputStream bis, int byteLength) {
        switch (byteLength) {
            case 1: {
                return IfxCryptoUtils.readInt1(bis);
            }
            case 2: {
                return IfxCryptoUtils.readInt2(bis);
            }
            case 3: {
                return IfxCryptoUtils.readInt3(bis);
            }
            case 4: {
                return IfxCryptoUtils.readInt4(bis);
            }
        }
        return IfxCryptoUtils.readInt4(bis);
    }

    static byte[] readByteInputStream(ByteArrayInputStream bis, int length) {
        byte[] tmp = new byte[length];
        bis.read(tmp, 0, tmp.length);
        return tmp;
    }

    static byte[] readFullyByteInputStream(ByteArrayInputStream bis) {
        byte[] tempArray = new byte[bis.available()];
        bis.read(tempArray, 0, bis.available());
        bis.reset();
        return tempArray;
    }

    static void stringBufferToLowerCase(StringBuffer buff) {
        String lowCase = buff.toString().toLowerCase();
        buff.replace(0, buff.length(), lowCase);
    }

    static boolean isLengthZero(StringBuffer buff) {
        return buff.length() <= 0;
    }

    static void removeWhiteSpaces(StringBuffer buff) {
        for (int i = 0; i < buff.length(); ++i) {
            if (!Character.isWhitespace(buff.charAt(i))) continue;
            buff.deleteCharAt(i);
            --i;
        }
    }

    static long getCurrentTimeinSec() {
        return System.currentTimeMillis() / 1000L;
    }

    static boolean areArrayElemntsEqual(byte[] ar1, int off1, byte[] ar2, int off2, int numBytesToCompare) {
        try {
            if (ar1.length < off1 + numBytesToCompare) {
                return false;
            }
            if (ar2.length < off2 + numBytesToCompare) {
                return false;
            }
            for (int k = 0; k < numBytesToCompare; ++k) {
                if (ar1[off1 + k] == ar2[off2 + k]) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static byte[] bigIntegerToBinary(BigInteger bignum) {
        byte[] byteArray = bignum.toByteArray();
        if (byteArray[0] != 0) {
            return byteArray;
        }
        byte[] retVal = new byte[byteArray.length - 1];
        System.arraycopy(byteArray, 1, retVal, 0, retVal.length);
        return retVal;
    }

    static BigInteger binaryToBigInteger(byte[] binary) {
        return new BigInteger(1, binary);
    }

    static byte[] createCopy(byte[] buff) {
        if (buff == null) {
            return null;
        }
        byte[] copy = new byte[buff.length];
        System.arraycopy(buff, 0, copy, 0, copy.length);
        return copy;
    }

    static boolean isFlagSet(int setFlags, int flag) {
        return (setFlags & flag) > 0;
    }

    static boolean isClassInClasspath(String classname) {
        try {
            if (Class.forName(classname) != null) {
                // empty if block
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

