/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.BaseTable;
import org.hsqldb.Cache;
import org.hsqldb.CachedDataRow;
import org.hsqldb.CachedRow;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.NumberSequence;
import org.hsqldb.Parser;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.store.ValuePool;

public class Table
extends BaseTable {
    public static final int SYSTEM_TABLE = 0;
    public static final int SYSTEM_SUBQUERY = 1;
    public static final int TEMP_TABLE = 2;
    public static final int MEMORY_TABLE = 3;
    public static final int CACHED_TABLE = 4;
    public static final int TEMP_TEXT_TABLE = 5;
    public static final int TEXT_TABLE = 6;
    public static final int VIEW = 7;
    static final int SYSTEM_VIEW = 8;
    static final String DEFAULT_PK = "";
    public HashMappedList columnList;
    private HsqlArrayList indexList;
    private int[] primaryKeyCols;
    int[] bestRowIdentifierCols;
    boolean bestRowIdentifierStrict;
    int[] bestIndexForColumn;
    boolean needsRowID;
    int[] nullRowIDCols;
    int identityColumn;
    NumberSequence identitySequence;
    NumberSequence rowIdSequence;
    Constraint[] constraintList;
    HsqlArrayList[] triggerLists;
    private int[] colTypes;
    private int[] colSizes;
    private boolean[] colNullable;
    private Expression[] colDefaults;
    private int[] defaultColumnMap;
    private boolean hasDefaultValues;
    private boolean isText;
    private boolean isView;
    boolean sqlEnforceSize;
    boolean sqlEnforceStrictSize;
    protected int columnCount;
    protected int visibleColumnCount;
    protected Database database;
    protected Cache cache;
    protected HsqlNameManager.HsqlName tableName;
    protected int tableType;
    protected int ownerSessionId;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isCached;
    protected int indexType;
    HashSet constraintPath;
    HashMappedList tableUpdateList;

    Table(Database database, HsqlNameManager.HsqlName hsqlName, int n, int n2) throws HsqlException {
        this.database = database;
        this.sqlEnforceSize = database.sqlEnforceSize;
        this.sqlEnforceStrictSize = database.sqlEnforceStrictSize;
        this.identitySequence = new NumberSequence(null, 0L, 1L, -5);
        this.rowIdSequence = new NumberSequence(null, 0L, 1L, -5);
        switch (n) {
            case 0: 
            case 1: {
                this.isTemp = true;
                break;
            }
            case 2: {
                this.isTemp = true;
                this.ownerSessionId = n2;
                break;
            }
            case 4: {
                this.cache = database.logger.getCache();
                if (this.cache != null) {
                    this.isCached = true;
                    break;
                }
                n = 3;
                break;
            }
            case 5: {
                if (!database.logger.hasLog()) {
                    throw Trace.error(63);
                }
                this.isTemp = true;
                this.isText = true;
                this.isReadOnly = true;
                this.isCached = true;
                this.ownerSessionId = n2;
                break;
            }
            case 6: {
                if (!database.logger.hasLog()) {
                    throw Trace.error(63);
                }
                this.isText = true;
                this.isCached = true;
                break;
            }
            case 7: 
            case 8: {
                this.isView = true;
            }
        }
        if (this.isText) {
            this.indexType = 2;
        } else if (this.isCached) {
            this.indexType = 1;
        }
        this.tableType = n;
        this.tableName = hsqlName;
        this.primaryKeyCols = null;
        this.identityColumn = -1;
        this.columnList = new HashMappedList();
        this.indexList = new HsqlArrayList();
        this.constraintList = new Constraint[0];
        this.triggerLists = new HsqlArrayList[12];
        if (database.isFilesReadOnly() && this.checkTableFileBased()) {
            this.isReadOnly = true;
        }
    }

    boolean equals(Session session, String string) {
        if (this.isTemp && session.getId() != this.ownerSessionId) {
            return false;
        }
        return this.tableName.name.equals(string);
    }

    boolean equals(String string) {
        return this.tableName.name.equals(string);
    }

    public final boolean isText() {
        return this.isText;
    }

    public final boolean isTemp() {
        return this.isTemp;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    final boolean isSystem() {
        return this.tableType == 0 || this.tableType == 1 || this.tableType == 8;
    }

    final boolean isView() {
        return this.isView;
    }

    final int getIndexType() {
        return this.indexType;
    }

    public final int getTableType() {
        return this.tableType;
    }

    public final boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    void checkDataReadOnly() throws HsqlException {
        if (this.isReadOnly) {
            throw Trace.error(32);
        }
    }

    void setDataReadOnly(boolean bl) throws HsqlException {
        if (!bl && this.database.isFilesReadOnly() && this.checkTableFileBased()) {
            throw Trace.error(32);
        }
        this.isReadOnly = bl;
    }

    boolean checkTableFileBased() {
        return this.isCached | this.isText;
    }

    int getOwnerSessionId() {
        return this.ownerSessionId;
    }

    protected void setDataSource(Session session, String string, boolean bl, boolean bl2) throws HsqlException {
        throw Trace.error(22);
    }

    protected String getDataSource() {
        return null;
    }

    protected boolean isDescDataSource() {
        return false;
    }

    void addConstraint(Constraint constraint) {
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, constraint, this.constraintList.length, 1);
    }

    Constraint[] getConstraints() {
        return this.constraintList;
    }

    Index getConstraintIndexForColumns(int[] nArray) {
        if (ArrayUtil.areEqual(this.getPrimaryIndex().getColumns(), nArray, nArray.length, true)) {
            return this.getPrimaryIndex();
        }
        int n = this.constraintList.length;
        for (int i = 0; i < n; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.getType() != 2 || !ArrayUtil.areEqual(constraint.getMainColumns(), nArray, nArray.length, true)) continue;
            return constraint.getMainIndex();
        }
        return null;
    }

    Constraint getConstraintForColumns(Table table, int[] nArray, int[] nArray2) {
        int n = this.constraintList.length;
        for (int i = 0; i < n; ++i) {
            Constraint constraint = this.constraintList[i];
            if (!constraint.isEquivalent(table, nArray, this, nArray2)) continue;
            return constraint;
        }
        return null;
    }

    Constraint getConstraintForIndex(Index index) {
        int n = this.constraintList.length;
        for (int i = 0; i < n; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.getMainIndex() != index || constraint.getType() != 2) continue;
            return constraint;
        }
        return null;
    }

    int getNextConstraintIndex(int n, int n2) {
        int n3 = this.constraintList.length;
        for (int i = n; i < n3; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.getType() != n2) continue;
            return i;
        }
        return -1;
    }

    void addColumn(String string, int n) throws HsqlException {
        Column column = new Column(this.database.nameManager.newHsqlName(string, false), true, n, 0, 0, false, 0L, 0L, false, null);
        this.addColumn(column);
    }

    void addColumn(Column column) throws HsqlException {
        if (this.searchColumn(column.columnName.name) >= 0) {
            throw Trace.error(27);
        }
        if (column.isIdentity()) {
            Trace.check(column.getType() == 4 || column.getType() == -5, 16, column.columnName.name);
            Trace.check(this.identityColumn == -1, 24, column.columnName.name);
            this.identityColumn = this.columnCount;
        }
        Trace.doAssert(this.primaryKeyCols == null, "Table.addColumn");
        this.columnList.add(column.columnName.name, column);
        ++this.columnCount;
        ++this.visibleColumnCount;
    }

    void addColumns(Result.ResultMetaData resultMetaData, int n) throws HsqlException {
        for (int i = 0; i < n; ++i) {
            Column column = new Column(this.database.nameManager.newHsqlName(resultMetaData.sLabel[i], resultMetaData.isLabelQuoted[i]), true, resultMetaData.colType[i], resultMetaData.colSize[i], resultMetaData.colScale[i], false, 0L, 0L, false, null);
            this.addColumn(column);
        }
    }

    void addColumns(Select select) throws HsqlException {
        int n = select.iResultLen;
        for (int i = 0; i < n; ++i) {
            Expression expression = select.exprColumns[i];
            Column column = new Column(this.database.nameManager.newHsqlName(expression.getAlias(), expression.isAliasQuoted()), true, expression.getDataType(), expression.getColumnSize(), expression.getColumnScale(), false, 0L, 0L, false, null);
            this.addColumn(column);
        }
    }

    public HsqlNameManager.HsqlName getName() {
        return this.tableName;
    }

    void renameTable(String string, boolean bl) throws HsqlException {
        String string2 = this.tableName.name;
        this.tableName.rename(string, bl);
        if (HsqlNameManager.HsqlName.isReservedIndexName(this.getPrimaryIndex().getName().name)) {
            this.getPrimaryIndex().getName().rename("SYS_PK", string, bl);
        }
        this.renameTableInCheckConstraints(string2, string);
    }

    int getInternalColumnCount() {
        return this.columnCount;
    }

    protected Table duplicate() throws HsqlException {
        Table table = new Table(this.database, this.tableName, this.tableType, this.ownerSessionId);
        return table;
    }

    void checkColumnsMatch(int[] nArray, Table table, int[] nArray2) throws HsqlException {
        if (nArray.length != nArray2.length) {
            throw Trace.error(5);
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= this.columnCount || nArray2[i] >= table.columnCount) {
                throw Trace.error(5);
            }
            if (this.getColumn(nArray[i]).getType() == table.getColumn(nArray2[i]).getType()) continue;
            throw Trace.error(57);
        }
    }

    Table moveDefinition(String string, Column column, int n, int n2) throws HsqlException {
        int[] nArray;
        Table table = this.duplicate();
        for (int i = 0; i < this.visibleColumnCount + 1; ++i) {
            if (i == n) {
                if (n2 > 0) {
                    table.addColumn(column);
                } else if (n2 < 0) continue;
            }
            if (i == this.visibleColumnCount) break;
            table.addColumn(this.getColumn(i));
        }
        int[] nArray2 = nArray = this.primaryKeyCols[0] == this.visibleColumnCount ? null : this.primaryKeyCols;
        if (nArray != null) {
            int[] nArray3 = ArrayUtil.toAdjustedColumnArray(nArray, n, n2);
            if (nArray.length != nArray3.length) {
                throw Trace.error(25);
            }
            nArray = nArray3;
        }
        table.createPrimaryKey(this.getIndex(0).getName(), nArray, false);
        table.constraintList = this.constraintList;
        for (int i = 1; i < this.getIndexCount(); ++i) {
            Index index;
            Index index2 = this.getIndex(i);
            if (string != null && index2.getName().name.equals(string) || (index = table.createAdjustedIndex(index2, n, n2)) != null) continue;
            throw Trace.error(123);
        }
        table.triggerLists = this.triggerLists;
        return table;
    }

    void updateConstraintsTables(Table table, int n, int n2) throws HsqlException {
        int n3 = this.constraintList.length;
        for (int i = 0; i < n3; ++i) {
            Constraint constraint = this.constraintList[i];
            constraint.replaceTable(table, this, n, n2);
            if (constraint.constType != 3) continue;
            this.recompileCheckConstraint(constraint);
        }
    }

    private void recompileCheckConstraints() throws HsqlException {
        int n = this.constraintList.length;
        for (int i = 0; i < n; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.constType != 3) continue;
            this.recompileCheckConstraint(constraint);
        }
    }

    private void recompileCheckConstraint(Constraint constraint) throws HsqlException {
        Expression expression;
        String string = constraint.core.check.getDDL();
        Tokenizer tokenizer = new Tokenizer(string);
        Parser parser = new Parser(this.database.getSessionManager().getSysSession(), this.database, tokenizer);
        constraint.core.check = expression = parser.parseExpression();
        expression.setLikeOptimised();
        Select select = Expression.getCheckSelect(this, expression);
        constraint.core.checkFilter = select.tFilter[0];
        constraint.core.checkFilter.setAsCheckFilter();
        constraint.core.mainTable = this;
    }

    void checkColumnInCheckConstraint(String string) throws HsqlException {
        int n = this.constraintList.length;
        for (int i = 0; i < n; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.constType != 3 || !constraint.hasColumn(this, string)) continue;
            throw Trace.error(197, constraint.getName());
        }
    }

    private void renameColumnInCheckConstraints(String string, String string2, boolean bl) throws HsqlException {
        int n = this.constraintList.length;
        for (int i = 0; i < n; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.constType != 3) continue;
            Expression.Collector collector = new Expression.Collector();
            collector.addAll(constraint.core.check, 2);
            Iterator iterator = collector.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                if (expression.getColumnName() != string) continue;
                expression.setColumnName(string2, bl);
            }
        }
    }

    private void renameTableInCheckConstraints(String string, String string2) throws HsqlException {
        int n = this.constraintList.length;
        for (int i = 0; i < n; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.constType != 3) continue;
            Expression.Collector collector = new Expression.Collector();
            collector.addAll(constraint.core.check, 2);
            Iterator iterator = collector.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                if (expression.getTableName() != string) continue;
                expression.setTableName(string2);
            }
        }
        this.recompileCheckConstraints();
    }

    public int getColumnCount() {
        return this.visibleColumnCount;
    }

    int getIndexCount() {
        return this.indexList.size();
    }

    int getIdentityColumn() {
        return this.identityColumn;
    }

    int getColumnNr(String string) throws HsqlException {
        int n = this.searchColumn(string);
        if (n == -1) {
            throw Trace.error(28, string);
        }
        return n;
    }

    int searchColumn(String string) {
        int n = this.columnList.getIndex(string);
        return n == this.visibleColumnCount ? -1 : n;
    }

    Index getPrimaryIndex() {
        if (this.primaryKeyCols == null) {
            return null;
        }
        return this.getIndex(0);
    }

    int[] getPrimaryKey() {
        return this.primaryKeyCols[0] == this.visibleColumnCount ? null : this.primaryKeyCols;
    }

    public boolean hasPrimaryKey() {
        return this.primaryKeyCols[0] != this.visibleColumnCount;
    }

    int[] getBestRowIdentifiers() {
        return this.bestRowIdentifierCols;
    }

    boolean isBestRowIdentifiersStrict() {
        return this.bestRowIdentifierStrict;
    }

    private void setBestRowIdentifiers() {
        int n;
        int[] nArray = null;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        if (this.colNullable == null) {
            return;
        }
        this.bestIndexForColumn = new int[this.columnList.size()];
        this.nullRowIDCols = new int[this.columnList.size()];
        for (n = 0; n < this.bestIndexForColumn.length; ++n) {
            this.bestIndexForColumn[n] = -1;
            this.nullRowIDCols[n] = -1;
        }
        for (n = 0; n < this.indexList.size(); ++n) {
            Index index = (Index)this.indexList.get(n);
            int[] nArray2 = index.getColumns();
            int n4 = index.getVisibleColumns();
            if (n == 0) {
                if (this.getPrimaryKey() == null) continue;
                bl = true;
            }
            if (this.bestIndexForColumn[nArray2[0]] == -1) {
                this.bestIndexForColumn[nArray2[0]] = n;
            }
            if (!index.isUnique()) continue;
            int n5 = 0;
            for (int i = 0; i < n4; ++i) {
                if (!this.colNullable[nArray2[i]]) {
                    ++n5;
                    continue;
                }
                this.nullRowIDCols[nArray2[i]] = nArray2[i];
            }
            if (n5 == n4) {
                if (nArray != null && n2 == n3 && n4 >= n2) continue;
                nArray = nArray2;
                n2 = n4;
                n3 = n4;
                bl = true;
                continue;
            }
            if (bl || nArray != null && n4 >= n2 && n5 <= n3) continue;
            nArray = nArray2;
            n2 = n4;
            n3 = n5;
        }
        this.bestRowIdentifierCols = nArray == null || n2 == nArray.length ? nArray : ArrayUtil.arraySlice(nArray, 0, n2);
        this.bestRowIdentifierStrict = bl;
        ArrayUtil.sortArray(this.nullRowIDCols);
        n = ArrayUtil.findNot(this.nullRowIDCols, -1);
        this.nullRowIDCols = n == -1 ? null : ArrayUtil.arraySlice(this.nullRowIDCols, 0, n);
        this.needsRowID = this.getPrimaryKey() == null;
    }

    void setDefaultExpression(int n, Expression expression) {
        Column column = this.getColumn(n);
        column.setDefaultExpression(expression);
        this.resetDefaultValues();
    }

    void resetDefaultValues() {
        this.hasDefaultValues = false;
        for (int i = 0; i < this.columnCount; ++i) {
            Column column = this.getColumn(i);
            if (i >= this.visibleColumnCount) continue;
            this.hasDefaultValues = this.hasDefaultValues || column.getDefaultExpression() != null;
            this.colDefaults[i] = column.getDefaultExpression();
        }
    }

    Index getIndexForColumn(int n) {
        int n2 = this.bestIndexForColumn[n];
        if (n2 == -1 && this.tableType == 1 || this.tableType == 0) {
            try {
                this.createIndex(new int[]{n}, null, false, false, false);
                n2 = this.bestIndexForColumn[n];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2 == -1 ? null : this.getIndex(n2);
    }

    Index getIndexForColumns(boolean[] blArray) {
        Index index = null;
        int n = 0;
        for (int i = 0; i < this.indexList.size(); ++i) {
            Index index2 = (Index)this.indexList.get(i);
            boolean bl = ArrayUtil.containsAllTrueElements(blArray, index2.colCheck);
            if (!bl || index2.getVisibleColumns() <= n) continue;
            n = index2.getVisibleColumns();
            index = index2;
        }
        return index;
    }

    Index getIndexForColumns(int[] nArray, boolean bl) throws HsqlException {
        int n = this.getIndexCount();
        for (int i = 0; i < n; ++i) {
            Index index = this.getIndex(i);
            int[] nArray2 = index.getColumns();
            if (!ArrayUtil.haveEqualArrays(nArray2, nArray, nArray.length) || bl && !index.isUnique()) continue;
            return index;
        }
        return null;
    }

    int[] getIndexRootsArray() {
        int[] nArray = new int[this.getIndexCount()];
        for (int i = 0; i < this.getIndexCount(); ++i) {
            Node node = this.getIndex(i).getRoot();
            nArray[i] = node != null ? node.getKey() : -1;
        }
        return nArray;
    }

    String getIndexRoots() {
        String string = StringUtil.getList(this.getIndexRootsArray(), " ", DEFAULT_PK);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        stringBuffer.append(this.identitySequence.peek());
        return stringBuffer.toString();
    }

    void setIndexRoots(int[] nArray) throws HsqlException {
        Trace.check(this.isCached, 22);
        for (int i = 0; i < this.getIndexCount(); ++i) {
            int n = nArray[i];
            CachedRow cachedRow = null;
            if (n != -1) {
                cachedRow = this.cache.getRow(n, this);
            }
            Node node = null;
            if (cachedRow != null) {
                node = cachedRow.getNode(i);
            }
            this.getIndex(i).setRoot(node);
        }
    }

    void setIndexRoots(String string) throws HsqlException {
        Trace.check(this.isCached, 22);
        int[] nArray = new int[this.getIndexCount()];
        int n = 0;
        for (int i = 0; i < this.getIndexCount(); ++i) {
            int n2;
            int n3 = string.indexOf(32, n);
            nArray[i] = n2 = Integer.parseInt(string.substring(n, n3));
            n = n3 + 1;
        }
        this.setIndexRoots(nArray);
        this.identitySequence.reset(Long.parseLong(string.substring(n)));
    }

    void createPrimaryKey(int[] nArray) throws HsqlException {
        this.createPrimaryKey(null, nArray, false);
    }

    void createPrimaryKey() throws HsqlException {
        this.createPrimaryKey(null, null, false);
    }

    void createPrimaryKey(HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean bl) throws HsqlException {
        Trace.doAssert(this.primaryKeyCols == null, "Table.createPrimaryKey(column)");
        Column column = new Column(this.database.nameManager.newAutoName(DEFAULT_PK), false, 4, 0, 0, false, 0L, 0L, nArray == null, null);
        this.addColumn(column);
        --this.visibleColumnCount;
        if (nArray == null) {
            nArray = new int[]{this.visibleColumnCount};
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                if (bl) {
                    this.getColumn(nArray[i]).setNullable(false);
                }
                this.getColumn(nArray[i]).setPrimaryKey(true);
            }
        }
        this.primaryKeyCols = nArray;
        HsqlNameManager.HsqlName hsqlName2 = hsqlName != null ? hsqlName : this.database.nameManager.newHsqlName("SYS_PK", this.tableName.name, this.tableName.isNameQuoted);
        this.createIndexStructure(nArray, hsqlName2, true, true, true, false);
        this.colTypes = new int[this.columnCount];
        this.colDefaults = new Expression[this.visibleColumnCount];
        this.colSizes = new int[this.visibleColumnCount];
        this.colNullable = new boolean[this.visibleColumnCount];
        this.defaultColumnMap = new int[this.visibleColumnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            column = this.getColumn(i);
            this.colTypes[i] = column.getType();
            if (i < this.visibleColumnCount) {
                this.colSizes[i] = column.getSize();
                this.colNullable[i] = column.isNullable();
                this.defaultColumnMap[i] = i;
            }
            if (!column.isIdentity()) continue;
            this.identitySequence.reset(column.identityStart, column.identityIncrement);
        }
        this.resetDefaultValues();
        this.setBestRowIdentifiers();
    }

    private Index createAdjustedIndex(Index index, int n, int n2) throws HsqlException {
        int[] nArray = (int[])ArrayUtil.resizeArray(index.getColumns(), index.getVisibleColumns());
        int[] nArray2 = ArrayUtil.toAdjustedColumnArray(nArray, n, n2);
        if (nArray2.length != index.getVisibleColumns()) {
            return null;
        }
        return this.createIndexStructure(nArray2, index.getName(), false, index.isUnique(), index.isConstraint, index.isForward);
    }

    Index createIndex(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3) throws HsqlException {
        int n = this.createIndexStructureGetNo(nArray, hsqlName, false, bl, bl2, bl3);
        Index index = (Index)this.indexList.get(n);
        Index index2 = this.getPrimaryIndex();
        Node node = index2.first();
        int n2 = 0;
        try {
            while (node != null) {
                Row row = node.getRow();
                Node node2 = Node.newNode(row, n, this);
                Node node3 = row.getNode(n - 1);
                node2.nNext = node3.nNext;
                node3.nNext = node2;
                index.insert(node2);
                node = index2.next(node);
            }
            return index;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            n2 = 72;
        }
        catch (HsqlException hsqlException) {
            n2 = 9;
        }
        Node node4 = node;
        node = index2.first();
        while (node != node4) {
            int n3 = n;
            Node node5 = node;
            while (--n3 > 0) {
                node5 = node5.nNext;
            }
            node5.nNext = node5.nNext.nNext;
            node = index2.next(node);
        }
        this.indexList.remove(index);
        this.setBestRowIdentifiers();
        throw Trace.error(n2);
    }

    Index createIndexStructure(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws HsqlException {
        return (Index)this.indexList.get(this.createIndexStructureGetNo(nArray, hsqlName, bl, bl2, bl3, bl4));
    }

    int createIndexStructureGetNo(int[] nArray, HsqlNameManager.HsqlName hsqlName, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws HsqlException {
        int n;
        Trace.doAssert(this.primaryKeyCols != null, "createIndex");
        int n2 = nArray.length;
        int n3 = bl ? 0 : this.primaryKeyCols.length;
        int[] nArray2 = new int[n2 + n3];
        int[] nArray3 = new int[n2 + n3];
        for (n = 0; n < n2; ++n) {
            nArray2[n] = nArray[n];
            nArray3[n] = this.getColumn(nArray2[n]).getType();
        }
        if (!bl) {
            for (n = 0; n < n3; ++n) {
                nArray2[n2 + n] = this.primaryKeyCols[n];
                nArray3[n2 + n] = this.getColumn(this.primaryKeyCols[n]).getType();
            }
        }
        if (nArray2[0] == this.visibleColumnCount) {
            n2 = 0;
        }
        Index index = new Index(hsqlName, this, nArray2, nArray3, bl2, bl3, bl4, n2);
        int n4 = this.addIndex(index);
        this.setBestRowIdentifiers();
        return n4;
    }

    private int addIndex(Index index) {
        int n;
        for (n = 0; n < this.indexList.size(); ++n) {
            Index index2 = (Index)this.indexList.get(n);
            int n2 = index.getIndexOrderValue() - index2.getIndexOrderValue();
            if (n2 < 0) break;
        }
        this.indexList.add(n, index);
        return n;
    }

    boolean isIndexingMutable() {
        return !this.isIndexCached();
    }

    void checkDropIndex(String string, HashSet hashSet) throws HsqlException {
        Index index = this.getIndex(string);
        if (index == null) {
            throw Trace.error(26, string);
        }
        if (index.equals(this.getIndex(0))) {
            throw Trace.error(25, string);
        }
        int n = this.constraintList.length;
        for (int i = 0; i < n; ++i) {
            Constraint constraint = this.constraintList[i];
            if (hashSet != null && hashSet.contains(constraint)) continue;
            if (constraint.isIndexFK(index)) {
                throw Trace.error(50, string);
            }
            if (!constraint.isIndexUnique(index)) continue;
            throw Trace.error(56, string);
        }
    }

    boolean isEmpty() {
        if (this.getIndexCount() == 0) {
            return true;
        }
        return this.getIndex(0).getRoot() == null;
    }

    int[] getColumnMap() {
        return this.defaultColumnMap;
    }

    int[] getNewColumnMap() {
        return new int[this.visibleColumnCount];
    }

    boolean[] getNewColumnCheckList() {
        return new boolean[this.visibleColumnCount];
    }

    Object[] getNewRow() {
        return new Object[this.columnCount];
    }

    Object[] getNewRowData(Session session, boolean[] blArray) throws HsqlException {
        Object[] objectArray = new Object[this.columnCount];
        if (blArray != null && this.hasDefaultValues) {
            for (int i = 0; i < this.visibleColumnCount; ++i) {
                Expression expression = this.colDefaults[i];
                if (blArray[i] || expression == null) continue;
                objectArray[i] = expression.getValue(session, this.colTypes[i]);
            }
        }
        return objectArray;
    }

    void dropIndex(String string) throws HsqlException {
        Index index;
        int n;
        for (n = 1; n < this.getIndexCount(); ++n) {
            index = this.getIndex(n);
            if (!index.getName().name.equals(string)) continue;
            this.indexList.remove(n);
            this.setBestRowIdentifiers();
            break;
        }
        index = this.getPrimaryIndex();
        Node node = index.first();
        while (node != null) {
            int n2 = n - 1;
            Node node2 = node;
            while (n2-- > 0) {
                node2 = node2.nNext;
            }
            node2.nNext = node2.nNext.nNext;
            node = index.next(node);
        }
    }

    void moveData(Session session, Table table, int n, int n2) throws HsqlException {
        Object object;
        Object object2 = null;
        if (n2 > 0) {
            object = this.getColumn(n);
            object2 = ((Column)object).getDefaultValue(session);
        }
        object = table.getPrimaryIndex();
        Node node = ((Index)object).first();
        while (node != null) {
            Object[] objectArray = node.getData();
            Object[] objectArray2 = this.getNewRow();
            ArrayUtil.copyAdjustArray(objectArray, objectArray2, object2, n, n2);
            this.insertWithIdentity(session, objectArray2);
            node = ((Index)object).next(node);
        }
        table.drop();
    }

    int insert(Session session, Result result) throws HsqlException {
        Record record = result.rRoot;
        int n = 0;
        this.fireAll(session, 3);
        while (record != null) {
            this.insertRow(session, record.data);
            record = record.next;
            ++n;
        }
        this.fireAll(session, 0);
        return n;
    }

    void insert(Session session, Object[] objectArray) throws HsqlException {
        this.fireAll(session, 3);
        this.insertRow(session, objectArray);
        this.fireAll(session, 0);
    }

    private void insertRow(Session session, Object[] objectArray) throws HsqlException {
        if (this.triggerLists[9] != null) {
            this.fireAll(session, 9, null, objectArray);
        }
        this.setIdentityColumn(session, objectArray);
        this.checkRowDataInsert(session, objectArray);
        this.insertNoCheck(session, objectArray);
        if (this.triggerLists[6] != null) {
            this.fireAll(session, 6, null, objectArray);
            this.checkRowDataInsert(session, objectArray);
        }
    }

    void insertIntoTable(Session session, Result result) throws HsqlException {
        this.insert(result);
        if (this.isTemp || this.isText || !this.database.logger.hasLog()) {
            return;
        }
        Record record = result.rRoot;
        while (record != null) {
            this.database.logger.writeInsertStatement(session, this, record.data);
            record = record.next;
        }
    }

    private Row insertNoCheck(Session session, Object[] objectArray) throws HsqlException {
        Row row = Row.newRow(this, objectArray);
        this.indexRow(row);
        if (session != null) {
            session.addTransactionInsert(this, objectArray);
        }
        if (!this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeInsertStatement(session, this, objectArray);
        }
        return row;
    }

    void insertNoCheckRollback(Session session, Object[] objectArray, boolean bl) throws HsqlException {
        Row row = Row.newRow(this, objectArray);
        this.indexRow(row);
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly) {
            this.database.logger.writeInsertStatement(session, this, objectArray);
        }
    }

    int insert(Result result) throws HsqlException {
        Record record = result.rRoot;
        int n = 0;
        while (record != null) {
            this.insert(record.data);
            record = record.next;
            ++n;
        }
        return n;
    }

    public void insertWithIdentity(Session session, Object[] objectArray) throws HsqlException {
        this.setIdentityColumn(session, objectArray);
        this.insert(objectArray);
    }

    public void insert(Object[] objectArray) throws HsqlException {
        Object object;
        if (objectArray.length != this.columnCount) {
            object = this.getNewRow();
            ArrayUtil.copyArray(objectArray, object, this.visibleColumnCount);
            objectArray = object;
        } else {
            for (int i = this.visibleColumnCount; i < this.columnCount; ++i) {
                objectArray[i] = null;
            }
        }
        object = Row.newRow(this, objectArray);
        this.indexRow((Row)object);
    }

    protected void insertNoChange(CachedDataRow cachedDataRow) throws HsqlException {
        Object[] objectArray = cachedDataRow.getData();
        this.setIdentityColumn(null, objectArray);
        this.enforceFieldValueLimits(objectArray);
        this.enforceNullConstraints(objectArray);
        this.indexRow(cachedDataRow);
    }

    protected void enforceNullConstraints(Object[] objectArray) throws HsqlException {
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (objectArray[i] != null || this.colNullable[i]) continue;
            Trace.throwerror(10, "column: " + this.getColumn((int)i).columnName.name + " table: " + this.tableName.name);
        }
    }

    protected void setIdentityColumn(Session session, Object[] objectArray) throws HsqlException {
        if (this.identityColumn != -1) {
            Number number = (Number)objectArray[this.identityColumn];
            if (number == null) {
                number = this.colTypes[this.identityColumn] == 4 ? (Number)ValuePool.getInt((int)this.identitySequence.getValue()) : (Number)ValuePool.getLong(this.identitySequence.getValue());
                objectArray[this.identityColumn] = number;
            } else {
                this.identitySequence.getValue(number.longValue());
            }
            if (session != null && this.identityColumn < this.visibleColumnCount) {
                session.setLastIdentity(number);
            }
        }
    }

    void enforceFieldValueLimits(Object[] objectArray) throws HsqlException {
        if (this.sqlEnforceSize || this.sqlEnforceStrictSize) {
            for (int i = 0; i < this.visibleColumnCount; ++i) {
                if (this.colSizes[i] == 0 || objectArray[i] == null) continue;
                objectArray[i] = Table.enforceSize(objectArray[i], this.colTypes[i], this.colSizes[i], true, this.sqlEnforceStrictSize);
            }
        }
    }

    void enforceFieldValueLimits(Object[] objectArray, int[] nArray) throws HsqlException {
        if (this.sqlEnforceSize || this.sqlEnforceStrictSize) {
            if (nArray == null) {
                this.enforceFieldValueLimits(objectArray);
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (this.colSizes[n] == 0 || objectArray[n] == null) continue;
                objectArray[n] = Table.enforceSize(objectArray[n], this.colTypes[n], this.colSizes[n], true, this.sqlEnforceStrictSize);
            }
        }
    }

    static Object enforceSize(Object object, int n, int n2, boolean bl, boolean bl2) throws HsqlException {
        if (n2 == 0) {
            return object;
        }
        switch (n) {
            case 1: {
                return Table.padOrTrunc((String)object, n2, bl, bl2);
            }
            case 12: {
                return Table.padOrTrunc((String)object, n2, false, bl2);
            }
        }
        return object;
    }

    static String padOrTrunc(String string, int n, boolean bl, boolean bl2) throws HsqlException {
        if (bl2 && StringUtil.rTrimSize(string) > n) {
            throw Trace.error(124);
        }
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        if (n2 > n) {
            return string.substring(0, n);
        }
        if (!bl) {
            return string;
        }
        char[] cArray = new char[n];
        string.getChars(0, n2, cArray, 0);
        for (int i = n2; i < n; ++i) {
            cArray[i] = 32;
        }
        return new String(cArray);
    }

    void fireAll(Session session, int n, Object[] objectArray, Object[] objectArray2) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        HsqlArrayList hsqlArrayList = this.triggerLists[n];
        if (hsqlArrayList == null) {
            return;
        }
        int n2 = hsqlArrayList.size();
        for (int i = 0; i < n2; ++i) {
            TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(i);
            triggerDef.pushPair(session, objectArray, objectArray2);
        }
    }

    void fireAll(Session session, int n) {
        if (this.triggerLists[n] != null) {
            this.fireAll(session, n, null, null);
        }
    }

    void addTrigger(TriggerDef triggerDef) {
        if (this.triggerLists[triggerDef.vectorIndex] == null) {
            this.triggerLists[triggerDef.vectorIndex] = new HsqlArrayList();
        }
        this.triggerLists[triggerDef.vectorIndex].add(triggerDef);
    }

    void dropTrigger(String string) {
        int n = 12;
        for (int i = 0; i < n; ++i) {
            HsqlArrayList hsqlArrayList = this.triggerLists[i];
            if (hsqlArrayList == null) continue;
            for (int j = hsqlArrayList.size() - 1; j >= 0; --j) {
                TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(j);
                if (!triggerDef.name.name.equals(string)) continue;
                hsqlArrayList.remove(j);
                triggerDef.terminate();
            }
            if (!hsqlArrayList.isEmpty()) continue;
            this.triggerLists[i] = null;
        }
    }

    void dropTriggers() {
        int n = 12;
        for (int i = 0; i < n; ++i) {
            HsqlArrayList hsqlArrayList = this.triggerLists[i];
            if (hsqlArrayList == null) continue;
            for (int j = hsqlArrayList.size() - 1; j >= 0; --j) {
                TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(j);
                triggerDef.terminate();
            }
            this.triggerLists[i] = null;
        }
    }

    static void checkCascadeDelete(Session session, Table table, HashMappedList hashMappedList, Row row, boolean bl, HashSet hashSet) throws HsqlException {
        int n = table.constraintList.length;
        block0: for (int i = 0; i < n; ++i) {
            boolean bl2;
            Node node;
            Constraint constraint = table.constraintList[i];
            if (constraint.getType() != 1 || constraint.getRef() == null || (node = constraint.findFkRef(row.getData(), true)) == null) continue;
            Table table2 = constraint.getRef();
            boolean bl3 = bl2 = table2.getNextConstraintIndex(0, 1) != -1;
            if (!bl && !bl2) continue;
            Index index = constraint.getRefIndex();
            int[] nArray = constraint.getMainColumns();
            int[] nArray2 = constraint.getRefColumns();
            Object[] objectArray = row.getData();
            boolean bl4 = constraint.getDeleteAction() == 2 || constraint.getDeleteAction() == 4;
            HashMappedList hashMappedList2 = null;
            if (bl4 && (hashMappedList2 = (HashMappedList)hashMappedList.get(table2)) == null) {
                hashMappedList2 = new HashMappedList();
                hashMappedList.add(table2, hashMappedList2);
            }
            Node node2 = node;
            while (!node2.isDeleted() && index.compareRowNonUnique(objectArray, nArray, node2.getData()) == 0) {
                node2 = node2.getUpdatedNode();
                Node node3 = index.next(node2);
                if (bl4) {
                    int n2;
                    Object[] objectArray2 = table2.getNewRow();
                    System.arraycopy(node2.getData(), 0, objectArray2, 0, objectArray2.length);
                    if (constraint.getDeleteAction() == 2) {
                        for (n2 = 0; n2 < nArray2.length; ++n2) {
                            objectArray2[nArray2[n2]] = null;
                        }
                    } else {
                        for (n2 = 0; n2 < nArray2.length; ++n2) {
                            Column column = table2.getColumn(nArray2[n2]);
                            objectArray2[nArray2[n2]] = column.getDefaultValue(session);
                        }
                    }
                    if (bl2 && hashSet.add(constraint)) {
                        Table.checkCascadeUpdate(session, table2, null, node2.getRow(), objectArray2, nArray2, null, hashSet);
                        hashSet.remove(constraint);
                        node2 = node2.getUpdatedNode();
                        Node node4 = node3 = node3 == null ? null : node3.getUpdatedNode();
                    }
                    if (bl && (table2 != table || node2.getRow() != row.getUpdatedRow())) {
                        Table.mergeUpdate(hashMappedList2, node2.getRow(), objectArray2, nArray2);
                    }
                } else if (bl2) {
                    if (table2 != table) {
                        if (hashSet.add(constraint)) {
                            Table.checkCascadeDelete(session, table2, hashMappedList, node2.getRow(), bl, hashSet);
                            hashSet.remove(constraint);
                            node2 = node2.getUpdatedNode();
                            node3 = node3 == null ? null : node3.getUpdatedNode();
                        }
                    } else {
                        Row row2 = row = row == null ? null : row.getUpdatedRow();
                        if (node2.getRow() != row) {
                            Table.checkCascadeDelete(session, table2, hashMappedList, node2.getRow(), bl, hashSet);
                            node2 = node2.getUpdatedNode();
                            Node node5 = node3 = node3 == null ? null : node3.getUpdatedNode();
                        }
                    }
                }
                if (bl && !bl4 && !node2.isDeleted()) {
                    table2.deleteNoRefCheck(session, node2.getRow());
                }
                if (node3 == null) continue block0;
                node2 = node3;
            }
        }
    }

    static void checkCascadeUpdate(Session session, Table table, HashMappedList hashMappedList, Row row, Object[] objectArray, int[] nArray, Table table2, HashSet hashSet) throws HsqlException {
        int n = table.constraintList.length;
        block0: for (int i = 0; i < n; ++i) {
            Node node;
            Object object;
            Constraint constraint = table.constraintList[i];
            if (constraint.getType() == 0 && constraint.getRef() != null) {
                if (table2 != null && constraint.getMain() == table2 || ArrayUtil.countCommonElements(nArray, constraint.getRefColumns()) == 0) continue;
                object = constraint.findMainRef(objectArray);
                continue;
            }
            if (constraint.getType() != 1 || constraint.getRef() == null || (object = ArrayUtil.commonElements(nArray, constraint.getMainColumns())) == null) continue;
            int[] nArray2 = constraint.getMainColumns();
            int[] nArray3 = constraint.getRefColumns();
            boolean bl = true;
            for (int j = 0; j < nArray2.length; ++j) {
                if (row.getData()[nArray2[j]].equals(objectArray[nArray2[j]])) continue;
                bl = false;
                break;
            }
            if (bl || (node = constraint.findFkRef(row.getData(), false)) == null) continue;
            Table table3 = constraint.getRef();
            boolean bl2 = table3.getNextConstraintIndex(0, 1) != -1;
            Index index = constraint.getRefIndex();
            HashMappedList hashMappedList2 = (HashMappedList)hashMappedList.get(table3);
            if (hashMappedList2 == null) {
                hashMappedList2 = new HashMappedList();
                hashMappedList.add(table3, hashMappedList2);
            }
            Node node2 = node;
            while (index.compareRowNonUnique(row.getData(), nArray2, node2.getData()) == 0) {
                int n2;
                node2 = node2.getUpdatedNode();
                Node node3 = index.next(node2);
                Object[] objectArray2 = table3.getNewRow();
                System.arraycopy(node2.getData(), 0, objectArray2, 0, objectArray2.length);
                if (constraint.getUpdateAction() == 2) {
                    for (n2 = 0; n2 < nArray3.length; ++n2) {
                        objectArray2[nArray3[n2]] = null;
                    }
                } else if (constraint.getUpdateAction() == 4) {
                    for (n2 = 0; n2 < nArray3.length; ++n2) {
                        Column column = table3.getColumn(nArray3[n2]);
                        objectArray2[nArray3[n2]] = column.getDefaultValue(session);
                    }
                    if (hashSet.add(constraint)) {
                        Table.checkCascadeUpdate(session, table3, hashMappedList, node2.getRow(), objectArray2, nArray3, null, hashSet);
                        hashSet.remove(constraint);
                    }
                } else {
                    for (n2 = 0; n2 < nArray2.length; ++n2) {
                        objectArray2[nArray3[n2]] = objectArray[nArray2[n2]];
                    }
                    if (hashSet.add(constraint)) {
                        Table.checkCascadeUpdate(session, table3, hashMappedList, node2.getRow(), objectArray2, object, table, hashSet);
                        hashSet.remove(constraint);
                    }
                }
                Table.mergeUpdate(hashMappedList2, node2.getRow(), objectArray2, nArray3);
                if (node3 == null) continue block0;
                node2 = node3;
            }
        }
    }

    static void mergeUpdate(HashMappedList hashMappedList, Row row, Object[] objectArray, int[] nArray) {
        Object[] objectArray2 = (Object[])hashMappedList.get(row);
        if (objectArray2 != null) {
            for (int i = 0; i < nArray.length; ++i) {
                objectArray2[nArray[i]] = objectArray[nArray[i]];
            }
        } else {
            hashMappedList.add(row, objectArray);
        }
    }

    static boolean mergeKeepUpdate(HashMappedList hashMappedList, int[] nArray, Row row, Object[] objectArray) throws HsqlException {
        Object[] objectArray2 = (Object[])hashMappedList.get(row);
        if (objectArray2 != null) {
            if (Index.compareRows(row.getData(), objectArray, nArray) != 0 && Index.compareRows(objectArray, objectArray2, nArray) != 0) {
                return false;
            }
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[nArray[i]] = objectArray2[nArray[i]];
            }
            hashMappedList.put(row, objectArray);
        } else {
            hashMappedList.add(row, objectArray);
        }
        return true;
    }

    static void clearUpdateLists(HashMappedList hashMappedList) {
        for (int i = 0; i < hashMappedList.size(); ++i) {
            HashMappedList hashMappedList2 = (HashMappedList)hashMappedList.get(i);
            hashMappedList2.clear();
        }
    }

    int delete(Session session, HsqlArrayList hsqlArrayList) throws HsqlException {
        Object object;
        int n;
        HashSet hashSet = this.constraintPath == null ? new HashSet() : this.constraintPath;
        this.constraintPath = null;
        HashMappedList hashMappedList = this.tableUpdateList == null ? new HashMappedList() : this.tableUpdateList;
        this.tableUpdateList = null;
        if (this.database.isReferentialIntegrity()) {
            for (n = 0; n < hsqlArrayList.size(); ++n) {
                object = (Row)hsqlArrayList.get(n);
                hashSet.clear();
                Table.checkCascadeDelete(session, this, hashMappedList, (Row)object, false, hashSet);
            }
        }
        this.fireAll(session, 4);
        if (this.database.isReferentialIntegrity()) {
            for (n = 0; n < hsqlArrayList.size(); ++n) {
                object = (Row)hsqlArrayList.get(n);
                hashSet.clear();
                Table.checkCascadeDelete(session, this, hashMappedList, (Row)object, true, hashSet);
            }
        }
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            object = (Row)hsqlArrayList.get(n);
            if (((Row)object).isDeleted()) continue;
            this.deleteNoRefCheck(session, (Row)object);
        }
        for (n = 0; n < hashMappedList.size(); ++n) {
            object = (Table)hashMappedList.getKey(n);
            HashMappedList hashMappedList2 = (HashMappedList)hashMappedList.get(n);
            ((Table)object).updateRowSet(session, hashMappedList2, null, false);
            hashMappedList2.clear();
        }
        this.fireAll(session, 1);
        hashSet.clear();
        this.constraintPath = hashSet;
        this.tableUpdateList = hashMappedList;
        return hsqlArrayList.size();
    }

    private void deleteNoRefCheck(Session session, Row row) throws HsqlException {
        Object[] objectArray = row.getData();
        this.fireAll(session, 10, objectArray, null);
        this.deleteNoCheck(session, row, true);
        this.fireAll(session, 7, objectArray, null);
    }

    private void deleteNoCheck(Session session, Row row, boolean bl) throws HsqlException {
        Object[] objectArray = row.getData();
        if ((row = row.getUpdatedRow()).isDeleted()) {
            return;
        }
        for (int i = this.getIndexCount() - 1; i >= 0; --i) {
            Node node = row.getNode(i);
            this.getIndex(i).delete(node);
        }
        row = row.getUpdatedRow();
        row.delete();
        if (session != null) {
            session.addTransactionDelete(this, objectArray);
        }
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly) {
            this.database.logger.writeDeleteStatement(session, this, objectArray);
        }
    }

    void deleteNoCheckRollback(Session session, Object[] objectArray, boolean bl) throws HsqlException {
        Node node = this.getIndex(0).search(objectArray);
        Row row = node.getRow();
        for (int i = this.getIndexCount() - 1; i >= 0; --i) {
            node = row.getNode(i);
            this.getIndex(i).delete(node);
        }
        row = row.getUpdatedRow();
        row.delete();
        if (bl && !this.isTemp && !this.isText && !this.isReadOnly && this.database.logger.hasLog()) {
            this.database.logger.writeDeleteStatement(session, this, objectArray);
        }
    }

    int update(Session session, HashMappedList hashMappedList, int[] nArray) throws HsqlException {
        Object[] objectArray;
        Object object;
        Object[] objectArray2;
        int n;
        HashSet hashSet = this.constraintPath == null ? new HashSet() : this.constraintPath;
        this.constraintPath = null;
        HashMappedList hashMappedList2 = this.tableUpdateList == null ? new HashMappedList() : this.tableUpdateList;
        this.tableUpdateList = null;
        for (n = 0; n < hashMappedList.size(); ++n) {
            objectArray2 = (Object[])hashMappedList.get(n);
            this.setIdentityColumn(session, objectArray2);
            this.enforceFieldValueLimits(objectArray2, nArray);
            this.enforceNullConstraints(objectArray2);
        }
        if (this.database.isReferentialIntegrity()) {
            for (n = 0; n < hashMappedList.size(); ++n) {
                objectArray2 = (Object[])hashMappedList.get(n);
                object = (Row)hashMappedList.getKey(n);
                Table.checkCascadeUpdate(session, this, hashMappedList2, (Row)object, objectArray2, nArray, null, hashSet);
            }
        }
        this.fireAll(session, 5);
        HashMappedList hashMappedList3 = (HashMappedList)hashMappedList2.get(this);
        if (hashMappedList3 != null) {
            for (int i = 0; i < hashMappedList3.size(); ++i) {
                object = (Row)hashMappedList3.getKey(i);
                objectArray = (Object[])hashMappedList3.get(i);
                Table.mergeKeepUpdate(hashMappedList, nArray, (Row)object, objectArray);
            }
            hashMappedList3.clear();
        }
        for (int i = 0; i < hashMappedList2.size(); ++i) {
            object = (Table)hashMappedList2.getKey(i);
            objectArray = (HashMappedList)hashMappedList2.get(i);
            ((Table)object).updateRowSet(session, (HashMappedList)objectArray, null, false);
            objectArray.clear();
        }
        this.updateRowSet(session, hashMappedList, nArray, true);
        this.fireAll(session, 2);
        hashSet.clear();
        this.constraintPath = hashSet;
        this.tableUpdateList = hashMappedList2;
        Table.clearUpdateLists(this.tableUpdateList);
        return hashMappedList.size();
    }

    void updateRowSet(Session session, HashMappedList hashMappedList, int[] nArray, boolean bl) throws HsqlException {
        Object[] objectArray;
        Row row;
        int n;
        for (n = hashMappedList.size() - 1; n >= 0; --n) {
            row = (Row)hashMappedList.getKey(n);
            objectArray = (Object[])hashMappedList.get(n);
            if (row.isDeleted()) {
                if (bl) {
                    throw Trace.error(199);
                }
                hashMappedList.remove(n);
                continue;
            }
            for (int i = 0; i < this.constraintList.length; ++i) {
                Constraint constraint = this.constraintList[i];
                if (constraint.getType() != 3) continue;
                constraint.checkCheckConstraint(session, objectArray);
            }
            this.deleteNoCheck(session, row, true);
        }
        for (n = 0; n < hashMappedList.size(); ++n) {
            row = (Row)hashMappedList.getKey(n);
            objectArray = (Object[])hashMappedList.get(n);
            if (this.triggerLists[11] != null) {
                this.fireAll(session, 11, row.getData(), objectArray);
                this.checkRowDataUpdate(session, objectArray, nArray);
            }
            this.insertNoCheck(session, objectArray);
            if (this.triggerLists[8] == null) continue;
            this.fireAll(session, 8, row.getData(), objectArray);
            this.checkRowDataUpdate(session, objectArray, nArray);
        }
    }

    void checkRowDataInsert(Session session, Object[] objectArray) throws HsqlException {
        this.enforceFieldValueLimits(objectArray);
        this.enforceNullConstraints(objectArray);
        if (this.database.isReferentialIntegrity()) {
            int n = this.constraintList.length;
            for (int i = 0; i < n; ++i) {
                this.constraintList[i].checkInsert(session, objectArray);
            }
        }
    }

    void checkRowDataUpdate(Session session, Object[] objectArray, int[] nArray) throws HsqlException {
        this.enforceFieldValueLimits(objectArray, nArray);
        this.enforceNullConstraints(objectArray);
        for (int i = 0; i < this.constraintList.length; ++i) {
            Constraint constraint = this.constraintList[i];
            if (constraint.getType() != 3) continue;
            constraint.checkCheckConstraint(session, objectArray);
        }
    }

    boolean isCached() {
        return this.isCached;
    }

    boolean isIndexCached() {
        return this.isCached;
    }

    Index getIndex(String string) {
        for (int i = 0; i < this.getIndexCount(); ++i) {
            Index index = this.getIndex(i);
            if (!string.equals(index.getName().name)) continue;
            return index;
        }
        return null;
    }

    int getConstraintIndex(String string) {
        int n = this.constraintList.length;
        for (int i = 0; i < n; ++i) {
            if (!this.constraintList[i].getName().name.equals(string)) continue;
            return i;
        }
        return -1;
    }

    Constraint getConstraint(String string) {
        int n = this.getConstraintIndex(string);
        return n < 0 ? null : this.constraintList[n];
    }

    Column getColumn(int n) {
        return (Column)this.columnList.get(n);
    }

    void renameColumn(Column column, String string, boolean bl) throws HsqlException {
        String string2 = column.columnName.name;
        int n = this.getColumnNr(string2);
        this.columnList.setKey(n, string);
        column.columnName.rename(string, bl);
        this.renameColumnInCheckConstraints(string2, string, bl);
    }

    public int[] getColumnTypes() {
        return this.colTypes;
    }

    protected Index getIndex(int n) {
        return (Index)this.indexList.get(n);
    }

    CachedRow getRow(int n, Node node) throws HsqlException {
        if (this.isCached) {
            return this.cache.getRow(n, this);
        }
        return null;
    }

    void addRowToStore(Row row) throws HsqlException {
        if (this.isCached && this.cache != null) {
            this.cache.add((CachedRow)row);
        } else if (this.needsRowID) {
            row.getData()[this.visibleColumnCount] = ValuePool.getInt((int)this.rowIdSequence.getValue());
        }
    }

    void registerRow(CachedRow cachedRow) {
        if (this.needsRowID) {
            cachedRow.getData()[this.visibleColumnCount] = new Integer(cachedRow.iPos);
        }
    }

    void removeRow(CachedRow cachedRow) throws HsqlException {
        if (this.cache != null) {
            this.cache.free(cachedRow);
        }
    }

    void indexRow(Row row) throws HsqlException {
        int n;
        try {
            Node node = null;
            for (n = 0; n < this.getIndexCount(); ++n) {
                node = row.getNextNode(node);
                this.getIndex(n).insert(node);
            }
        }
        catch (HsqlException hsqlException) {
            Object object;
            Index index = this.getIndex(n);
            boolean bl = index.isConstraint;
            --n;
            while (n >= 0) {
                object = row.getNode(n);
                this.getIndex(n).delete((Node)object);
                --n;
            }
            row = row.getUpdatedRow();
            row.delete();
            if (bl) {
                object = this.getConstraintForIndex(index);
                String string = object == null ? DEFAULT_PK : ((Constraint)object).getName().name;
                throw Trace.error(104, string);
            }
            throw hsqlException;
        }
    }

    void clearAllRows() {
        for (int i = 0; i < this.getIndexCount(); ++i) {
            this.getIndex(i).setRoot(null);
        }
        this.identitySequence.reset();
        this.rowIdSequence.reset();
    }

    void drop() throws HsqlException {
        if (this.cache != null && !this.isEmpty()) {
            this.cache.remove(this);
        }
    }

    boolean isWritable() {
        return !this.isReadOnly && !this.database.databaseReadOnly && (!this.database.isFilesReadOnly() || !this.isCached && !this.isText);
    }

    String getCatalogName() {
        return this.database.getProperties().isPropertyTrue("hsqldb.catalogs") ? this.database.getURI() : null;
    }

    String getSchemaName() {
        if (!this.database.getProperties().isPropertyTrue("hsqldb.schemas")) {
            return null;
        }
        switch (this.tableType) {
            case 0: {
                return "DEFINITION_SCHEMA";
            }
            case 8: {
                return "INFORMATION_SCHEMA";
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                return "PUBLIC";
            }
            case 2: 
            case 5: {
                Session session = this.database.sessionManager.getSession(this.ownerSessionId);
                if (session == null) {
                    return null;
                }
                if (session.getId() == this.ownerSessionId) {
                    return session.getUsername();
                }
                return null;
            }
        }
        return null;
    }

    public int getRowCount() throws HsqlException {
        return this.getPrimaryIndex().size();
    }
}

